/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.server;

import io.github.mortuusars.exposure.util.TranslatableError;
import io.github.mortuusars.exposure.world.camera.CameraId;
import java.util.Optional;
import net.minecraft.class_1937;

public class CameraInstance {
    protected final CameraId cameraId;
    private int deferredCooldownTicks = 0;
    private long projectionDeadline = -1L;
    private ProjectionState projectionState = ProjectionState.IDLE;
    private Optional<TranslatableError> projectionError = Optional.empty();

    public CameraInstance(CameraId cameraId) {
        this.cameraId = cameraId;
    }

    public int getDeferredCooldown() {
        return this.deferredCooldownTicks;
    }

    public void setDeferredCooldown(int ticks) {
        this.deferredCooldownTicks = ticks;
    }

    public ProjectionState getProjectionState(class_1937 level) {
        if (this.isWaitingForProjection() && this.isProjectionTimedOut(level)) {
            return ProjectionState.TIMED_OUT;
        }
        return this.projectionState;
    }

    public Optional<TranslatableError> getProjectionError(class_1937 level) {
        if (this.isWaitingForProjection() && this.isProjectionTimedOut(level)) {
            return Optional.of(TranslatableError.TIMED_OUT);
        }
        return this.projectionError;
    }

    public long getProjectionDeadline() {
        return this.projectionDeadline;
    }

    public void waitForProjection(long deadline) {
        this.projectionDeadline = deadline;
    }

    public boolean isWaitingForProjection() {
        return this.projectionDeadline >= 0L;
    }

    public boolean isProjectionTimedOut(class_1937 level) {
        return level.method_8510() > this.projectionDeadline;
    }

    public void setProjectionResult(class_1937 level, boolean successful, Optional<TranslatableError> error) {
        if (this.isWaitingForProjection() && !this.isProjectionTimedOut(level)) {
            this.projectionState = successful ? ProjectionState.SUCCESSFUL : ProjectionState.FAILED;
            this.projectionDeadline = -1L;
            this.projectionError = error;
        }
    }

    public void stopWaitingForProjection() {
        this.projectionState = ProjectionState.IDLE;
        this.projectionDeadline = -1L;
        this.projectionError = Optional.empty();
    }

    public static enum ProjectionState {
        IDLE,
        WAITING,
        SUCCESSFUL,
        FAILED,
        TIMED_OUT;

    }
}

