/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.block;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.PlatformHelper;
import io.github.mortuusars.exposure.world.block.entity.LightroomBlockEntity;
import io.github.mortuusars.exposure.world.item.StackedPhotographsItem;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightroomBlock
extends class_2248
implements class_2343 {
    public static final class_2753 FACING = class_2383.field_11177;
    public static final class_2746 PRINTING = class_2746.method_11825((String)"printing");
    public static final class_2746 REFRACTED = class_2746.method_11825((String)"refracted");

    public LightroomBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)PRINTING, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)REFRACTED, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> pBuilder) {
        pBuilder.method_11667(new class_2769[]{FACING, PRINTING, REFRACTED});
    }

    public class_2680 method_9605(class_1750 pContext) {
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)pContext.method_8042().method_10153());
    }

    public void method_9536(class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, class_2680 newState, boolean isMoving) {
        if (!state.method_27852(newState.method_26204())) {
            class_2586 class_25862 = level.method_8321(pos);
            if (class_25862 instanceof LightroomBlockEntity) {
                LightroomBlockEntity lightroomBlockEntity = (LightroomBlockEntity)class_25862;
                if (level instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)level;
                    class_1264.method_5451((class_1937)serverLevel, (class_2338)pos, (class_1263)lightroomBlockEntity);
                    lightroomBlockEntity.dropStoredExperience(null);
                }
                level.method_8455(pos, (class_2248)this);
            }
            super.method_9536(state, level, pos, newState, isMoving);
        }
    }

    public boolean method_9498(@NotNull class_2680 state) {
        return true;
    }

    public int method_9572(@NotNull class_2680 blockState, class_1937 level, @NotNull class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof LightroomBlockEntity) {
            LightroomBlockEntity lightroomBlockEntity = (LightroomBlockEntity)class_25862;
            class_1799 resultStack = lightroomBlockEntity.method_5438(6);
            class_1792 class_17922 = resultStack.method_7909();
            if (class_17922 instanceof StackedPhotographsItem) {
                StackedPhotographsItem stackedPhotographsItem = (StackedPhotographsItem)class_17922;
                int photographsCount = stackedPhotographsItem.getPhotographs(resultStack).size();
                return (int)((float)photographsCount / (float)stackedPhotographsItem.getStackLimit() * 14.0f + 1.0f);
            }
            if (!resultStack.method_7960()) {
                return 1;
            }
        }
        return 0;
    }

    @NotNull
    public class_2680 method_9598(class_2680 pState, class_2470 pRotation) {
        return (class_2680)pState.method_11657((class_2769)FACING, (Comparable)pRotation.method_10503((class_2350)pState.method_11654((class_2769)FACING)));
    }

    @NotNull
    public class_2680 method_9569(class_2680 pState, class_2415 pMirror) {
        return pState.method_26186(pMirror.method_10345((class_2350)pState.method_11654((class_2769)FACING)));
    }

    @NotNull
    protected class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hitResult) {
        class_2586 class_25862 = level.method_8321(pos);
        if (!(class_25862 instanceof LightroomBlockEntity)) {
            return super.method_55766(state, level, pos, player, hitResult);
        }
        LightroomBlockEntity lightroomBlockEntity = (LightroomBlockEntity)class_25862;
        player.method_7281(Exposure.Stats.INTERACT_WITH_LIGHTROOM);
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            lightroomBlockEntity.setLastPlayer((class_1657)serverPlayer);
            lightroomBlockEntity.method_5431();
            PlatformHelper.openMenu(serverPlayer, (class_3908)lightroomBlockEntity, buffer -> buffer.method_10807(pos));
        }
        return class_1269.method_29236((boolean)level.field_9236);
    }

    public void method_9612(@NotNull class_2680 state, class_1937 level, @NotNull class_2338 pos, @NotNull class_2248 block, @NotNull class_2338 fromPos, boolean pIsMoving) {
        if (!level.field_9236) {
            if (!((Boolean)state.method_11654((class_2769)PRINTING)).booleanValue()) {
                for (class_2350 direction : class_2350.values()) {
                    class_2586 class_25862;
                    class_2338 relative = pos.method_10093(direction);
                    if (!relative.equals((Object)fromPos) || level.method_49808(relative, direction) <= 0 || !((class_25862 = level.method_8321(pos)) instanceof LightroomBlockEntity)) continue;
                    LightroomBlockEntity lightroomBlockEntity = (LightroomBlockEntity)class_25862;
                    lightroomBlockEntity.startPrintingProcess(true);
                    break;
                }
            }
            level.method_8652(pos, (class_2680)level.method_8320(pos).method_11657((class_2769)REFRACTED, (Comparable)Boolean.valueOf(level.method_8320(pos.method_10084()).method_26164(Exposure.Tags.Blocks.CHROMATIC_REFRACTORS))), 2);
        }
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return LightroomBlock.createBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> blockEntityType) {
        return LightroomBlock.getBlockTicker(level, state, blockEntityType);
    }

    public static class_2586 createBlockEntity(class_2338 pos, class_2680 state) {
        return new LightroomBlockEntity(pos, state);
    }

    public static <T extends class_2586> class_5558<T> getBlockTicker(class_1937 level, class_2680 state, class_2591<T> blockEntityType) {
        if (!level.field_9236 && blockEntityType.equals(Exposure.BlockEntityTypes.LIGHTROOM.get())) {
            return LightroomBlockEntity::serverTick;
        }
        return null;
    }
}

