/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.camera;

import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.network.packet.Packet;
import io.github.mortuusars.exposure.world.camera.CameraId;
import io.github.mortuusars.exposure.world.entity.CameraHolder;
import io.github.mortuusars.exposure.world.item.camera.Attachment;
import io.github.mortuusars.exposure.world.item.camera.CameraItem;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import org.slf4j.Logger;

public abstract class Camera {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected final CameraHolder holder;
    protected final CameraId id;

    public Camera(CameraHolder holder, CameraId id) {
        this.holder = holder;
        this.id = id;
    }

    public abstract class_1799 getItemStack();

    public abstract Packet createSyncPacket();

    public CameraHolder getHolder() {
        return this.holder;
    }

    public CameraId getId() {
        return this.id;
    }

    public void update() {
    }

    public boolean isEmpty() {
        return !(this.getItemStack().method_7909() instanceof CameraItem);
    }

    public boolean isActive() {
        return this.map(CameraItem::isActive, Boolean.valueOf(false));
    }

    public boolean inSelfieMode() {
        return this.map(CameraItem::isInSelfieMode).orElse(false);
    }

    public boolean idMatches(CameraId id) {
        return this.id.equals(id);
    }

    public boolean isShutterOpen() {
        return this.map((CameraItem item, class_1799 stack) -> item.getShutter().isOpen((class_1799)stack), Boolean.valueOf(false));
    }

    public boolean deactivate() {
        CameraItem cameraItem;
        class_1792 class_17922;
        class_1799 stack = this.getItemStack();
        if (this.getId().matches(stack) && (class_17922 = stack.method_7909()) instanceof CameraItem && (cameraItem = (CameraItem)class_17922).isActive(stack)) {
            cameraItem.deactivate(this.getHolder().asHolderEntity(), stack);
            return true;
        }
        return false;
    }

    public void release() {
        this.ifPresent((item, stack) -> item.release(this.getHolder(), this.getItemStack()), () -> LOGGER.error("Cannot take a shot: camera is not active. Camera Holder: {}", (Object)this.holder));
    }

    public Camera ifPresent(BiConsumer<CameraItem, class_1799> ifPresent) {
        class_1799 stack = this.getItemStack();
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof CameraItem) {
            CameraItem item = (CameraItem)class_17922;
            ifPresent.accept(item, stack);
        }
        return this;
    }

    public Camera ifPresent(BiConsumer<CameraItem, class_1799> ifPresent, Runnable orElse) {
        class_1799 stack = this.getItemStack();
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof CameraItem) {
            CameraItem item = (CameraItem)class_17922;
            ifPresent.accept(item, stack);
        } else {
            orElse.run();
        }
        return this;
    }

    public <T> Optional<T> map(Function<class_1799, T> map) {
        class_1799 stack = this.getItemStack();
        if (stack.method_7909() instanceof CameraItem) {
            return Optional.ofNullable(map.apply(stack));
        }
        return Optional.empty();
    }

    public <T> T map(Function<class_1799, T> map, T orElse) {
        class_1799 stack = this.getItemStack();
        if (stack.method_7909() instanceof CameraItem) {
            return map.apply(stack);
        }
        return orElse;
    }

    public <T> Optional<T> map(BiFunction<CameraItem, class_1799, T> map) {
        class_1799 stack = this.getItemStack();
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof CameraItem) {
            CameraItem item = (CameraItem)class_17922;
            return Optional.ofNullable(map.apply(item, stack));
        }
        return Optional.empty();
    }

    public <T> T map(BiFunction<CameraItem, class_1799, T> map, T orElse) {
        class_1799 stack = this.getItemStack();
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof CameraItem) {
            CameraItem item = (CameraItem)class_17922;
            return map.apply(item, stack);
        }
        return orElse;
    }

    public <T extends class_1792, R> Optional<R> mapAttachment(Attachment<T> attachment, BiFunction<T, class_1799, R> func) {
        if (this.getItemStack().method_7909() instanceof CameraItem) {
            return attachment.map(this.getItemStack(), func);
        }
        return Optional.empty();
    }
}

