/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.camera;

import com.mojang.serialization.Codec;
import io.github.mortuusars.exposure.util.color.Color;
import io.github.mortuusars.exposure.world.camera.FilmColor;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.function.IntFunction;
import net.minecraft.class_3542;
import net.minecraft.class_7995;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ExposureType implements class_3542
{
    COLOR("color", Color.rgb(180, 130, 110), new FilmColor(1.2f, 0.96f, 0.75f, 1.0f)),
    BLACK_AND_WHITE("black_and_white", Color.WHITE, new FilmColor(1.0f, 1.0f, 1.0f, 1.0f));

    public static final Codec<ExposureType> CODEC;
    public static final class_9139<ByteBuf, ExposureType> STREAM_CODEC;
    private final String name;
    private final Color imageColor;
    private final FilmColor filmColor;

    private ExposureType(String name, Color imageColor, FilmColor filmColor) {
        this.name = name;
        this.imageColor = imageColor;
        this.filmColor = filmColor;
    }

    @NotNull
    public String method_15434() {
        return this.name;
    }

    public Color getImageColor() {
        return this.imageColor;
    }

    public FilmColor getFilmColor() {
        return this.filmColor;
    }

    public static Optional<ExposureType> byName(@Nullable String name) {
        for (ExposureType type : ExposureType.values()) {
            if (!type.name().equals(name)) continue;
            return Optional.of(type);
        }
        return Optional.empty();
    }

    static {
        CODEC = class_3542.method_28140(ExposureType::values);
        STREAM_CODEC = class_9135.method_56375((IntFunction)class_7995.method_47914(Enum::ordinal, (Object[])ExposureType.values(), (class_7995.class_7996)class_7995.class_7996.field_41664), Enum::ordinal);
    }
}

