/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.camera.film.properties;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.data.ColorPalette;
import io.github.mortuusars.exposure.data.ColorPalettes;
import io.github.mortuusars.exposure.world.camera.ExposureType;
import io.github.mortuusars.exposure.world.camera.capture.DitherMode;
import io.github.mortuusars.exposure.world.camera.film.properties.FilmStyle;
import java.util.Optional;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record FilmProperties(ExposureType type, Optional<Integer> size, class_5321<ColorPalette> colorPalette, DitherMode ditherMode, FilmStyle style) {
    public static final Codec<FilmProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExposureType.CODEC.optionalFieldOf("type", (Object)ExposureType.COLOR).forGetter(FilmProperties::type), (App)class_5699.method_48766((int)0, (int)2048).optionalFieldOf("frame_size").forGetter(FilmProperties::size), (App)class_5321.method_39154(Exposure.Registries.COLOR_PALETTE).optionalFieldOf("color_palette", ColorPalettes.DEFAULT).forGetter(FilmProperties::colorPalette), (App)DitherMode.CODEC.optionalFieldOf("dither_mode", (Object)DitherMode.DITHERED).forGetter(FilmProperties::ditherMode), (App)FilmStyle.CODEC.optionalFieldOf("style", (Object)FilmStyle.EMPTY).forGetter(FilmProperties::style)).apply((Applicative)instance, FilmProperties::new));
    public static final class_9139<class_9129, FilmProperties> STREAM_CODEC = new class_9139<class_9129, FilmProperties>(){

        public void encode(class_9129 buffer, FilmProperties data) {
            ExposureType.STREAM_CODEC.encode((Object)buffer, (Object)data.type());
            class_9135.method_56382((class_9139)class_9135.field_48550).encode((Object)buffer, data.size());
            class_5321.method_56038(Exposure.Registries.COLOR_PALETTE).encode((Object)buffer, data.colorPalette());
            DitherMode.STREAM_CODEC.encode((Object)buffer, (Object)data.ditherMode());
            FilmStyle.STREAM_CODEC.encode((Object)buffer, (Object)data.style());
        }

        @NotNull
        public FilmProperties decode(class_9129 buffer) {
            return new FilmProperties((ExposureType)((Object)ExposureType.STREAM_CODEC.decode((Object)buffer)), (Optional)class_9135.method_56382((class_9139)class_9135.field_48550).decode((Object)buffer), (class_5321<ColorPalette>)((class_5321)class_5321.method_56038(Exposure.Registries.COLOR_PALETTE).decode((Object)buffer)), (DitherMode)((Object)DitherMode.STREAM_CODEC.decode((Object)buffer)), (FilmStyle)FilmStyle.STREAM_CODEC.decode((Object)buffer));
        }
    };
    public static final FilmProperties EMPTY = new FilmProperties(ExposureType.COLOR, Optional.empty(), ColorPalettes.DEFAULT, DitherMode.DITHERED, FilmStyle.EMPTY);

    public FilmProperties {
        size.ifPresent(s -> Preconditions.checkArgument((s > 0 && s <= 2048 ? 1 : 0) != 0, (Object)("size must be 1-2048: " + String.valueOf(size))));
    }

    public FilmProperties withType(ExposureType type) {
        return new FilmProperties(type, this.size, this.colorPalette, this.ditherMode, this.style);
    }

    public FilmProperties withSize(@Nullable Integer size) {
        return new FilmProperties(this.type, Optional.ofNullable(size), this.colorPalette, this.ditherMode, this.style);
    }

    public FilmProperties withColorPalette(@NotNull class_5321<ColorPalette> colorPalette) {
        return new FilmProperties(this.type, this.size, colorPalette, this.ditherMode, this.style);
    }

    public FilmProperties withDitherMode(DitherMode ditherMode) {
        return new FilmProperties(this.type, this.size, this.colorPalette, ditherMode, this.style);
    }

    public FilmProperties withStyle(@NotNull FilmStyle style) {
        return new FilmProperties(this.type, this.size, this.colorPalette, this.ditherMode, style);
    }

    public int getSize() {
        return this.size.orElse((Integer)Config.Server.DEFAULT_FRAME_SIZE.get());
    }

    public class_6880<ColorPalette> getColorPalette(class_5455 access) {
        return ColorPalettes.get(access, this.colorPalette);
    }
}

