/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.camera.frame;

import io.github.mortuusars.exposure.util.Fov;
import io.github.mortuusars.exposure.util.PointOfView;
import io.github.mortuusars.exposure.world.entity.CameraHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3959;

public class EntitiesInFrame {
    public static List<class_1309> get(CameraHolder cameraHolder, PointOfView pov, double fov) {
        return EntitiesInFrame.get(cameraHolder.asHolderEntity(), pov, fov);
    }

    public static List<class_1309> get(class_1297 cameraHolder, PointOfView pov, double fov) {
        double focalLength = Fov.fovToFocalLength(fov *= 0.95);
        class_238 area = new class_238(cameraHolder.method_24515()).method_1014(128.0);
        List entities = cameraHolder.method_37908().method_8335(null, area);
        FrustumCheck frustum = FrustumCheck.createFromCamera(pov.pos(), pov.dir(), (float)Math.toRadians(fov));
        entities.sort((entity, entity2) -> {
            double dist2;
            double dist1 = pov.pos().method_1022(entity.method_19538());
            if (dist1 == (dist2 = pov.pos().method_1022(entity2.method_19538()))) {
                return 0;
            }
            return dist1 > dist2 ? 1 : -1;
        });
        ArrayList<class_1309> entitiesInFrame = new ArrayList<class_1309>();
        for (class_1297 entity3 : entities) {
            class_1309 livingEntity;
            if (!(entity3 instanceof class_1309) || !(livingEntity = (class_1309)entity3).method_5805() || !frustum.contains(entity3.method_33571()) || EntitiesInFrame.calculateVisibleDistance(pov.pos(), entity3) > focalLength || !EntitiesInFrame.hasLineOfSight(pov.pos(), entity3)) continue;
            entitiesInFrame.add(livingEntity);
        }
        return entitiesInFrame;
    }

    public static double calculateVisibleDistance(class_243 cameraPos, class_1297 entity) {
        double distanceInBlocks = Math.sqrt(entity.method_5707(cameraPos));
        class_238 boundingBox = entity.method_5830();
        double size = boundingBox.method_995();
        if (Double.isNaN(size) || size == 0.0) {
            size = 0.1;
        }
        double sizeInfluence = (size - 1.0) * 0.6 + 1.0;
        double feelsRightInfluence = 1.15;
        return distanceInBlocks / sizeInfluence * feelsRightInfluence;
    }

    public static boolean hasLineOfSight(class_243 cameraPos, class_1297 entity) {
        return entity.method_37908().method_17742(new class_3959(cameraPos, entity.method_33571(), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, entity)).method_17783() == class_239.class_240.field_1333;
    }

    public static class FrustumCheck {
        private final class_243 cameraPos;
        private final class_243 forward;
        private final class_243 right;
        private final class_243 up;
        private final float fovRadians;

        public FrustumCheck(class_243 cameraPos, class_243 forward, class_243 right, class_243 up, float fovRadians) {
            this.cameraPos = cameraPos;
            this.forward = forward.method_1029();
            this.right = right.method_1029();
            this.up = up.method_1029();
            this.fovRadians = fovRadians;
        }

        public boolean contains(class_243 pos) {
            class_243 toEntity = pos.method_1020(this.cameraPos);
            double depth = toEntity.method_1026(this.forward);
            if (depth <= 0.0) {
                return false;
            }
            double horizontalOffset = toEntity.method_1026(this.right);
            double verticalOffset = toEntity.method_1026(this.up);
            double halfSize = depth * Math.tan(this.fovRadians / 2.0f);
            return Math.abs(horizontalOffset) <= halfSize && Math.abs(verticalOffset) <= halfSize;
        }

        public static FrustumCheck createFromCamera(class_243 cameraPos, class_243 lookVec, float fov) {
            class_243 forward = lookVec.method_1029();
            class_243 worldUp = new class_243(0.0, 1.0, 0.0);
            class_243 right = forward.method_1036(worldUp).method_1029();
            class_243 up = right.method_1036(forward).method_1029();
            return new FrustumCheck(cameraPos, forward, right, up, fov);
        }
    }
}

