/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.camera.frame;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.exposure.util.ExtraData;
import io.github.mortuusars.exposure.world.camera.ColorChannel;
import io.github.mortuusars.exposure.world.camera.ExposureType;
import io.github.mortuusars.exposure.world.camera.component.ShutterSpeed;
import io.github.mortuusars.exposure.world.camera.frame.EntityInFrame;
import io.github.mortuusars.exposure.world.camera.frame.Photographer;
import io.github.mortuusars.exposure.world.level.storage.ExposureIdentifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public record Frame(ExposureIdentifier identifier, ExposureType type, Photographer photographer, List<EntityInFrame> entitiesInFrame, ExtraData extraData) {
    public static final ExtraData.Type<Boolean> PROJECTED = ExtraData.Type.bool("projected");
    public static final ExtraData.Type<Boolean> CHROMATIC = ExtraData.Type.bool("chromatic");
    public static final ExtraData.Type<ColorChannel> COLOR_CHANNEL = ExtraData.Type.stringRepresentable("color_channel", ColorChannel::fromStringOrThrow);
    public static final ExtraData.Type<ShutterSpeed> SHUTTER_SPEED = ExtraData.Type.stringRepresentable("shutter_speed", ShutterSpeed::new);
    public static final ExtraData.Type<Long> TIMESTAMP = ExtraData.Type.longVal("timestamp");
    public static final ExtraData.Type<Integer> FOCAL_LENGTH = ExtraData.Type.intVal("focal_length");
    public static final ExtraData.Type<Boolean> FLASH = ExtraData.Type.bool("flash");
    public static final ExtraData.Type<Boolean> SELFIE = ExtraData.Type.bool("selfie");
    public static final ExtraData.Type<Boolean> ON_STAND = ExtraData.Type.bool("on_stand");
    public static final ExtraData.Type<class_243> POSITION = ExtraData.Type.vec3("pos");
    public static final ExtraData.Type<Float> PITCH = ExtraData.Type.floatVal("pitch");
    public static final ExtraData.Type<Float> YAW = ExtraData.Type.floatVal("yaw");
    public static final ExtraData.Type<Integer> LIGHT_LEVEL = ExtraData.Type.intVal("light_level");
    public static final ExtraData.Type<Integer> DAY_TIME = ExtraData.Type.intVal("day_time");
    public static final ExtraData.Type<class_2960> DIMENSION = ExtraData.Type.resourceLocation("dimension");
    public static final ExtraData.Type<class_2960> BIOME = ExtraData.Type.resourceLocation("biome");
    public static final ExtraData.Type<String> WEATHER = ExtraData.Type.string("weather");
    public static final ExtraData.Type<Boolean> IN_CAVE = ExtraData.Type.bool("in_cave");
    public static final ExtraData.Type<Boolean> UNDERWATER = ExtraData.Type.bool("underwater");
    public static final ExtraData.Type<List<class_2960>> STRUCTURES = ExtraData.Type.stringBasedList("structures", class_2960::method_60654, class_2960::toString);
    public static final Frame EMPTY = new Frame(ExposureIdentifier.EMPTY, ExposureType.COLOR, Photographer.EMPTY, Collections.emptyList(), ExtraData.EMPTY);
    public static final Codec<Frame> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExposureIdentifier.CODEC.fieldOf("identifier").forGetter(Frame::identifier), (App)ExposureType.CODEC.optionalFieldOf("type", (Object)ExposureType.COLOR).forGetter(Frame::type), (App)Photographer.CODEC.optionalFieldOf("photographer", (Object)Photographer.EMPTY).forGetter(Frame::photographer), (App)EntityInFrame.CODEC.listOf(0, 16).optionalFieldOf("entities_in_frame", Collections.emptyList()).forGetter(Frame::entitiesInFrame), (App)ExtraData.CODEC.optionalFieldOf("extra_data", (Object)ExtraData.EMPTY).forGetter(Frame::extraData)).apply((Applicative)instance, Frame::new));
    public static final class_9139<class_2540, Frame> STREAM_CODEC = new class_9139<class_2540, Frame>(){

        @NotNull
        public Frame decode(class_2540 buffer) {
            return new Frame((ExposureIdentifier)ExposureIdentifier.STREAM_CODEC.decode((Object)buffer), (ExposureType)((Object)ExposureType.STREAM_CODEC.decode((Object)buffer)), (Photographer)Photographer.STREAM_CODEC.decode((Object)buffer), (List)EntityInFrame.STREAM_CODEC.method_56433(class_9135.method_58000((int)16)).decode((Object)buffer), (ExtraData)((Object)ExtraData.STREAM_CODEC.decode((Object)buffer)));
        }

        public void encode(class_2540 buffer, Frame frame) {
            ExposureIdentifier.STREAM_CODEC.encode((Object)buffer, (Object)frame.identifier());
            ExposureType.STREAM_CODEC.encode((Object)buffer, (Object)frame.type());
            Photographer.STREAM_CODEC.encode((Object)buffer, (Object)frame.photographer);
            EntityInFrame.STREAM_CODEC.method_56433(class_9135.method_58000((int)16)).encode((Object)buffer, frame.entitiesInFrame());
            ExtraData.STREAM_CODEC.encode((Object)buffer, (Object)frame.extraData());
        }
    };

    public static Mutable create() {
        return new Mutable(EMPTY);
    }

    public static Frame intersect(ExposureIdentifier identifier, List<Frame> frames) {
        Mutable result = EMPTY.toMutable().setIdentifier(identifier);
        if (frames.isEmpty()) {
            return result.toImmutable();
        }
        result.setType(Frame.getCommonValueOrDefault(frames, Frame::type));
        result.setPhotographer(Frame.getCommonValueOrDefault(frames, Frame::photographer));
        List commonEntitiesInFrame = frames.stream().map(Frame::entitiesInFrame).map(HashSet::new).reduce((set1, set2) -> {
            set1.retainAll((Collection<?>)set2);
            return set1;
        }).map(ArrayList::new).orElse(new ArrayList());
        result.setEntitiesInFrame(commonEntitiesInFrame);
        ExtraData mergedTag = frames.stream().map(f -> f.extraData.copy()).reduce(new ExtraData(), ExtraData::merge);
        result.setTag(mergedTag);
        return result.toImmutable();
    }

    private static <V> V getCommonValueOrDefault(List<Frame> objects, Function<Frame, V> propertyGetter) {
        Object referenceValue = propertyGetter.apply(objects.getFirst());
        return objects.stream().allMatch(data -> propertyGetter.apply((Frame)data) == referenceValue) ? referenceValue : propertyGetter.apply(EMPTY);
    }

    private static <T, V> V getCommonValueOrElse(List<T> objects, Function<T, V> propertyGetter, V fallbackValue) {
        Object referenceValue = propertyGetter.apply(objects.getFirst());
        return objects.stream().allMatch(data -> propertyGetter.apply(data) == referenceValue) ? referenceValue : fallbackValue;
    }

    public boolean isTakenBy(class_1309 entity) {
        return this.photographer().matches((class_1297)entity);
    }

    public ExtraData getExtraDataForReading() {
        return this.extraData();
    }

    public boolean isProjected() {
        return this.getExtraDataForReading().get(PROJECTED).orElse(false);
    }

    public boolean isChromatic() {
        return this.getExtraDataForReading().get(CHROMATIC).orElse(false);
    }

    public Optional<ColorChannel> getColorChannel() {
        return this.getExtraDataForReading().get(COLOR_CHANNEL);
    }

    public boolean wasTakenWithChromaticFilter() {
        return this.getColorChannel().isPresent();
    }

    public Mutable toMutable() {
        return new Mutable(this);
    }

    public static class Mutable {
        private ExposureIdentifier identifier;
        private ExposureType type;
        private Photographer photographer;
        private List<EntityInFrame> entitiesInFrame;
        private ExtraData tag;

        public Mutable(Frame photographData) {
            this.identifier = photographData.identifier();
            this.type = photographData.type();
            this.photographer = photographData.photographer();
            this.entitiesInFrame = new ArrayList<EntityInFrame>(photographData.entitiesInFrame());
            this.tag = photographData.extraData().copy();
        }

        public ExposureIdentifier getIdentifier() {
            return this.identifier;
        }

        public Mutable setIdentifier(ExposureIdentifier identifier) {
            this.identifier = identifier;
            return this;
        }

        public ExposureType getType() {
            return this.type;
        }

        public Mutable setType(ExposureType type) {
            this.type = type;
            return this;
        }

        public Photographer getPhotographer() {
            return this.photographer;
        }

        public Mutable setPhotographer(@NotNull Photographer photographer) {
            this.photographer = photographer;
            return this;
        }

        public List<EntityInFrame> getEntitiesInFrame() {
            return this.entitiesInFrame;
        }

        public Mutable setEntitiesInFrame(List<EntityInFrame> entitiesInFrame) {
            this.entitiesInFrame = entitiesInFrame;
            return this;
        }

        public ExtraData getTag() {
            return this.tag;
        }

        public Mutable setTag(ExtraData tag) {
            this.tag = tag;
            return this;
        }

        public Mutable updateExtraData(Consumer<ExtraData> updater) {
            updater.accept(this.tag);
            return this;
        }

        public <T> Mutable addExtraData(ExtraData.Type<T> type, T value) {
            this.tag.put(type, value);
            return this;
        }

        public Mutable setChromatic(boolean chromatic) {
            return this.updateExtraData(tag -> tag.put(CHROMATIC, chromatic));
        }

        public Frame toImmutable() {
            return new Frame(this.identifier, this.type, this.photographer, this.entitiesInFrame, this.tag);
        }
    }
}

