/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.camera.frame;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.exposure.world.entity.CameraHolder;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_3544;
import net.minecraft.class_4844;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public final class Photographer {
    public static final Photographer EMPTY = new Photographer("", class_156.field_25140);
    public static final Codec<Photographer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("name", (Object)"").forGetter(Photographer::name), (App)class_4844.field_46588.optionalFieldOf("uuid", (Object)class_156.field_25140).forGetter(Photographer::uuid)).apply((Applicative)instance, Photographer::new));
    public static final class_9139<ByteBuf, Photographer> STREAM_CODEC = class_9139.method_56435((class_9139)class_9135.field_48554, Photographer::name, (class_9139)class_4844.field_48453, Photographer::uuid, Photographer::new);
    private final String name;
    private final UUID uuid;

    private Photographer(String name, UUID uuid) {
        this.name = name;
        this.uuid = uuid;
    }

    public Photographer(CameraHolder cameraHolder) {
        class_1297 owner = cameraHolder.getExposureAuthorEntity();
        this.name = owner instanceof class_1657 ? owner.method_5820() : class_1299.method_5890((class_1299)owner.method_5864()).toString();
        this.uuid = owner instanceof class_1657 ? owner.method_5667() : class_156.field_25140;
    }

    public boolean matches(class_1297 entity) {
        return this.uuid.equals(entity.method_5667());
    }

    public boolean isPlayer() {
        return !class_3544.method_57181((String)this.name) && !this.uuid.equals(class_156.field_25140);
    }

    public boolean isNPC() {
        return !class_3544.method_57181((String)this.name) && this.uuid.equals(class_156.field_25140);
    }

    public boolean isEmpty() {
        return this.equals(EMPTY);
    }

    public String name() {
        return this.name;
    }

    public UUID uuid() {
        return this.uuid;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Photographer that = (Photographer)obj;
        return Objects.equals(this.name, that.name) && Objects.equals(this.uuid, that.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.uuid);
    }

    public String toString() {
        return "Photographer[name=" + this.name + ", uuid=" + String.valueOf(this.uuid) + "]";
    }
}

