/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.inventory;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.util.supporter.Supporters;
import io.github.mortuusars.exposure.world.entity.CameraHolder;
import io.github.mortuusars.exposure.world.inventory.slot.FilteredSlot;
import io.github.mortuusars.exposure.world.item.camera.Attachment;
import io.github.mortuusars.exposure.world.item.camera.CameraItem;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3917;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public abstract class AbstractCameraAttachmentsMenu
extends class_1703 {
    public static final int SKIN_REGULAR_BUTTON_ID = 100;
    public static final int SKIN_GOLD_BUTTON_ID = 101;
    protected final class_1657 player;
    protected final CameraAccess cameraAccess;
    protected final List<Attachment<?>> attachments;
    protected boolean clientContentsInitialized;

    protected AbstractCameraAttachmentsMenu(@Nullable class_3917<?> menuType, int containerId, class_1661 playerInventory, CameraAccess cameraAccess) {
        super(menuType, containerId);
        this.player = playerInventory.field_7546;
        this.cameraAccess = cameraAccess;
        this.attachments = cameraAccess.map((i, s) -> i.getAttachments());
        class_1277 container = this.createAttachmentsContainer();
        this.addAttachmentSlots((class_1263)container);
        this.addPlayerSlots(playerInventory);
    }

    public CameraAccess getCamera() {
        return this.cameraAccess;
    }

    protected class_1799 getCameraStack() {
        return this.getCamera().getStack();
    }

    @NotNull
    protected class_1277 createAttachmentsContainer() {
        class_1799[] attachmentItems = (class_1799[])this.attachments.stream().map(attachment -> attachment.get(this.getCamera().getStack()).getCopy()).toArray(class_1799[]::new);
        class_1277 container = new class_1277(this, attachmentItems){

            public int method_5444() {
                return 1;
            }
        };
        container.method_5489(this::onContainerChanged);
        return container;
    }

    protected void onContainerChanged(class_1263 c) {
        for (int slotId = 0; slotId < c.method_5439(); ++slotId) {
            Attachment<?> attachment = this.attachments.get(slotId);
            attachment.set(this.getCamera().getStack(), c.method_5438(slotId));
        }
    }

    public void method_7610(int stateId, List<class_1799> items, class_1799 carried) {
        this.clientContentsInitialized = false;
        super.method_7610(stateId, items, carried);
        this.clientContentsInitialized = true;
    }

    protected void addAttachmentSlots(class_1263 container) {
        Map<Attachment<class_1792>, Vector2i> slotPositions = Map.of(Attachment.FILM, new Vector2i(13, 42), Attachment.FLASH, new Vector2i(147, 15), Attachment.LENS, new Vector2i(147, 43), Attachment.FILTER, new Vector2i(147, 71));
        for (int index = 0; index < this.attachments.size(); ++index) {
            Attachment<?> attachmentType = this.attachments.get(index);
            Vector2i pos = slotPositions.get(attachmentType);
            this.method_7621(new FilteredSlot(container, index, pos.x(), pos.y(), 1, this::onItemInSlotChanged, attachmentType.itemPredicate()));
        }
    }

    protected void addPlayerSlots(class_1661 playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.method_7621(new class_1735((class_1263)playerInventory, column + row * 9 + 9, column * 18 + 8, 103 + row * 18));
            }
        }
        for (int slot = 0; slot < 9; ++slot) {
            this.method_7621(new class_1735((class_1263)playerInventory, slot, slot * 18 + 8, 161));
        }
    }

    protected void onItemInSlotChanged(FilteredSlot.SlotChangedArgs args) {
        int slotId = args.slot().getSlotId();
        class_1799 newStack = args.newStack();
        Attachment<?> attachment = this.attachments.get(slotId);
        if (this.clientContentsInitialized) {
            if (!newStack.method_7960()) {
                attachment.playInsertSoundSided((class_1297)this.player);
            } else {
                attachment.playRemoveSoundSided((class_1297)this.player);
            }
            this.getCamera().apply((item, stack) -> item.actionPerformed((class_1799)stack, (CameraHolder)this.player));
        }
    }

    @NotNull
    public class_1799 method_7601(@NotNull class_1657 player, int slotIndex) {
        class_1799 itemstack = class_1799.field_8037;
        class_1735 clickedSlot = (class_1735)this.field_7761.get(slotIndex);
        if (clickedSlot.method_7681()) {
            class_1799 slotStack = clickedSlot.method_7677();
            itemstack = slotStack.method_7972();
            if (slotIndex < this.attachments.size() ? !this.method_7616(slotStack, this.attachments.size(), this.field_7761.size(), true) : !this.method_7616(slotStack, 0, this.attachments.size(), false)) {
                return class_1799.field_8037;
            }
            if (slotStack.method_7960()) {
                clickedSlot.method_7673(class_1799.field_8037);
            } else {
                clickedSlot.method_7668();
            }
        }
        return itemstack;
    }

    protected boolean method_7616(class_1799 movedStack, int startIndex, int endIndex, boolean reverseDirection) {
        boolean hasRemainder = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (movedStack.method_7946()) {
            while (!movedStack.method_7960() && !(reverseDirection ? i < startIndex : i >= endIndex)) {
                class_1735 slot = (class_1735)this.field_7761.get(i);
                class_1799 slotStack = slot.method_7677();
                if (!slotStack.method_7960() && class_1799.method_31577((class_1799)movedStack, (class_1799)slotStack)) {
                    int maxSize;
                    int j = slotStack.method_7947() + movedStack.method_7947();
                    if (j <= (maxSize = Math.min(slot.method_7675(), movedStack.method_7914()))) {
                        movedStack.method_7939(0);
                        slotStack.method_7939(j);
                        slot.method_7668();
                        hasRemainder = true;
                    } else if (slotStack.method_7947() < maxSize) {
                        movedStack.method_7934(maxSize - slotStack.method_7947());
                        slotStack.method_7939(maxSize);
                        slot.method_7668();
                        hasRemainder = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!movedStack.method_7960()) {
            int n = i = reverseDirection ? endIndex - 1 : startIndex;
            while (!(reverseDirection ? i < startIndex : i >= endIndex)) {
                class_1735 slot1 = (class_1735)this.field_7761.get(i);
                class_1799 movedStack1 = slot1.method_7677();
                if (movedStack1.method_7960() && slot1.method_7680(movedStack)) {
                    if (movedStack.method_7947() > slot1.method_7675()) {
                        slot1.method_53512(movedStack.method_7971(slot1.method_7675()));
                    } else {
                        slot1.method_53512(movedStack.method_7971(movedStack.method_7947()));
                    }
                    slot1.method_7668();
                    hasRemainder = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return hasRemainder;
    }

    public boolean method_7604(class_1657 player, int id) {
        if (Supporters.hasAccessToGoldenSkin(player.method_5667())) {
            if (id == 100) {
                this.getCamera().apply((i, s) -> s.method_57379(Exposure.DataComponents.CAMERA_GOLD, (Object)false));
                return true;
            }
            if (id == 101) {
                this.getCamera().apply((i, s) -> s.method_57379(Exposure.DataComponents.CAMERA_GOLD, (Object)true));
                return true;
            }
        }
        return false;
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.getCamera().apply((item, stack) -> item.setDisassembled((class_1799)stack, false));
    }

    public static interface CameraAccess {
        public class_1799 getStack();

        default public void apply(BiConsumer<CameraItem, class_1799> consumer) {
            class_1799 camera = this.getStack();
            consumer.accept((CameraItem)camera.method_7909(), camera);
        }

        default public <T> T map(BiFunction<CameraItem, class_1799, T> func) {
            class_1799 camera = this.getStack();
            return func.apply((CameraItem)camera.method_7909(), camera);
        }
    }
}

