/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.item;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureServer;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.clientbound.CreateChromaticExposureS2CP;
import io.github.mortuusars.exposure.world.camera.ColorChannel;
import io.github.mortuusars.exposure.world.camera.ExposureType;
import io.github.mortuusars.exposure.world.camera.frame.Frame;
import io.github.mortuusars.exposure.world.level.storage.ExposureData;
import io.github.mortuusars.exposure.world.level.storage.ExposureIdentifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class ChromaticSheetItem
extends class_1792 {
    public ChromaticSheetItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public List<Frame> getLayers(class_1799 stack) {
        return (List)stack.method_57825(Exposure.DataComponents.CHROMATIC_SHEET_LAYERS, Collections.emptyList());
    }

    public void addLayer(class_1799 stack, Frame frame) {
        ArrayList<Frame> layers = new ArrayList<Frame>(this.getLayers(stack));
        Preconditions.checkState((layers.size() < 3 ? 1 : 0) != 0, (Object)"Cannot add layer. Chromatic Sheet already has 3 layers.");
        layers.add(frame);
        stack.method_57379(Exposure.DataComponents.CHROMATIC_SHEET_LAYERS, layers);
    }

    public boolean canCombine(class_1799 stack) {
        return this.getLayers(stack).size() >= 3;
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        List<Frame> layers = this.getLayers(stack);
        if (!layers.isEmpty()) {
            class_5250 component = class_2561.method_43471((String)"gui.exposure.channel.red").method_27696(class_2583.field_24360.method_36139(ColorChannel.RED.getRepresentationColor()));
            if (layers.size() >= 2) {
                component.method_10852((class_2561)class_2561.method_43471((String)"gui.exposure.channel.separator").method_27692(class_124.field_1080));
                component.method_10852((class_2561)class_2561.method_43471((String)"gui.exposure.channel.green").method_27696(class_2583.field_24360.method_36139(ColorChannel.GREEN.getRepresentationColor())));
            }
            if (layers.size() >= 3) {
                component.method_10852((class_2561)class_2561.method_43471((String)"gui.exposure.channel.separator").method_27692(class_124.field_1080));
                component.method_10852((class_2561)class_2561.method_43471((String)"gui.exposure.channel.blue").method_27696(class_2583.field_24360.method_36139(ColorChannel.BLUE.getRepresentationColor())));
            }
            tooltipComponents.add((class_2561)component);
            if (layers.size() >= 3) {
                tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.exposure.chromatic_sheet.use_tooltip").method_27692(class_124.field_1080));
            } else {
                tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.exposure.chromatic_sheet.info").method_27692(class_124.field_1080));
            }
        }
    }

    public void method_7888(class_1799 stack, class_1937 level, class_1297 entity, int slotId, boolean isSelected) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            if (this.canCombine(stack)) {
                boolean printed = ((class_9279)stack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57450("printed");
                class_1799 finalizedItem = this.combineIntoPhotograph(player, stack, printed);
                player.method_31548().method_5447(slotId, finalizedItem);
            }
        }
    }

    public class_1799 combineIntoPhotograph(@NotNull class_3222 player, class_1799 stack, boolean printed) {
        Preconditions.checkState((boolean)this.canCombine(stack), (Object)("Combining Chromatic Sheet requires 3 layers. " + String.valueOf(stack)));
        String exposureId = ExposureIdentifier.createId((class_1297)player, "chromatic");
        List<Frame> layers = this.getLayers(stack);
        List<ExposureIdentifier> layersIdentifiers = layers.stream().map(Frame::identifier).toList();
        class_1799 photographStack = this.createPhotographStack(ExposureIdentifier.id(exposureId), layers);
        ExposureServer.exposureRepository().expect(player, exposureId, (pl, id) -> ExposureServer.exposureRepository().update((String)id, exposure -> exposure.withTag((Function<ExposureData.Tag, ExposureData.Tag>)((Function)tag -> tag.withWasPrintedSetTo(printed)))));
        Packets.sendToClient(new CreateChromaticExposureS2CP(exposureId, layersIdentifiers), player);
        return photographStack;
    }

    protected class_1799 createPhotographStack(ExposureIdentifier identifier, List<Frame> layers) {
        Frame frameData = Frame.intersect(identifier, layers);
        frameData = frameData.toMutable().setType(ExposureType.COLOR).setChromatic(true).toImmutable();
        class_1799 photographStack = new class_1799((class_1935)Exposure.Items.PHOTOGRAPH.get());
        photographStack.method_57379(Exposure.DataComponents.PHOTOGRAPH_FRAME, (Object)frameData);
        photographStack.method_57379(Exposure.DataComponents.PHOTOGRAPH_TYPE, (Object)ExposureType.COLOR);
        return photographStack;
    }
}

