/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.item.camera;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.world.block.FlashBlock;
import io.github.mortuusars.exposure.world.camera.component.FlashMode;
import io.github.mortuusars.exposure.world.entity.CameraHolder;
import io.github.mortuusars.exposure.world.item.camera.Attachment;
import io.github.mortuusars.exposure.world.item.camera.CameraSettings;
import io.github.mortuusars.exposure.world.sound.Sound;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class Flash {
    public int getCooldown() {
        return 10;
    }

    public boolean isAvailable(class_1799 camera) {
        return Attachment.FLASH.isPresent(camera);
    }

    public boolean shouldFire(class_1799 camera, int lightLevel) {
        return switch (CameraSettings.FLASH_MODE.getOrDefault(camera)) {
            default -> throw new MatchException(null, null);
            case FlashMode.OFF -> false;
            case FlashMode.ON -> true;
            case FlashMode.AUTO -> lightLevel < 8;
        };
    }

    public boolean fire(CameraHolder holder, class_3218 level, class_1799 stack) {
        class_1297 entity = holder.asHolderEntity();
        @Nullable class_2338 flashPosition = this.findPosition(holder);
        if (flashPosition == null) {
            return false;
        }
        level.method_8652(flashPosition, (class_2680)Exposure.Blocks.FLASH.get().method_9564().method_11657((class_2769)FlashBlock.WATERLOGGED, (Comparable)Boolean.valueOf(level.method_8316(flashPosition).method_33659((class_3611)class_3612.field_15910))), 11);
        Sound.play(entity, this.getSound(), entity.method_5634());
        entity.method_32876((class_6880)class_5712.field_28727);
        holder.getServerPlayerAwardedForExposure().ifPresent(player -> player.method_7281(Exposure.Stats.FLASHES_TRIGGERED));
        this.sendParticles(holder, level);
        return true;
    }

    @Nullable
    protected class_2338 findPosition(CameraHolder holder) {
        class_1297 entity = holder.asHolderEntity();
        class_2338 headPos = entity.method_24515().method_10084();
        if (this.isPositionSuitable(entity.method_37908(), headPos)) {
            return headPos;
        }
        for (class_2350 direction : class_2350.values()) {
            class_2338 relative = headPos.method_10093(direction);
            if (!this.isPositionSuitable(entity.method_37908(), relative)) continue;
            return relative;
        }
        return null;
    }

    protected boolean isPositionSuitable(class_1937 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        return state.method_26215() || state.method_27852(class_2246.field_10382) && level.method_8316(pos).method_33659((class_3611)class_3612.field_15910);
    }

    protected void sendParticles(CameraHolder holder, class_3218 level) {
        class_243 pos = this.getFlashEffectsPosition(holder);
        @Nullable class_3222 executingPlayer = holder.getServerPlayerExecutingExposure().orElse(null);
        level.method_18456().stream().filter(player -> !player.equals((Object)executingPlayer) && player.method_5739(holder.asHolderEntity()) < 128.0f).forEach(player -> {
            level.method_14166(player, (class_2394)class_2398.field_17909, false, pos.field_1352, pos.field_1351, pos.field_1350, 0, 0.0, 0.0, 0.0, 0.0);
            level.method_14166(player, (class_2394)class_2398.field_11207, false, pos.field_1352, pos.field_1351, pos.field_1350, 4, 0.2, 0.2, 0.2, 0.1);
        });
    }

    protected class_243 getFlashEffectsPosition(CameraHolder holder) {
        return holder.asHolderEntity().method_19538().method_1031(0.0, 1.1, 0.0).method_1019(holder.asHolderEntity().method_5720().method_1021(0.8));
    }

    public class_3414 getSound() {
        return Exposure.SoundEvents.FLASH.get();
    }
}

