/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.api.iitem;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import sweetmagic.api.iblock.IFoodExpBlock;
import sweetmagic.api.iitem.IPorch;
import sweetmagic.api.iitem.info.FoodInfo;
import sweetmagic.config.SMConfig;
import sweetmagic.init.ItemInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.capability.icap.ICookingStatus;
import sweetmagic.util.PlayerHelper;
import sweetmagic.util.WorldHelper;

public interface IFood {
    public static final String QUALITY = "qualityValue";

    default public int setQuality(BlockPos pos, Player player, ItemStack stack, float baseChance) {
        IPorch porch;
        Item item;
        if (!this.isQuality() || !((Boolean)SMConfig.foodQuality.get()).booleanValue()) {
            return 0;
        }
        int cookLevel = ICookingStatus.getState((LivingEntity)player).getCookLevel();
        int foodLevel = this.getFoodLevel();
        Random rand = new Random();
        float chance = rand.nextFloat() + baseChance;
        int difValue = cookLevel - foodLevel;
        int qualityValue = 0;
        int count = 0;
        Level world = player.m_9236_();
        ArrayList<IFoodExpBlock> blockList = new ArrayList<IFoodExpBlock>();
        Iterable<BlockPos> posList = WorldHelper.getRangePos(pos, 16.0);
        ItemStack leg = player.m_6844_(EquipmentSlot.LEGS);
        for (BlockPos p : posList) {
            IFoodExpBlock fb;
            Block block = world.m_8055_(p).m_60734_();
            if (!(block instanceof IFoodExpBlock) || !(fb = (IFoodExpBlock)block).isChanceUp() || !blockList.contains(fb)) continue;
            if (count++ >= 3) break;
            blockList.add(fb);
        }
        chance += (float)count * 0.05f;
        if (!leg.m_41619_() && (item = leg.m_41720_()) instanceof IPorch && (porch = (IPorch)item).hasAcce(leg, ItemInit.mysterious_fork)) {
            chance += 0.1f;
        }
        if (difValue <= -3) {
            qualityValue = 0;
        } else if (difValue >= 3) {
            float difChance = 1.0f - 0.05f * (float)(difValue - 3);
            qualityValue = chance >= difChance ? 4 : 3;
        }
        switch (difValue) {
            case -2: {
                qualityValue = chance >= 0.75f ? 1 : 0;
                break;
            }
            case -1: {
                if (chance >= 0.9f) {
                    qualityValue = 2;
                    break;
                }
                if (!(chance >= 0.5f)) break;
                qualityValue = 1;
                break;
            }
            case 0: {
                if (chance >= 0.75f) {
                    qualityValue = 2;
                    break;
                }
                if (!(chance >= 0.25f)) break;
                qualityValue = 1;
                break;
            }
            case 1: {
                qualityValue = 1;
                if (chance >= 0.9f) {
                    qualityValue = 3;
                    break;
                }
                if (!(chance >= 0.5f)) break;
                qualityValue = 2;
                break;
            }
            case 2: {
                qualityValue = 1;
                if (chance >= 0.75f) {
                    qualityValue = 3;
                    break;
                }
                if (!(chance >= 0.25f)) break;
                qualityValue = 2;
            }
        }
        if (player.m_5446_().getString().equals("Konohairoha") && stack.m_150930_(ItemInit.omelet_rice)) {
            qualityValue = 4;
        }
        return qualityValue;
    }

    public static void getExpValue(Player player, FoodInfo info, int count) {
        IPorch portch;
        Item item;
        if (!((Boolean)SMConfig.foodQuality.get()).booleanValue()) {
            return;
        }
        IFood food = info.getFood();
        ICookingStatus cookStatus = ICookingStatus.getState((LivingEntity)player);
        int cookLevel = cookStatus.getCookLevel();
        int foodLevel = food.getFoodLevel();
        int difValue = cookLevel - foodLevel;
        float expRate = 1.0f * (float)count;
        int expValue = food.getExpValue();
        int expMinValue = food.getMinExpValue();
        ItemStack leg = player.m_6844_(EquipmentSlot.LEGS);
        if (!leg.m_41619_() && (item = leg.m_41720_()) instanceof IPorch && (portch = (IPorch)item).hasAcce(leg, ItemInit.mysterious_fork)) {
            expValue = (int)((double)expValue * 1.25);
            expMinValue = (int)((double)expMinValue * 1.1);
        }
        if (difValue > 0 && cookLevel <= 10) {
            cookStatus.addExp((int)Math.max((float)expValue * Math.min(expRate - (float)(difValue * 2), 0.1f), Math.max(1.0f, (float)expMinValue * 0.5f) * (float)count));
        } else {
            cookStatus.addExp((int)Math.max((float)expValue * (expRate + (float)difValue), Math.max(1.0f, (float)expMinValue * 0.75f) * (float)count));
        }
    }

    default public FoodProperties foodBuild(ItemStack stack, int healAmount, float saturation) {
        int qualityValue = this.getQualityValue(stack);
        switch (qualityValue) {
            case 1: 
            case 2: {
                healAmount = (int)((float)healAmount * 1.1f);
                saturation *= 1.1f;
                break;
            }
            case 3: {
                healAmount = (int)((float)healAmount * 1.25f);
                saturation *= 1.25f;
                break;
            }
            case 4: {
                healAmount = (int)((float)healAmount * 1.5f);
                saturation *= 1.5f;
            }
        }
        return new FoodProperties.Builder().m_38760_(healAmount).m_38758_(saturation).m_38765_().m_38767_();
    }

    default public void addPotion(LivingEntity entity, ItemStack stack, int level) {
        PotionInfo info = this.getPotionInfo();
        switch (level) {
            case 2: {
                PlayerHelper.setPotion(entity, info.potion(), info.level(), info.time());
                break;
            }
            case 3: 
            case 4: {
                PlayerHelper.setPotion(entity, info.potion(), info.level(), (int)((float)info.time() * 1.5f));
            }
        }
    }

    default public int getQualityValue(ItemStack stack) {
        if (!this.isQuality()) {
            return 0;
        }
        return this.getNBT(stack).m_128451_(QUALITY);
    }

    default public void setQualityValue(ItemStack stack, int value) {
        if (!this.isQuality()) {
            return;
        }
        this.getNBT(stack).m_128405_(QUALITY, value);
    }

    default public CompoundTag getNBT(ItemStack stack) {
        CompoundTag tags = stack.m_41783_();
        if (tags == null) {
            tags = new CompoundTag();
            stack.m_41751_(tags);
            tags.m_128405_(QUALITY, 0);
        } else if (!tags.m_128441_(QUALITY)) {
            tags.m_128405_(QUALITY, 0);
        }
        return tags;
    }

    default public int getExpValue() {
        return switch (this.getFoodLevel()) {
            case 2 -> 2;
            case 3 -> 6;
            case 4 -> 13;
            case 5 -> 20;
            case 6 -> 28;
            case 7 -> 36;
            case 8 -> 50;
            default -> 1;
        };
    }

    default public int getMinExpValue() {
        return this.getFoodLevel();
    }

    public boolean isQuality();

    public void setFoodLevel(int var1);

    public int getFoodLevel();

    public FoodType getFoodType();

    default public PotionInfo getPotionInfo() {
        switch (this.getFoodType()) {
            case Fermentation: {
                return new PotionInfo(PotionInit.reflash_effect, 0, 600);
            }
            case Baked: {
                return new PotionInfo(PotionInit.mfcostdown, 0, 1200);
            }
            case Simmered: {
                return new PotionInfo(PotionInit.critical_increase, 0, 1200);
            }
            case Stir: {
                return new PotionInfo(PotionInit.damage_cut, 0, 1200);
            }
            case Fried: {
                return new PotionInfo(PotionInit.recast_reduction, 0, 600);
            }
            case Rice: {
                return new PotionInfo(MobEffects.f_19617_, 2, 1200);
            }
            case Fish: {
                return new PotionInfo(MobEffects.f_19592_, 0, 600);
            }
            case Bread: {
                return new PotionInfo(MobEffects.f_19598_, 0, 1200);
            }
            case Japanese: {
                return new PotionInfo(PotionInit.aether_armor, 0, 1200);
            }
            case Western: {
                return new PotionInfo(PotionInit.aether_barrier, 0, 1200);
            }
            case Cookie: {
                return new PotionInfo(PotionInit.resistance_blow, 1, 1200);
            }
            case Cake: {
                return new PotionInfo(PotionInit.mfcostdown, 0, 1200);
            }
            case Chilling: {
                return new PotionInfo(PotionInit.increased_recovery, 0, 1200);
            }
            case Salad: {
                return new PotionInfo(PotionInit.regeneration, 0, 200);
            }
            case WITCH: {
                return new PotionInfo(PotionInit.magic_rangeup, 0, 1200);
            }
            case DEVIL: {
                return new PotionInfo(PotionInit.debuff_duration_increase, 0, 1200);
            }
        }
        return new PotionInfo(PotionInit.increased_experience, 0, 1200);
    }

    public static IFood getFood(ItemStack stack) {
        return (IFood)stack.m_41720_();
    }

    public record PotionInfo(MobEffect potion, int level, int time) {
    }

    public static enum FoodType {
        Fermentation,
        Baked,
        Simmered,
        Stir,
        Fried,
        Rice,
        Fish,
        Bread,
        Japanese,
        Western,
        Cookie,
        Cake,
        Chilling,
        Salad,
        Drink,
        WITCH,
        DEVIL;

    }
}

