/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.api.iitem;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import sweetmagic.api.SweetMagicAPI;
import sweetmagic.api.iblock.ITileMF;

public interface IMFTool {
    public static final String MF = "mf";

    public int getMaxMF(ItemStack var1);

    public void setMaxMF(int var1);

    default public CompoundTag getNBT(ItemStack stack) {
        CompoundTag tags = stack.m_41783_();
        if (tags == null) {
            tags = new CompoundTag();
            tags.m_128405_(MF, 0);
            stack.m_41751_(tags);
        }
        return tags;
    }

    default public int getMF(ItemStack stack) {
        return this.getNBT(stack).m_128451_(MF);
    }

    default public void setMF(ItemStack stack, int expValue) {
        this.getNBT(stack).m_128405_(MF, Math.max(0, expValue));
    }

    default public boolean isMaxMF(ItemStack stack) {
        return this.getMF(stack) >= this.getMaxMF(stack);
    }

    default public int getMFProgressScaled(ItemStack stack, int value) {
        int maxMF = this.getMaxMF(stack);
        if (maxMF <= 0) {
            return value;
        }
        return Math.min(value, value * this.getMF(stack) / this.getMaxMF(stack));
    }

    default public void insertMF(ItemStack stack, ITileMF tile) {
        int useMF;
        int mf = this.getMF(stack);
        int sumMF = mf + (useMF = tile.getShrinkMF() > tile.getMF() ? tile.getMF() : tile.getShrinkMF());
        if (sumMF <= this.getMaxMF(stack)) {
            this.setMF(stack, sumMF);
            tile.setMF(tile.getMF() - useMF);
        } else {
            int insertMF = this.getMaxMF(stack) - mf;
            this.setMF(stack, mf + insertMF);
            tile.setMF(tile.getMF() - insertMF);
        }
        tile.sentClient();
    }

    default public int insetMF(ItemStack stack, int insertMF) {
        int mf = this.getMF(stack);
        int sumMF = insertMF + mf;
        if (sumMF <= this.getMaxMF(stack)) {
            this.setMF(stack, sumMF);
            return insertMF;
        }
        int setMF = this.getMaxMF(stack) - mf;
        this.setMF(stack, mf + setMF);
        return setMF;
    }

    default public boolean isMFEmpty(ItemStack stack) {
        return this.getMF(stack) <= 0;
    }

    default public void playSound(Level world, Player player, SoundEvent sound, float vol, float pitch) {
        player.m_9236_().m_5594_(null, player.m_20183_(), sound, SoundSource.PLAYERS, vol, pitch);
    }

    default public int getItemMF(ItemStack stack) {
        return SweetMagicAPI.getMF(stack) * stack.m_41613_();
    }

    default public int getEnchaLevel(ItemStack stacck, Enchantment encha) {
        return EnchantmentHelper.m_44843_((Enchantment)encha, (ItemStack)stacck);
    }

    default public boolean hasMF(ItemStack stack) {
        return SweetMagicAPI.hasMF(stack);
    }
}

