/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.api.iitem;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import sweetmagic.api.iitem.info.BookInfo;
import sweetmagic.init.ItemInit;
import sweetmagic.init.SoundInit;
import sweetmagic.init.tile.menu.container.BaseContainer;

public interface IMagicBook {
    public static final String SLOTCOUNT = "slotCount";

    default public boolean checkChance(float chance, Level world) {
        return chance * 0.01f >= world.m_213780_().m_188501_();
    }

    default public float getChance(float chance) {
        return chance * 0.01f;
    }

    default public List<ItemStack> getInvList(BookInfo info) {
        return info.getInv().getStackList();
    }

    default public float getAttackPage(BookInfo info) {
        return this.getPagePower(info, ItemInit.magicpage_attack, 2.5f);
    }

    default public float getDefencePage(BookInfo info) {
        return this.getPagePower(info, ItemInit.magicpage_defence, 3.0f);
    }

    default public float getHealPage(BookInfo info) {
        return this.getPagePower(info, ItemInit.magicpage_heal, 5.0f);
    }

    default public float getMFPage(BookInfo info) {
        return this.getPagePower(info, ItemInit.magicpage_mf, 3.0f);
    }

    default public float getRecastPage(BookInfo info) {
        return this.getPagePower(info, ItemInit.magicpage_recast, 1.0f);
    }

    default public float getPagePower(BookInfo info, Item item, float rate) {
        List<ItemStack> stackList = this.getInvList(info).stream().filter(s -> s.m_150930_(item)).toList();
        int size = stackList.size();
        float power = (float)size * rate;
        if (size == 10) {
            power += rate * 3.0f;
        } else if (size >= 5) {
            power += rate * 1.5f;
        } else if (size >= 3) {
            power += rate;
        }
        return power;
    }

    default public void openGui(Level world, Player player, ItemStack stack) {
        this.getNBT(stack);
        if (!world.m_5776_()) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new BaseContainer.ContainerMagicBook(stack));
            this.playSound(world, player, SoundInit.PAGE, 0.125f, 1.0f);
        }
    }

    default public void openCraftGui(Level world, Player player, ItemStack stack) {
        if (!world.m_5776_()) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new BaseContainer.ContainerBook(stack));
            this.playSound(world, player, SoundInit.PAGE, 0.125f, 1.0f);
        }
    }

    default public CompoundTag getNBT(ItemStack stack) {
        CompoundTag tags = stack.m_41783_();
        if (tags == null) {
            tags = new CompoundTag();
            tags.m_128405_(SLOTCOUNT, this.getSlotSize());
            stack.m_41751_(tags);
        }
        if (!tags.m_128441_(SLOTCOUNT)) {
            tags.m_128405_(SLOTCOUNT, this.getSlotSize());
        }
        return tags;
    }

    default public int getSlotCount(ItemStack stack) {
        return this.getNBT(stack).m_128451_(SLOTCOUNT);
    }

    default public void playSound(Level world, Player player, SoundEvent sound, float vol, float pitch) {
        player.m_20193_().m_5594_(null, player.m_20183_(), sound, SoundSource.PLAYERS, vol, pitch);
    }

    default public int getSlotSize() {
        return 3;
    }

    public static List<ItemStack> getBookList(Player player) {
        return player.m_150109_().f_35974_.stream().filter(s -> s.m_41720_() instanceof IMagicBook).toList();
    }

    public static IMagicBook getBook(ItemStack stack) {
        return (IMagicBook)stack.m_41720_();
    }
}

