/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.api.iitem;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.emagic.SMMagicType;
import sweetmagic.api.iitem.IMagicBook;
import sweetmagic.api.iitem.IPorch;
import sweetmagic.api.iitem.ISMUtil;
import sweetmagic.api.iitem.ITier;
import sweetmagic.api.iitem.info.BookInfo;
import sweetmagic.api.iitem.info.MagicInfo;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.ItemInit;
import sweetmagic.util.SMDamage;

public interface IMagicItem
extends ISMUtil,
ITier {
    public static final String RECASTTIME = "recastTime";
    public static final String ISIMMED = "isimmed";

    public SMElement getElement();

    public SMMagicType getMagicType();

    @Override
    public int getTier();

    public int getMaxRecastTime();

    public int getUseMF();

    public boolean isShirink();

    default public boolean canItemMagic(Level world, Player player, WandInfo info) {
        return this.getMagicType() != SMMagicType.CHARGE ? true : info.getWand().getChargeTick() >= 1.0f;
    }

    public boolean onItemAction(Level var1, Player var2, WandInfo var3, MagicInfo var4);

    public ResourceLocation getResource();

    public List<MutableComponent> magicToolTip(List<MutableComponent> var1);

    default public int getRecastTime(ItemStack stack) {
        return this.getNBT(stack).m_128451_(RECASTTIME);
    }

    default public void setRecastTime(ItemStack stack, int recastTime) {
        this.getNBT(stack).m_128405_(RECASTTIME, recastTime);
    }

    default public boolean isImmedFlag(ItemStack stack) {
        return this.getNBT(stack).m_128471_(ISIMMED);
    }

    default public void setImmedFlag(ItemStack stack, boolean isImmed) {
        this.getNBT(stack).m_128379_(ISIMMED, isImmed);
    }

    default public boolean isNoRecast(ItemStack stack) {
        return this.getRecastTime(stack) <= 0;
    }

    default public void recastTimeElapse(ItemStack stack) {
        this.setRecastTime(stack, this.getRecastTime(stack) - 1);
    }

    default public float getPower(WandInfo wandInfo) {
        return wandInfo.getWand().getPower(wandInfo.getLevel());
    }

    default public int effectTime(WandInfo wandInfo) {
        return wandInfo.getWand().effectTime(wandInfo.getLevel());
    }

    public static IMagicItem getSMItem(Item item) {
        return (IMagicItem)item;
    }

    default public boolean isUniqueMagic() {
        return false;
    }

    default public boolean isAllShrink() {
        return false;
    }

    default public boolean isEqualMagic(ItemStack stack, MagicInfo info) {
        return stack.m_150930_(info.getItem());
    }

    default public CompoundTag getNBT(ItemStack stack) {
        CompoundTag tags = stack.m_41783_();
        if (tags != null) {
            return tags;
        }
        tags = new CompoundTag();
        tags.m_128405_(RECASTTIME, 0);
        tags.m_128379_(ISIMMED, false);
        stack.m_41751_(tags);
        return tags;
    }

    default public void onUpdate(Level world, Player player, ItemStack stack) {
        if (stack.m_41783_() != null && !this.isNoRecast(stack)) {
            this.recastTimeElapse(stack);
        }
    }

    default public SMElement getSubElement() {
        return null;
    }

    default public void setSubElement(SMElement ele) {
    }

    default public int addExp() {
        return 0;
    }

    default public void spawnParticleRing(ServerLevel server, ParticleOptions par, double range, BlockPos pos, double addY, double ySpeed, double moveValue) {
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.0 + addY;
        double z = (double)pos.m_123343_() + 0.5;
        for (double degree = -range * Math.PI; degree < range * Math.PI; degree += 0.05) {
            double rate = range;
            server.m_8767_(par, x + Math.cos(degree) * rate, y, z + Math.sin(degree) * rate, 0, -Math.cos(degree) * 0.25, ySpeed, -Math.sin(degree) * 0.25, moveValue);
        }
    }

    default public boolean canTargetEffect(LivingEntity target, LivingEntity owner) {
        return owner instanceof Player ? target instanceof Enemy : target instanceof Player;
    }

    default public int getExtensionRingCount(Player player) {
        Item item;
        ItemStack leg = player.m_6844_(EquipmentSlot.LEGS);
        if (!leg.m_41619_() && (item = leg.m_41720_()) instanceof IPorch) {
            IPorch porch = (IPorch)item;
            return porch.acceCount(leg, ItemInit.extension_ring, 8);
        }
        return 0;
    }

    default public int getBloodSuckingRing(Player player) {
        Item item;
        ItemStack leg = player.m_6844_(EquipmentSlot.LEGS);
        if (!leg.m_41619_() && (item = leg.m_41720_()) instanceof IPorch) {
            IPorch porch = (IPorch)item;
            return porch.acceCount(leg, ItemInit.blood_sucking_ring, 5);
        }
        return 0;
    }

    default public boolean hasBloodSuckingRing(Player player) {
        return this.getBloodSuckingRing(player) > 0;
    }

    default public boolean gethollyCharm(Player player) {
        Item item;
        ItemStack leg = player.m_6844_(EquipmentSlot.LEGS);
        if (!leg.m_41619_() && (item = leg.m_41720_()) instanceof IPorch) {
            IPorch porch = (IPorch)item;
            return porch.hasAcce(leg, ItemInit.holly_charm);
        }
        return false;
    }

    default public void acceEffect(Player player, Object obj) {
        SMElement ele = this.getElement();
        SMElement subEle = this.getSubElement();
        if (!this.gethollyCharm(player) || !this.isElement(ele, subEle, SMElement.SHINE)) {
            return;
        }
        Level world = player.m_9236_();
        SimpleParticleType par = ParticleTypes.f_123810_;
        RandomSource rand = world.m_213780_();
        float dame = ((Float)obj).floatValue() * 0.67f;
        List<Monster> entityList = this.getEntityList(Monster.class, (Entity)player, 7.5);
        for (Monster entity : entityList) {
            int count = entity.m_21023_(MobEffects.f_19619_) ? 3 : 1;
            for (int i = 0; i < count; ++i) {
                entity.m_6469_(SMDamage.getMagicDamage((Entity)player, (Entity)player), dame);
                entity.f_19802_ = 0;
            }
            if (!(world instanceof ServerLevel)) continue;
            ServerLevel sever = (ServerLevel)world;
            BlockPos pos = entity.m_20183_().m_7494_();
            for (int i = 0; i < 16; ++i) {
                double xS = this.getRand(rand, 0.1f);
                double yS = (double)rand.m_188501_() * 0.25;
                double zS = this.getRand(rand, 0.1f);
                sever.m_8767_((ParticleOptions)par, (double)pos.m_123341_() + this.getRand(rand, 0.5), (double)((float)pos.m_123342_() - 0.25f) + this.getRand(rand, 0.25), (double)pos.m_123343_() + this.getRand(rand, 0.5), 0, xS, yS, zS, 1.0);
            }
        }
    }

    default public boolean isElement(SMElement ele, SMElement subEle, SMElement checkEle) {
        return ele.is(checkEle) || subEle != null && subEle.is(checkEle);
    }

    default public void onMagicUpdate(Level world, Player player, WandInfo wandInfo, ItemStack stack) {
    }

    default public boolean getHealup(Player player) {
        List<ItemStack> stackBookList = IMagicBook.getBookList(player);
        if (stackBookList.isEmpty()) {
            return false;
        }
        BookInfo info = new BookInfo(stackBookList.get(0));
        IMagicBook book = info.getBook();
        return book.checkChance(book.getHealPage(info), player.m_9236_());
    }

    default public boolean getNoMF(Player player) {
        List<ItemStack> stackBookList = IMagicBook.getBookList(player);
        if (stackBookList.isEmpty()) {
            return false;
        }
        BookInfo info = new BookInfo(stackBookList.get(0));
        IMagicBook book = info.getBook();
        return book.checkChance(book.getMFPage(info), player.m_9236_());
    }

    default public boolean getNoRecast(Player player) {
        List<ItemStack> stackBookList = IMagicBook.getBookList(player);
        if (stackBookList.isEmpty()) {
            return false;
        }
        BookInfo info = new BookInfo(stackBookList.get(0));
        IMagicBook book = info.getBook();
        return book.checkChance(book.getRecastPage(info), player.m_9236_());
    }

    default public float getHealValue(Player player, float healValue) {
        boolean isHealUp = this.getHealup(player);
        return !isHealUp ? healValue : healValue * 1.5f;
    }

    default public int getSummonTime() {
        return 0;
    }
}

