/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.api.iitem;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.Level;
import sweetmagic.api.emagic.SMAcceType;
import sweetmagic.api.iitem.IAcce;
import sweetmagic.api.iitem.ISMArmor;
import sweetmagic.api.iitem.info.AcceInfo;
import sweetmagic.api.iitem.info.BaseItemInfo;
import sweetmagic.api.iitem.info.PorchInfo;
import sweetmagic.init.EnchantInit;
import sweetmagic.init.SoundInit;
import sweetmagic.init.tile.inventory.SMInventory;

public interface IPorch
extends ISMArmor {
    public static final List<EnchantmentCategory> ENCHACATELIST = Arrays.asList(EnchantInit.ISALL);

    public void openGui(Level var1, Player var2, ItemStack var3);

    default public int getSlotSize() {
        return 8 * this.getTier();
    }

    default public void playSound(Level world, Player player, SoundEvent sound, float vol, float pitch) {
        world.m_5594_(null, player.m_20183_(), sound, SoundSource.PLAYERS, vol, pitch);
    }

    default public void onTick(Level world, Player player, ItemStack porch) {
        List<ItemStack> stackList;
        Multimap<Attribute, AttributeModifier> map;
        if (player.m_5833_()) {
            return;
        }
        boolean isClient = world.m_5776_();
        if (!isClient && !(map = this.getAttributeMap()).isEmpty()) {
            player.m_21204_().m_22161_(map);
            this.setAttributeMap((Multimap<Attribute, AttributeModifier>)ImmutableMultimap.of());
        }
        if ((stackList = this.getStackList(porch)).isEmpty()) {
            return;
        }
        ArrayList acceList = new ArrayList();
        stackList.forEach(s -> acceList.add(new AcceInfo((ItemStack)s)));
        if (isClient) {
            for (AcceInfo info : acceList) {
                info.getAcce().onClientUpdate(world, player, info);
            }
            return;
        }
        ArrayList<ItemStack> acceStackList = new ArrayList<ItemStack>();
        for (Object info : acceList) {
            IAcce acce = ((AcceInfo)info).getAcce();
            if (!acce.canUseEffect(world, player, (AcceInfo)info)) continue;
            ItemStack stack = ((BaseItemInfo)info).getStack();
            if (!acce.isUpdateType(world, player, (AcceInfo)info) || !acce.isDuplication() && acceStackList.contains(stack)) continue;
            acce.onUpdate(world, player, (AcceInfo)info);
            acceStackList.add(stack);
        }
        HashSet<AcceInfo> acceSet = new HashSet<AcceInfo>();
        for (AcceInfo info : acceList) {
            IAcce acce = info.getAcce();
            if (!acce.getAcceType().is(SMAcceType.MUL_UPDATE) || !acce.canUseEffect(world, player, info)) continue;
            acceSet.add(info);
        }
        if (acceSet.isEmpty()) {
            return;
        }
        PorchInfo pInfo = new PorchInfo(porch);
        ImmutableMultimap.Builder imMap = ImmutableMultimap.builder();
        for (AcceInfo accInfo : acceSet) {
            IAcce acc = accInfo.getAcce();
            acc.onMultiUpdate(world, player, accInfo, pInfo);
            imMap.putAll(acc.getAttributeMap(world, player, accInfo, pInfo));
        }
        ImmutableMultimap mulMap = imMap.build();
        this.setAttributeMap((Multimap<Attribute, AttributeModifier>)mulMap);
        if (!mulMap.isEmpty()) {
            player.m_21204_().m_22178_((Multimap)mulMap);
        }
    }

    default public List<ItemStack> getStackList(ItemStack stack) {
        return new PorchInfo(stack).getInv().getStackList().stream().filter(s -> s.m_41720_() instanceof IAcce).toList();
    }

    default public boolean hasAcce(ItemStack stack, Item acce) {
        return !this.getStackList(stack).stream().filter(s -> s.m_150930_(acce)).toList().isEmpty();
    }

    default public boolean hasAcceIsActive(ItemStack stack, Item acce) {
        return !this.getStackList(stack).stream().filter(s -> s.m_150930_(acce) && !s.m_41784_().m_128471_("notActive")).toList().isEmpty();
    }

    default public boolean getFilter(AcceInfo info) {
        IAcce acce = info.getAcce();
        return acce.isDuplication() && acce.getAcceType().is(SMAcceType.MUL_UPDATE);
    }

    default public int acceCount(ItemStack stack, Item acce, int maxValue) {
        int acceCount = 0;
        List<ItemStack> stackList = this.getStackList(stack).stream().filter(s -> s.m_150930_(acce)).toList();
        for (ItemStack s2 : stackList) {
            AcceInfo info = new AcceInfo(s2);
            acceCount += info.getAcce().getStackCount(info);
            maxValue = Math.max(maxValue, info.getAcce().getStackCount(info));
        }
        return Math.min(acceCount, maxValue);
    }

    default public void acceInvalidate(Player player, ItemStack stack, Item acce) {
        SMInventory.SMPorchInventory inv = new PorchInfo(stack).getInv();
        for (int i = 0; i < inv.getSlots(); ++i) {
            CompoundTag tags;
            ItemStack magicStack = inv.getStackInSlot(i);
            if (!magicStack.m_150930_(acce)) continue;
            tags.m_128379_("notActive", !(tags = magicStack.m_41784_()).m_128471_("notActive"));
            inv.writeBack();
            boolean notActive = tags.m_128471_("notActive");
            this.playSound(player.m_9236_(), player, SoundInit.STOVE_OFF, 0.1f, !notActive ? 0.75f : 1.25f);
            player.m_213846_((Component)this.getTipArray(((MutableComponent)magicStack.m_41611_()).m_130940_(GOLD), this.getText(notActive ? "acce_invalid" : "acce_active").m_130940_(notActive ? RED : GREEN)));
            break;
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeMap();

    public void setAttributeMap(Multimap<Attribute, AttributeModifier> var1);

    public static IPorch getPorch(Player player) {
        IPorch porch;
        Item item;
        ItemStack leg = player.m_6844_(EquipmentSlot.LEGS);
        return !leg.m_41619_() && (item = leg.m_41720_()) instanceof IPorch ? (porch = (IPorch)item) : null;
    }

    public static IPorch getPorch(ItemStack leg) {
        IPorch porch;
        Item item;
        return !leg.m_41619_() && (item = leg.m_41720_()) instanceof IPorch ? (porch = (IPorch)item) : null;
    }
}

