/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.api.iitem;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.emagic.SMMagicType;
import sweetmagic.api.iitem.IMFTool;
import sweetmagic.api.iitem.IMagicItem;
import sweetmagic.api.iitem.IPorch;
import sweetmagic.api.iitem.info.MagicInfo;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.config.SMConfig;
import sweetmagic.init.AdvancedInit;
import sweetmagic.init.EnchantInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.SoundInit;
import sweetmagic.init.item.magic.RankUpMagic;
import sweetmagic.init.tile.inventory.SMInventory;
import sweetmagic.init.tile.menu.container.BaseContainer;

public interface IWand
extends IMFTool {
    public static final String SLOT = "slot";
    public static final String SLOTCOUNT = "slotCount";
    public static final String EXP = "exp";
    public static final String LEVEL = "level";
    public static final String ELEMENT = "element";
    public static final String SUBELEMENT = "subElement";
    public static final String IMMEDTIME = "immedtime";
    public static final String IMMEDSLOT = "immedslot";
    public static final String SMWAND = "SMWand";
    public static final String WANDCHECK = "WandCheck";
    public static final List<EnchantmentCategory> ENCHACATELIST = Arrays.asList(EnchantInit.ISMFTOOL, EnchantInit.ISWAND_HARNESS, EnchantInit.ISWAND, EnchantInit.ISWAND5, EnchantInit.ISALL);

    public InteractionResultHolder<ItemStack> use(Level var1, Player var2, InteractionHand var3);

    public void releaseUsing(ItemStack var1, Level var2, LivingEntity var3, int var4);

    default public InteractionResultHolder<ItemStack> onItemRightClick(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41619_()) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        WandInfo wandInfo = new WandInfo(stack);
        ItemStack slotItem = this.getSlotItem(player, wandInfo);
        if (slotItem.m_41619_() || !(slotItem.m_41720_() instanceof IMagicItem)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        MagicInfo magicInfo = new MagicInfo(slotItem);
        IMagicItem item = magicInfo.getMagicItem();
        this.setMagicItem(item);
        switch (item.getMagicType()) {
            case SHOT: {
                if (this.isScope()) {
                    player.m_6672_(hand);
                    break;
                }
                this.shotterActived(world, player, wandInfo, magicInfo);
                break;
            }
            case NORMAL: 
            case FIELD: 
            case SUMMON: 
            case BOSS: {
                this.airActived(world, player, wandInfo, magicInfo);
                break;
            }
            case CHARGE: {
                player.m_6672_(hand);
                break;
            }
            default: {
                return InteractionResultHolder.m_19100_((Object)stack);
            }
        }
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    default public void onPlayerStoppedUsing(ItemStack stack, Level world, LivingEntity living, int timeLeft) {
        IPorch portch;
        Item item;
        Player player;
        block11: {
            block10: {
                if (!(living instanceof Player)) break block10;
                player = (Player)living;
                if (!stack.m_41619_()) break block11;
            }
            return;
        }
        WandInfo wandInfo = new WandInfo(stack);
        ItemStack slotItem = this.getSlotItem(player, wandInfo);
        player.m_5810_();
        if (slotItem.m_41619_() || !(slotItem.m_41720_() instanceof IMagicItem)) {
            return;
        }
        MagicInfo magicInfo = new MagicInfo(slotItem);
        IMagicItem item2 = magicInfo.getMagicItem();
        this.setMagicItem(item2);
        float rate = 20.0f;
        ItemStack leg = player.m_6844_(EquipmentSlot.LEGS);
        if (!leg.m_41619_() && (item = leg.m_41720_()) instanceof IPorch && (portch = (IPorch)item).hasAcce(leg, ItemInit.magician_quillpen)) {
            rate /= 4.0f;
        }
        int i = this.getMaxItemUseDuration(stack) - timeLeft;
        this.setChargeTick(this.getArrowVelocity(i, 1.0f, rate));
        switch (item2.getMagicType()) {
            case CHARGE: {
                this.chargeActived(world, player, wandInfo, magicInfo);
                break;
            }
            case SHOT: {
                if (!this.isScope()) {
                    return;
                }
                this.shotterActived(world, player, wandInfo, magicInfo);
                break;
            }
            default: {
                return;
            }
        }
    }

    default public void shotterActived(Level world, Player player, WandInfo wandInfo, MagicInfo magicInfo) {
        if (!this.magicActionBeforeCheck(player, wandInfo, magicInfo)) {
            return;
        }
        boolean actionFlag = this.onAction(world, player, wandInfo, magicInfo);
        this.magicActionAfter(world, player, wandInfo, magicInfo, actionFlag);
    }

    default public void airActived(Level world, Player player, WandInfo wandInfo, MagicInfo magicInfo) {
        if (!this.magicActionBeforeCheck(player, wandInfo, magicInfo)) {
            return;
        }
        boolean actionFlag = this.onAction(world, player, wandInfo, magicInfo);
        this.magicActionAfter(world, player, wandInfo, magicInfo, actionFlag);
    }

    default public void chargeActived(Level world, Player player, WandInfo wandInfo, MagicInfo magicInfo) {
        if (!this.magicActionBeforeCheck(player, wandInfo, magicInfo)) {
            return;
        }
        boolean actionFlag = this.onAction(world, player, wandInfo, magicInfo);
        this.magicActionAfter(world, player, wandInfo, magicInfo, actionFlag);
    }

    default public void nextSlot(Level world, Player player, ItemStack stack) {
        CompoundTag tags = this.getNBT(stack);
        ItemStack slotItem = ItemStack.f_41583_;
        int slotCount = tags.m_128451_(SLOTCOUNT);
        int slot = this.getSelectSlot(stack);
        for (int maxCount = 0; slotItem.m_41619_() && slotCount >= maxCount; ++maxCount) {
            slot = slot >= slotCount - 1 ? 0 : slot + 1;
            this.setSelectSlot(stack, slot);
            slotItem = this.getSlotItem(player, new WandInfo(stack));
        }
        this.playSound(world, player, SoundInit.NEXT, 0.0625f, 1.0f);
    }

    default public void backSlot(Level world, Player player, ItemStack stack) {
        CompoundTag tags = this.getNBT(stack);
        ItemStack slotItem = ItemStack.f_41583_;
        int slotCount = tags.m_128451_(SLOTCOUNT);
        int slot = this.getSelectSlot(stack);
        for (int maxCount = 0; slotItem.m_41619_() && slotCount >= maxCount; ++maxCount) {
            slot = slot <= 0 ? slotCount - 1 : slot - 1;
            this.setSelectSlot(stack, slot);
            slotItem = this.getSlotItem(player, new WandInfo(stack));
        }
        this.playSound(world, player, SoundInit.NEXT, 0.0625f, 1.0f);
    }

    default public void openGui(Level world, Player player, ItemStack stack) {
        this.getNBT(stack);
        if (!world.m_5776_()) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new BaseContainer.ContainerWand(stack));
            this.playSound(world, player, SoundInit.PAGE, 0.125f, 1.0f);
        }
    }

    default public boolean magicActionBeforeCheck(Player player, WandInfo wandInfo, MagicInfo magicInfo) {
        ItemStack stack = wandInfo.getStack();
        IMagicItem smItem = magicInfo.getMagicItem();
        if (this.isCreativeWand()) {
            return true;
        }
        if (!this.canUseMagic(stack, this.getCostMF(player, stack, magicInfo))) {
            return false;
        }
        if (this.checkOverTier(smItem)) {
            return false;
        }
        if (!smItem.isNoRecast(magicInfo.getStack())) {
            return false;
        }
        return smItem.canItemMagic(player.m_9236_(), player, wandInfo);
    }

    default public boolean canUseMagic(ItemStack stack, int mf) {
        return this.getNBT(stack).m_128451_("mf") >= mf;
    }

    default public boolean checkOverTier(IMagicItem item) {
        return item.getTier() > this.getWandTier();
    }

    default public boolean onAction(Level world, Player player, WandInfo wandInfo, MagicInfo magicInfo) {
        return magicInfo.getMagicItem().onItemAction(world, player, wandInfo, magicInfo);
    }

    default public void magicActionAfter(Level world, Player player, WandInfo wandInfo, MagicInfo magicInfo, boolean actionFlag) {
        if (this.isCreativeWand()) {
            return;
        }
        ItemStack stack = wandInfo.getStack();
        ItemStack magicStack = magicInfo.getStack();
        IMagicItem smItem = magicInfo.getMagicItem();
        this.setElementBonus(wandInfo, magicInfo);
        smItem.setImmedFlag(magicStack, false);
        smItem.setRecastTime(magicStack, this.getRecastTime(player, stack, magicInfo));
        this.setImmedTime(wandInfo, 13);
        this.setMF(stack, this.setMF(player, stack, magicInfo));
        if (smItem.isShirink() && !player.m_7500_()) {
            this.shrinkItem(player, wandInfo, magicInfo);
        }
        if (actionFlag && !world.m_5776_()) {
            this.levelUpCheck(world, player, stack, this.getAddExp(player, magicInfo), true);
        }
        if (((Boolean)SMConfig.hungerSetting.get()).booleanValue()) {
            player.m_36399_((float)magicInfo.getMagicItem().getUseMF() * 0.001f);
        }
    }

    default public boolean isCreativeWand() {
        return this.getWandTier() >= 6;
    }

    default public int setMF(Player player, ItemStack stack, MagicInfo magicInfo) {
        return this.getMF(stack) - this.getCostMF(player, stack, magicInfo);
    }

    default public int getCostMF(Player player, ItemStack stack, MagicInfo magicInfo) {
        float costDown = 0.0f;
        IMagicItem magicItem = magicInfo.getMagicItem();
        if (magicItem.getNoMF(player)) {
            return (int)costDown;
        }
        int useMF = magicInfo.getMagicItem().getUseMF();
        costDown += (float)(this.getEnchantLevel(EnchantInit.mfCostDown, stack) * 7);
        costDown += (float)(this.getPotionLevel(player, PotionInit.mfcostdown) * 10);
        if (this.getElementBonus() > 0.0f) {
            costDown += this.getElementBonus() * 15.0f;
        }
        costDown += this.acceCostRate(player);
        if ((costDown = Math.min(99.0f, costDown)) != 0.0f) {
            useMF = (int)((float)useMF * ((100.0f - costDown) / 100.0f));
        }
        useMF = (int)((float)useMF * this.getElementMatchDown());
        return Math.max(useMF, 0);
    }

    default public int getRecastTime(Player player, ItemStack stack, MagicInfo info) {
        int recastDown = 0;
        Level world = player.m_9236_();
        IMagicItem magicItem = info.getMagicItem();
        if (magicItem.getNoRecast(player)) {
            this.playSound(world, player, SoundInit.RECAST_CLEAR, 0.25f, 1.0f);
            return magicItem.isUniqueMagic() ? (int)((float)magicItem.getMaxRecastTime() * 0.05f) : recastDown;
        }
        int recastTime = magicItem.getMaxRecastTime();
        int enchantLevel = this.getEnchantLevel(EnchantInit.recastTimeDown, stack);
        recastDown += Math.min(enchantLevel, 5) * 7;
        if (enchantLevel > 5) {
            recastDown += (enchantLevel - 5) * 3;
        }
        if (!this.isEmptyImmedTime(stack) && this.diffSlot(stack)) {
            recastDown += 10;
            magicItem.setImmedFlag(info.getStack(), true);
            if (!world.m_5776_()) {
                this.playSound(world, player, SoundInit.QUICK, 0.0625f, 1.0f);
            }
        }
        if (this.getElementBonus() > 0.0f) {
            recastDown = (int)((float)recastDown + this.getElementBonus() * 10.0f);
        }
        this.setImmedSlot(stack, this.getSelectSlot(stack));
        recastDown += this.acceCoolTime(world, player.m_6844_(EquipmentSlot.LEGS), info);
        if (this.isScope() && magicItem.getMagicType().is(SMMagicType.SHOT)) {
            recastDown += 10;
        }
        int maxRecast = info.getMagicItem().isUniqueMagic() ? 90 : 99;
        if ((recastDown = Math.min(recastTime, recastDown)) > 0) {
            recastTime = (int)((float)recastTime * ((float)(100 - recastDown) / 100.0f));
        }
        recastTime = (int)((float)recastTime * this.getElementMatchDown());
        if (magicItem.isUniqueMagic()) {
            List<ItemStack> magicList = IWand.getMagicList(IWand.getWandList(player), e -> magicItem.isEqualMagic((ItemStack)e, info));
            for (ItemStack magic : magicList) {
                new MagicInfo(magic).getMagicItem().setRecastTime(magic, recastTime);
            }
        }
        return Math.max(recastTime, 0);
    }

    default public int getEnchantLevel(Enchantment enchant, ItemStack stack) {
        return EnchantmentHelper.m_44843_((Enchantment)enchant, (ItemStack)stack);
    }

    default public int getPotionLevel(Player player, MobEffect potion) {
        if (!player.m_21023_(potion)) {
            return 0;
        }
        return Math.min(player.m_21124_(potion).m_19564_() + 1, 10);
    }

    default public int addWandLevel(Level world, Player player, ItemStack stack, IMagicItem smItem, Enchantment enchant) {
        int enchaLevel = this.getEnchantLevel(enchant, stack);
        if (!smItem.getMagicType().is(SMMagicType.SHOT)) {
            return enchaLevel;
        }
        return enchaLevel;
    }

    default public float getElementMatchDown() {
        float downTime = this.getBounusValue();
        if (downTime != 0.0f) {
            return (100.0f - downTime) * 0.01f;
        }
        return 1.0f;
    }

    default public float getBounusValue() {
        return 0.0f;
    }

    default public int acceCoolTime(Level world, ItemStack stack, MagicInfo magicInfo) {
        long worldTime;
        Item item = stack.m_41720_();
        if (!(item instanceof IPorch)) {
            return 0;
        }
        IPorch porch = (IPorch)item;
        int coolTime = 0;
        if (porch.hasAcce(stack, ItemInit.witch_scroll)) {
            coolTime += 10;
        }
        if (porch.hasAcce(stack, ItemInit.twilight_hourglass) && magicInfo.getMagicItem().getMagicType().is(SMMagicType.SUMMON) && (worldTime = world.m_8044_() % 24000L) >= 10400L && worldTime < 14000L) {
            coolTime += 5;
        }
        return coolTime;
    }

    default public float acceCostRate(Player player) {
        boolean costValue = false;
        ItemStack leg = player.m_6844_(EquipmentSlot.LEGS);
        Item item = leg.m_41720_();
        if (!(item instanceof IPorch)) {
            return (float)costValue;
        }
        IPorch porch = (IPorch)item;
        return -6.25f * (float)porch.acceCount(leg, ItemInit.magicians_grobe, 8);
    }

    default public int getAddExp(Player player, MagicInfo magicInfo) {
        Item item;
        IMagicItem magic = magicInfo.getMagicItem();
        int exp = Math.max(magic.getUseMF() / 10, 0) + magic.addExp() * (magic.isAllShrink() ? magicInfo.getStack().m_41613_() : 1);
        float addPower = 1.0f + (float)this.getPotionLevel(player, PotionInit.increased_experience);
        ItemStack leg = player.m_6844_(EquipmentSlot.LEGS);
        if (!(magic instanceof RankUpMagic) && (item = leg.m_41720_()) instanceof IPorch) {
            IPorch porch = (IPorch)item;
            addPower += 0.125f * (float)porch.acceCount(leg, ItemInit.magicians_grobe, 8);
        }
        exp = (int)((float)exp * addPower);
        return exp;
    }

    default public void levelUpCheck(Level world, Player player, ItemStack stack, int addExp, boolean isFirst) {
        if (this.isCreativeWand()) {
            return;
        }
        CompoundTag tags = this.getNBT(stack);
        int level = tags.m_128451_(LEVEL);
        int exp = tags.m_128451_(EXP);
        int maxLevel = this.getMaxLevel();
        int nextLevel = 1 + level;
        if (level >= maxLevel) {
            this.checkAdavanced(player, stack);
            return;
        }
        int keepExp = 0;
        int nowNeedExp = this.needExp(maxLevel, nextLevel, stack);
        if (addExp > nowNeedExp) {
            keepExp = addExp - nowNeedExp;
            tags.m_128405_(EXP, exp + nowNeedExp);
        } else {
            tags.m_128405_(EXP, exp += addExp);
        }
        int needExp = this.needExp(maxLevel, nextLevel, stack);
        if (needExp > 0) {
            return;
        }
        int upLevel = ++level;
        tags.m_128405_(LEVEL, upLevel);
        tags.m_128405_(EXP, needExp);
        if (isFirst && !player.m_9236_().m_5776_()) {
            this.playSound(world, player, SoundInit.LEVELUP, 0.0625f, 1.0f);
        }
        this.checkAdavanced(player, stack);
        if (keepExp > 0) {
            this.levelUpCheck(world, player, stack, keepExp, false);
        }
    }

    default public void checkAdavanced(Player player, ItemStack stack) {
        int level = this.getNBT(stack).m_128451_(LEVEL);
        if (player instanceof ServerPlayer) {
            ServerPlayer sPlayer = (ServerPlayer)player;
            AdvancedInit.biginerMagician.trigger(sPlayer, 10, level);
            AdvancedInit.intermediateMagician.trigger(sPlayer, 20, level);
            AdvancedInit.advancedMagician.trigger(sPlayer, 30, level);
        }
    }

    default public int getMaxLevel() {
        return (Integer)SMConfig.maxWandLevel.get();
    }

    default public int needExp(int maxLevel, int nextLevel, ItemStack stack) {
        int needExp = this.getNeedExp(nextLevel) - this.getExpValue(stack);
        return nextLevel - 1 >= maxLevel ? 0 : needExp;
    }

    default public int getNeedExp(int nextLevel) {
        int level = nextLevel - 1;
        int tierLevel = level % 8 == 0 ? level - 1 : level;
        int tier = tierLevel / 8;
        int value = level - tier * 8;
        value = value != 0 ? value : 8;
        tier = level == 8 ? tier - 1 : tier;
        int exp = value * 120;
        if (tier > 0) {
            for (int i = 0; i < tier; ++i) {
                exp *= 10;
            }
        }
        return Math.min(exp, 600000);
    }

    default public int getTotalWandLevel(ItemStack stack) {
        int baseLevel = this.isCreativeWand() ? this.getCreativePower() : this.getWandLevel(stack);
        int addLevel = Math.min(10, this.getEnchaLevel(stack, EnchantInit.wandAddPower));
        return baseLevel + addLevel;
    }

    default public boolean isEmptyImmedTime(ItemStack stack) {
        return this.getImmedTime(stack) <= 0;
    }

    default public void immedTimeElapse(ItemStack stack) {
        this.setImmedTime(stack, this.getImmedTime(stack) - 1);
    }

    default public boolean diffSlot(ItemStack stack) {
        return this.getSelectSlot(stack) != this.getImmedSlot(stack);
    }

    @Override
    default public CompoundTag getNBT(ItemStack stack) {
        CompoundTag tags = stack.m_41783_();
        if (tags == null) {
            tags = new CompoundTag();
            tags.m_128405_(SLOT, 0);
            tags.m_128405_(SLOTCOUNT, this.getSlot());
            tags.m_128405_(EXP, 0);
            tags.m_128405_(LEVEL, 1);
            tags.m_128405_("mf", 0);
            tags.m_128359_(ELEMENT, "empty");
            tags.m_128359_(SUBELEMENT, "empty");
            tags.m_128405_(IMMEDTIME, 0);
            tags.m_128405_(IMMEDSLOT, 0);
            stack.m_41751_(tags);
        }
        if (!tags.m_128441_(SLOT)) {
            tags.m_128405_(SLOT, 0);
        }
        if (!tags.m_128441_(SLOTCOUNT)) {
            tags.m_128405_(SLOTCOUNT, this.getSlot());
        }
        if (!tags.m_128441_(EXP)) {
            tags.m_128405_(EXP, 0);
        }
        if (!tags.m_128441_(LEVEL)) {
            tags.m_128405_(LEVEL, 1);
        }
        if (!tags.m_128441_("mf")) {
            tags.m_128405_("mf", 0);
        }
        if (!tags.m_128441_(ELEMENT)) {
            tags.m_128359_(ELEMENT, "empty");
        }
        if (!tags.m_128441_(SUBELEMENT)) {
            tags.m_128359_(SUBELEMENT, "empty");
        }
        if (!tags.m_128441_(IMMEDTIME)) {
            tags.m_128405_(IMMEDTIME, 0);
        }
        if (!tags.m_128441_(IMMEDSLOT)) {
            tags.m_128405_(IMMEDSLOT, 0);
        }
        return tags;
    }

    default public int getWandLevel(ItemStack stack) {
        return this.getNBT(stack).m_128451_(LEVEL);
    }

    default public int getExpValue(ItemStack stack) {
        return this.getNBT(stack).m_128451_(EXP);
    }

    default public void setExpValue(ItemStack stack, int expValue) {
        this.getNBT(stack).m_128405_(EXP, expValue);
    }

    default public int getSelectSlot(ItemStack stack) {
        return this.getNBT(stack).m_128451_(SLOT);
    }

    default public void setSelectSlot(ItemStack stack, int slotId) {
        this.getNBT(stack).m_128405_(SLOT, slotId);
    }

    default public int getSlotCount(ItemStack stack) {
        return this.getNBT(stack).m_128451_(SLOTCOUNT);
    }

    default public String getElement(ItemStack stack) {
        return this.getNBT(stack).m_128461_(ELEMENT);
    }

    default public void setElement(ItemStack stack, String ele) {
        this.getNBT(stack).m_128359_(ELEMENT, ele);
    }

    default public String getSubElement(ItemStack stack) {
        return this.getNBT(stack).m_128461_(SUBELEMENT);
    }

    default public void setSubElement(ItemStack stack, String ele) {
        this.getNBT(stack).m_128359_(SUBELEMENT, ele);
    }

    default public int getImmedTime(ItemStack stack) {
        return this.getNBT(stack).m_128451_(IMMEDTIME);
    }

    default public void setImmedTime(WandInfo info, int time) {
        if (this.getElementBonus() > 0.0f) {
            time = (int)((float)time + this.getElementBonus() * 10.0f);
        }
        this.setImmedTime(info.getStack(), time);
    }

    default public void setImmedTime(ItemStack stack, int time) {
        this.getNBT(stack).m_128405_(IMMEDTIME, time);
    }

    default public int getImmedSlot(ItemStack stack) {
        return this.getNBT(stack).m_128451_(IMMEDSLOT);
    }

    default public void setImmedSlot(ItemStack stack, int slot) {
        this.getNBT(stack).m_128405_(IMMEDSLOT, slot);
    }

    default public ItemStack getSlotItem(Player player, ItemStack stack, CompoundTag tags, int slot) {
        SMInventory.SMWandInventory inv = new WandInfo(stack).getInv();
        return inv.inv.getStackInSlot(slot);
    }

    default public ItemStack getSlotItem(Player player, WandInfo wandInfo) {
        ItemStack stack = wandInfo.getStack();
        int slot = this.getSelectSlot(stack);
        SMInventory.SMWandInventory inv = new WandInfo(stack).getInv();
        return inv.inv.getStackInSlot(slot);
    }

    default public void shrinkItem(Player player, WandInfo wandInfo, MagicInfo magicInfo) {
        SMInventory.SMWandInventory inv = wandInfo.getInv();
        ItemStack selectStack = inv.getStackInSlot(this.getSelectSlot(wandInfo.getStack()));
        selectStack.m_41774_(magicInfo.getMagicItem().isAllShrink() ? selectStack.m_41613_() : 1);
        inv.writeBack();
    }

    default public int getCreativePower() {
        return 60;
    }

    default public boolean isScope() {
        return false;
    }

    default public void shotSound(Player player) {
        this.playSound(player.m_9236_(), player, SoundEvents.f_11705_, 0.5f, 0.67f);
    }

    default public List<Component> addTip() {
        return new ArrayList<Component>();
    }

    default public float getArrowVelocity(int charge, float maxTick, float rate) {
        float f = (float)charge / rate;
        f = (f * f + f * 2.0f) / 3.0f;
        return Math.min(f, maxTick);
    }

    default public int getMaxItemUseDuration(ItemStack stack) {
        SMMagicType magicType;
        int chargeTime = 0;
        if (this.getMagicItem() != null && (magicType = this.getMagicItem().getMagicType()) != null && (magicType.is(SMMagicType.CHARGE) || magicType.is(SMMagicType.SHOT) && this.isScope())) {
            chargeTime = 72000;
        }
        return chargeTime;
    }

    default public UseAnim getItemUseAction(ItemStack stack) {
        if (this.getMagicItem() == null) {
            return UseAnim.NONE;
        }
        SMMagicType magicType = this.getMagicItem().getMagicType();
        if (magicType != null && (magicType.is(SMMagicType.CHARGE) || magicType.is(SMMagicType.SHOT) && this.isScope())) {
            return UseAnim.BOW;
        }
        return UseAnim.NONE;
    }

    default public BlockPos getWandPos() {
        return new BlockPos(0, 0, 0);
    }

    default public boolean isNotElement() {
        return this.getWandElement() != null && this.getWandTier() >= 5;
    }

    default public boolean isElementEqual(IMagicItem smItem) {
        SMElement ele = this.getWandElement();
        return smItem.getElement().is(ele) || smItem.getSubElement() != null && smItem.getSubElement().is(ele);
    }

    default public boolean isElementEqual(IMagicItem smItem, SMElement ele) {
        return ele != null && (smItem.getElement().is(ele) || smItem.getSubElement() != null && smItem.getSubElement().is(ele));
    }

    default public void onUpdate(ItemStack stack, Level level, Entity entity, int slot, boolean main) {
        Item item;
        Player player;
        block5: {
            block4: {
                if (!(entity instanceof Player)) break block4;
                player = (Player)entity;
                if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof IWand) break block5;
            }
            return;
        }
        IWand wand = (IWand)item;
        this.slotUpdate(level, player, stack);
        if (!this.isEmptyImmedTime(stack)) {
            this.immedTimeElapse(stack);
        }
    }

    default public void slotUpdate(Level level, Player player, ItemStack stack) {
        WandInfo info = new WandInfo(stack);
        SMInventory.SMWandInventory inv = info.getInv();
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack magicStack = inv.getStackInSlot(i);
            if (magicStack.m_41619_()) continue;
            MagicInfo magicInfo = new MagicInfo(magicStack);
            IMagicItem magicItem = magicInfo.getMagicItem();
            magicItem.onMagicUpdate(level, player, info, magicStack);
            boolean hasTag = magicStack.m_41783_() != null;
            magicItem.getNBT(magicStack);
            if (!hasTag) {
                inv.writeBack();
            }
            if (magicItem.isNoRecast(magicStack)) continue;
            magicItem.recastTimeElapse(magicStack);
            inv.writeBack();
        }
    }

    default public List<ItemStack> getMagicList(ItemStack stack) {
        SMInventory.SMWandInventory inv = new WandInfo(stack).getInv();
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        int slotCount = inv.getSlots();
        for (int i = 0; i < slotCount; ++i) {
            stackList.add(inv.inv.getStackInSlot(i));
        }
        return stackList;
    }

    default public ItemStack getNextStack(Level world, Player player, ItemStack stack) {
        CompoundTag tags = this.getNBT(stack);
        ItemStack slotItem = ItemStack.f_41583_;
        int slotCount = tags.m_128451_(SLOTCOUNT);
        int slot = this.getSelectSlot(stack);
        for (int maxCount = 0; slotItem.m_41619_() && slotCount >= maxCount; ++maxCount) {
            slot = slot >= slotCount - 1 ? 0 : slot + 1;
            slotItem = this.getSlotItem(player, stack, tags, slot);
        }
        return slotItem;
    }

    default public ItemStack getBackStack(Level world, Player player, ItemStack stack) {
        CompoundTag tags = this.getNBT(stack);
        ItemStack slotItem = ItemStack.f_41583_;
        int slotCount = tags.m_128451_(SLOTCOUNT);
        int slot = this.getSelectSlot(stack);
        for (int maxCount = 0; slotItem.m_41619_() && slotCount >= maxCount; ++maxCount) {
            slot = slot <= 0 ? slotCount - 1 : slot - 1;
            slotItem = this.getSlotItem(player, stack, tags, slot);
        }
        return slotItem;
    }

    default public int getExpProgressScaled(ItemStack stack, int value) {
        int maxEXP = this.getNeedExp(this.getWandLevel(stack) + 1);
        int exp = this.getExpValue(stack);
        return Math.min(value, (int)((float)value * ((float)exp / (float)maxEXP)));
    }

    default public float getPower(float level) {
        return level * 0.2f + Math.min((level - 1.0f) * 0.255f, 5.0f) + Math.min(Math.max(6.0f * (1.0f - (level - 1.0f) * 0.0185f), 0.0f), 5.8f);
    }

    default public int effectTime(int level) {
        return (int)(Math.max(1200.0f * (1.0f - (float)(level - 1) * 0.05f), 0.0f) + (float)(450 * (level - 1)) * Math.max(2.0f - (float)(level - 1) * 0.1f, 0.65f));
    }

    default public SMElement getMainSMElement(ItemStack stack) {
        return SMElement.getElement(this.getElement(stack));
    }

    default public SMElement getSubSMElement(ItemStack stack) {
        return SMElement.getElement(this.getSubElement(stack));
    }

    default public boolean hasSMElement(ItemStack stack) {
        return !this.getMainSMElement(stack).isEmoty() || !this.getSubSMElement(stack).isEmoty();
    }

    public int getWandTier();

    public void setWandTier(int var1);

    @Override
    public int getMaxMF(ItemStack var1);

    @Override
    public void setMaxMF(int var1);

    public void setLevel(ItemStack var1, int var2);

    public int getSlot();

    public void setSlot(int var1);

    public float getChargeTick();

    public void setChargeTick(float var1);

    public IMagicItem getMagicItem();

    public void setMagicItem(IMagicItem var1);

    public float getElementBonus();

    public void setElementBonus(WandInfo var1, MagicInfo var2);

    default public SMElement getWandElement() {
        return null;
    }

    public static IWand getWand(ItemStack stack) {
        return (IWand)stack.m_41720_();
    }

    public static int getLevel(IWand wand, ItemStack stack) {
        return wand.isCreativeWand() ? wand.getCreativePower() : wand.getWandLevel(stack);
    }

    public static List<ItemStack> getWandList(Player player) {
        return player.m_150109_().f_35974_.stream().filter(s -> s.m_41720_() instanceof IWand).toList();
    }

    public static List<ItemStack> getMagicList(List<ItemStack> wandList, Predicate<ItemStack> flag) {
        ArrayList<ItemStack> magicList = new ArrayList<ItemStack>();
        for (ItemStack stack : wandList) {
            SMInventory.SMWandInventory inv = new WandInfo(stack).getInv();
            magicList.addAll(inv.getStackList().stream().filter(flag).toList());
        }
        return magicList;
    }

    public static ItemStack getWand(Player player) {
        ItemStack stack = player.m_21205_();
        if (stack.m_41619_() || !(stack.m_41720_() instanceof IWand)) {
            stack = player.m_21206_();
        }
        if (stack.m_41619_() || !(stack.m_41720_() instanceof IWand)) {
            stack = ItemStack.f_41583_;
        }
        return stack;
    }

    default public ItemStack getRenderStack(ItemStack stack) {
        return stack;
    }

    default public void renderWand(PoseStack pose, MultiBufferSource buf, Player player, float parTick) {
        if (player.m_6144_() && !player.m_150110_().f_35935_) {
            pose.m_85837_(0.05, 0.725, 0.06);
            pose.m_252781_(Axis.f_252403_.m_252977_(225.0f));
        } else {
            pose.m_85837_(0.05, 0.55, 0.15);
            pose.m_252781_(Axis.f_252403_.m_252977_(225.0f));
        }
    }
}

