/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.event;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;
import sweetmagic.SweetMagicCore;
import sweetmagic.api.event.SMUtilEvent;
import sweetmagic.init.ItemInit;
import sweetmagic.init.block.crop.Alstroemeria;

@Mod.EventBusSubscriber(modid="sweetmagic", value={Dist.CLIENT})
public class AlstroemeriaTimeWeatherEvent
extends SMUtilEvent {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_usergage.png");
    private static Alstroemeria.TimeWeatherType timeWeather = null;
    public static int tickTime = 0;
    public static int renderTick = 0;

    @SubscribeEvent
    public static void onWandRenderEvent(RenderGuiOverlayEvent.Post event) {
        if (!event.getOverlay().id().equals((Object)VanillaGuiOverlay.HOTBAR.id())) {
            return;
        }
        if (timeWeather != null) {
            int height = event.getWindow().m_85446_();
            int weight = event.getWindow().m_85445_();
            int addX = (int)(25.0f - 10.0f * AlstroemeriaTimeWeatherEvent.getProgress(20));
            int addY = -10;
            AlstroemeriaTimeWeatherEvent.renderStart(TEX);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)AlstroemeriaTimeWeatherEvent.getProgress(10));
            GuiGraphics gra = event.getGuiGraphics();
            PoseStack pose = gra.m_280168_();
            Matrix4f mat = pose.m_85850_().m_252922_();
            AlstroemeriaTimeWeatherEvent.drawTextured(mat, weight - 200 + addX, height - 186 + addY, 145, 144, 93, 29);
            Minecraft mc = Minecraft.m_91087_();
            Font font = mc.f_91062_;
            MutableComponent tip = AlstroemeriaTimeWeatherEvent.getText("als_" + timeWeather.name().toLowerCase());
            pose.m_85836_();
            int spSize = font.m_92895_(tip.getString());
            float maxSize = 28.0f;
            pose.m_85841_((float)spSize < maxSize ? 1.0f : maxSize / (float)spSize, 1.0f, 1.0f);
            float addX2 = (float)spSize < maxSize ? 1.0f : (float)spSize / maxSize;
            gra.drawString(font, tip.getString(), (float)(weight - 137 + addX) * addX2, (float)(height - 186), 0xFFFFFF, true);
            pose.m_85849_();
            MutableComponent text = AlstroemeriaTimeWeatherEvent.getText("sneak_timeweather");
            pose.m_85836_();
            spSize = font.m_92895_(text.getString());
            maxSize = 85.0f;
            pose.m_85841_((float)spSize < maxSize ? 1.0f : maxSize / (float)spSize, 1.0f, 1.0f);
            float addX3 = (float)spSize < maxSize ? 1.0f : (float)spSize / maxSize;
            gra.drawString(font, text.getString(), (float)(weight - 195 + addX) * addX3, (float)(height - 175), 0xFFFFFF, true);
            pose.m_85849_();
            ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
            switch (timeWeather) {
                case SUN: {
                    stackList.add(new ItemStack((ItemLike)ItemInit.fire_nasturtium_petal));
                    break;
                }
                case RAIN: {
                    stackList.add(new ItemStack((ItemLike)ItemInit.dm_flower));
                    break;
                }
                case DAYTIME: {
                    stackList.add(new ItemStack((ItemLike)ItemInit.sannyflower_petal));
                    break;
                }
                case TWILIGHT: {
                    stackList.add(new ItemStack((ItemLike)ItemInit.sannyflower_petal));
                    stackList.add(new ItemStack((ItemLike)ItemInit.moonblossom_petal));
                    break;
                }
                case NIGHT: {
                    stackList.add(new ItemStack((ItemLike)ItemInit.moonblossom_petal));
                }
            }
            for (int i = 0; i < stackList.size(); ++i) {
                ItemStack stack = (ItemStack)stackList.get(i);
                if (stack.m_41619_()) continue;
                gra.m_280480_(stack, weight - 194 + addX + i * 18, height - 180 + addY);
            }
            ++renderTick;
            if (++tickTime % 5 == 0) {
                tickTime = 0;
                timeWeather = null;
            }
        } else {
            renderTick = 0;
        }
    }

    @SubscribeEvent
    public static void highlightBlockEvent(RenderHighlightEvent.Block event) {
        Player player;
        Camera camera = event.getCamera();
        Entity entity = camera.m_90592_();
        if (!(entity instanceof Player) || !(player = (Player)entity).m_21205_().m_41619_()) {
            return;
        }
        if (timeWeather != null) {
            return;
        }
        Level world = player.m_9236_();
        Block block = world.m_8055_(event.getTarget().m_82425_()).m_60734_();
        timeWeather = null;
        if (block instanceof Alstroemeria) {
            Alstroemeria als = (Alstroemeria)block;
            timeWeather = als.getTimeWeather(world, (NonNullList<ItemStack>)player.m_150109_().f_35974_, player);
        }
    }

    public static float getProgress(int maxTime) {
        return Math.min(1.0f, (float)renderTick / (float)maxTime);
    }
}

