/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.event;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.joml.Matrix4f;
import sweetmagic.SweetMagicCore;
import sweetmagic.api.event.SMUtilEvent;
import sweetmagic.event.KeyPressEvent;
import sweetmagic.init.entity.block.Broom;
import sweetmagic.key.SMKeybind;

@OnlyIn(value=Dist.CLIENT)
public class BroomGuiEvent
extends SMUtilEvent {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_usergage.png");
    private static final ResourceLocation TEX2 = SweetMagicCore.getSRC("textures/gui/gui_cook_book.png");

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void renderGuiEvent(RenderGuiOverlayEvent.Post event) {
        Broom broom;
        Entity entity;
        if (!event.getOverlay().id().equals((Object)VanillaGuiOverlay.HOTBAR.id())) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player.m_5833_() || !((entity = player.m_20202_()) instanceof Broom) || (broom = (Broom)entity).m_146895_() != player) {
            return;
        }
        ClientLevel world = mc.f_91073_;
        GuiGraphics gra = event.getGuiGraphics();
        PoseStack pose = gra.m_280168_();
        Matrix4f mat = pose.m_85850_().m_252922_();
        int height = event.getWindow().m_85446_();
        int weight = event.getWindow().m_85445_();
        BroomGuiEvent.renderStart(TEX);
        BroomGuiEvent.renderGUI(mat, height, weight, broom);
        BroomGuiEvent.renderTip(mc, gra, height, weight, broom);
        RenderSystem.disableBlend();
    }

    public static void renderGUI(Matrix4f mat, int height, int weight, Broom broom) {
        boolean isHide = broom.getHide();
        int addY = isHide ? -48 : 0;
        BroomGuiEvent.drawTextured(mat, 10, height - 75 + addY, 0, 217, 47, 10);
        float forwardPower = broom.getFowardPower();
        if (forwardPower > 0.0f) {
            int progress = (int)(45.0f * forwardPower / 50.0f);
            BroomGuiEvent.drawTextured(mat, 11, height - 74 + addY, 1, 227, progress, 8);
        }
        BroomGuiEvent.renderStart(TEX2);
        if (isHide) {
            BroomGuiEvent.drawTextured(mat, 4, height - 164, 0, 162, 100, 26);
        } else {
            BroomGuiEvent.drawTextured(mat, 4, height - 164, 0, 83, 100, 75);
        }
    }

    public static void renderTip(Minecraft mc, GuiGraphics gra, int height, int weight, Broom broom) {
        Font font = mc.f_91062_;
        boolean isHide = broom.getHide();
        PoseStack pose = gra.m_280168_();
        String text = String.format("%,d", broom.getMF()) + "MF";
        int addY = isHide ? -48 : 0;
        gra.m_280488_(font, text, 16, height - 85 + addY, 0xFFFFFF);
        int i = 0;
        float maxSize = 97.0f;
        if (!isHide) {
            MutableComponent keyBroom = KeyPressEvent.getKeyName(SMKeybind.BROOM).m_6881_();
            LinkedHashMap<String, MutableComponent> map = new LinkedHashMap<String, MutableComponent>();
            map.put("w", BroomGuiEvent.getTip("key.forward"));
            map.put("s", BroomGuiEvent.getTip("key.back"));
            map.put("space", BroomGuiEvent.getTip("key.jump"));
            map.put("control", keyBroom);
            for (Map.Entry entry : map.entrySet()) {
                MutableComponent tip = BroomGuiEvent.getText("broom_gui_" + (String)entry.getKey(), ((MutableComponent)entry.getValue()).getString());
                BroomGuiEvent.renderTip(gra, pose, font, (Component)tip, 8, height - 138 + i++ * 9, 96.0f);
            }
        }
        if (!isHide) {
            MutableComponent tip2 = BroomGuiEvent.getText("broom_gui_ad", BroomGuiEvent.getTip("key.left").getString(), BroomGuiEvent.getTip("key.right").getString());
            BroomGuiEvent.renderTip(gra, pose, font, (Component)tip2, 8, height - 138 + i * 9, 96.0f);
        }
        gra.m_280614_(font, (Component)BroomGuiEvent.getText("broom_gui_operation"), 8, height - 160, 0xEEEEEE, true);
        MutableComponent keySpecial = KeyPressEvent.getKeyName(SMKeybind.SPECIAL);
        MutableComponent tip3 = BroomGuiEvent.getText("broom_gui_hide", keySpecial.m_6881_().getString());
        BroomGuiEvent.renderTip(gra, pose, font, (Component)tip3, 8, height - 150, 96.0f);
    }

    public static void renderTip(GuiGraphics gra, PoseStack pose, Font font, Component tip, int x, int y, float maxSize) {
        pose.m_85836_();
        int spSize = font.m_92895_(tip.getString());
        pose.m_85841_((float)spSize < maxSize ? 1.0f : maxSize / (float)spSize, 1.0f, 1.0f);
        float addX = (float)spSize < maxSize ? 1.0f : (float)spSize / maxSize;
        gra.drawString(font, tip.getString(), (float)x + -1.5f * addX, (float)y, 0xEEEEEE, true);
        pose.m_85849_();
    }
}

