/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.event;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import sweetmagic.config.SMConfig;
import sweetmagic.init.capability.icap.IWorldData;

public class EntitiySpawnEvent {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntityCheckSpawn(MobSpawnEvent.FinalizeSpawn event) {
        BlockPos pos;
        if (event.getResult() == Event.Result.ALLOW || event.isCanceled()) {
            return;
        }
        Mob mob = event.getEntity();
        if (mob instanceof Phantom && (Boolean)SMConfig.spawnPhantom.get() == false || mob instanceof Drowned && (Boolean)SMConfig.spawnDrowned.get() == false || mob instanceof WanderingTrader && !((Boolean)SMConfig.spawnTrader.get()).booleanValue()) {
            event.setResult(Event.Result.DENY);
            event.setSpawnCancelled(true);
            event.setCanceled(true);
        }
        if (!(mob instanceof Enemy) && !(mob instanceof Bat) || EntitiySpawnEvent.checkSpawnType(event.getSpawnType())) {
            return;
        }
        Level world = mob.m_9236_();
        if (IWorldData.isPosInRange(world, pos = new BlockPos((int)event.getX(), (int)event.getY(), (int)event.getZ()))) {
            event.setResult(Event.Result.DENY);
            event.setSpawnCancelled(true);
            event.setCanceled(true);
        }
    }

    private static boolean checkSpawnType(MobSpawnType spawnType) {
        switch (spawnType) {
            case BREEDING: 
            case DISPENSER: 
            case BUCKET: 
            case CONVERSION: 
            case SPAWN_EGG: 
            case TRIGGERED: 
            case COMMAND: {
                return true;
            }
        }
        return false;
    }
}

