/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.event;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.api.iitem.IMagicBook;
import sweetmagic.api.iitem.IMagicItem;
import sweetmagic.api.iitem.IPorch;
import sweetmagic.api.iitem.IRobe;
import sweetmagic.api.iitem.IWand;
import sweetmagic.api.iitem.info.BookInfo;
import sweetmagic.api.iitem.info.MagicInfo;
import sweetmagic.api.iitem.info.PorchInfo;
import sweetmagic.api.iitem.info.RobeInfo;
import sweetmagic.init.ItemInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.TagInit;
import sweetmagic.init.entity.projectile.AbstractMagicShot;
import sweetmagic.init.entity.projectile.FireMagicShot;
import sweetmagic.util.PlayerHelper;
import sweetmagic.util.SMDamage;

public class SMLivingDamageEvent {
    private static boolean hasQuillpen = false;

    @SubscribeEvent
    public static void onHurt(LivingHurtEvent event) {
        float damage = event.getAmount();
        if (event.getEntity() == null || damage <= 0.0f) {
            return;
        }
        LivingEntity target = event.getEntity();
        DamageSource src = event.getSource();
        Entity attackEntity = src.m_7639_();
        float oldDamage = damage;
        hasQuillpen = false;
        ItemStack chest = target.m_6844_(EquipmentSlot.CHEST);
        ItemStack leg = target.m_6844_(EquipmentSlot.LEGS);
        if (src.m_269533_(TagInit.SMDAMAGE) && !src.m_276093_(SMDamage.poisonDamage)) {
            if (!chest.m_41619_() && chest.m_41720_() instanceof IRobe) {
                damage = SMLivingDamageEvent.robeMagicDmageCut(target, damage, src, new RobeInfo(chest));
            }
            if (!leg.m_41619_() && leg.m_41720_() instanceof IPorch) {
                damage = SMLivingDamageEvent.porchMagicDmageCut(target, damage, src, new PorchInfo(leg));
            }
        }
        if (attackEntity != null && attackEntity instanceof LivingEntity) {
            Item item;
            ItemStack legAttack;
            LivingEntity attacker = (LivingEntity)attackEntity;
            if ((damage = SMLivingDamageEvent.potionDamageCut(target, attacker, src, damage)) > 0.0f && target instanceof Player) {
                Player player = (Player)target;
                damage = SMLivingDamageEvent.bookCutDamage(player, attacker, damage);
            }
            if (damage > 0.0f && !chest.m_41619_() && chest.m_41720_() instanceof IRobe) {
                damage = SMLivingDamageEvent.robeSMMobDmageCut(target, damage, attacker, new RobeInfo(chest));
            }
            if (damage > 0.0f && !leg.m_41619_() && leg.m_41720_() instanceof IPorch) {
                damage = SMLivingDamageEvent.porchMobDmageCut(target, attacker, oldDamage, damage, src, new PorchInfo(leg));
            }
            if (!(legAttack = attacker.m_6844_(EquipmentSlot.LEGS)).m_41619_() && (item = legAttack.m_41720_()) instanceof IPorch) {
                Entity entity;
                IPorch porch = (IPorch)item;
                if ((damage = SMLivingDamageEvent.porchMobDmageUp(attacker, damage, src, new PorchInfo(legAttack))) >= target.m_21223_() && (entity = src.m_7640_()) instanceof AbstractMagicShot) {
                    AbstractMagicShot magic = (AbstractMagicShot)entity;
                    SMLivingDamageEvent.targetKill(target, attacker, magic, new PorchInfo(legAttack));
                }
            }
            if (oldDamage > damage && !leg.m_41619_() && leg.m_41720_() instanceof IPorch) {
                SMLivingDamageEvent.porchAftereffect(attacker, oldDamage - damage, src, new PorchInfo(leg));
            }
        }
        if (damage > 0.0f) {
            damage = SMLivingDamageEvent.barrierCut(target, leg, damage);
        }
        event.setAmount(damage);
    }

    public static float robeMagicDmageCut(LivingEntity target, float damage, DamageSource src, RobeInfo info) {
        IRobe robe = info.getRobe();
        ItemStack stack = info.getStack();
        if (src.m_269533_(TagInit.SMDAMAGE) && !robe.isMFEmpty(stack)) {
            info.shrinkMF((int)damage * 25);
            damage *= robe.getMagicDamageCut();
        }
        return damage;
    }

    public static float robeSMMobDmageCut(LivingEntity target, float damage, LivingEntity attackEntity, RobeInfo info) {
        IRobe robe = info.getRobe();
        ItemStack stack = info.getStack();
        if (attackEntity instanceof ISMMob && !robe.isMFEmpty(stack)) {
            info.shrinkMF((int)damage * 25);
            damage *= robe.getSMMobDamageCut();
        }
        return damage;
    }

    public static float porchMagicDmageCut(LivingEntity entity, float damage, DamageSource src, PorchInfo info) {
        ItemStack stack;
        Level world = entity.m_9236_();
        IPorch porch = info.getPorch();
        if (porch.getStackList(stack = info.getStack()).isEmpty()) {
            return damage;
        }
        if ((world.m_46468_() % 24000L >= 12000L || entity.m_21023_(MobEffects.f_19611_)) && porch.hasAcce(stack, ItemInit.veil_darkness)) {
            float dameRate = (float)porch.acceCount(stack, ItemInit.veil_darkness, 5) * 0.1f;
            damage *= 1.0f - dameRate;
        }
        hasQuillpen = porch.hasAcce(stack, ItemInit.magician_quillpen);
        return damage;
    }

    public static float porchMobDmageCut(LivingEntity entity, LivingEntity attacker, float oldDamage, float damage, DamageSource src, PorchInfo info) {
        Player player;
        ItemCooldowns cool;
        ItemStack stack;
        Level world = entity.m_9236_();
        IPorch porch = info.getPorch();
        if (porch.getStackList(stack = info.getStack()).isEmpty()) {
            return damage;
        }
        if ((world.m_46468_() % 24000L >= 12000L || entity.m_21023_(MobEffects.f_19611_)) && porch.hasAcce(stack, ItemInit.veil_darkness)) {
            float dameRate = (float)porch.acceCount(stack, ItemInit.veil_darkness, 5) * 0.1f;
            damage *= 1.0f - dameRate;
        }
        if (porch.hasAcce(stack, ItemInit.poison_fang) && entity instanceof Player && !(cool = (player = (Player)entity).m_36335_()).m_41519_(ItemInit.poison_fang)) {
            double counterDamage = (double)oldDamage * 0.25;
            cool.m_41524_(ItemInit.poison_fang, (int)(counterDamage * 20.0));
            attacker.m_21153_((float)Math.max((double)attacker.m_21223_(), counterDamage));
        }
        return damage;
    }

    public static float porchMobDmageUp(LivingEntity entity, float damage, DamageSource src, PorchInfo info) {
        ItemStack stack;
        Level world = entity.m_9236_();
        IPorch porch = info.getPorch();
        if (porch.getStackList(stack = info.getStack()).isEmpty()) {
            return damage;
        }
        if ((world.m_46468_() % 24000L >= 12000L || entity.m_21023_(MobEffects.f_19611_)) && porch.hasAcce(stack, ItemInit.veil_darkness)) {
            float dameRate = (float)porch.acceCount(stack, ItemInit.veil_darkness, 5) * 0.1f;
            damage *= 1.0f + dameRate;
        }
        return damage;
    }

    public static float potionDamageCut(LivingEntity target, LivingEntity attacker, DamageSource src, float damage) {
        float cutRate;
        int level;
        if (target.m_21023_(PotionInit.magic_array)) {
            return 0.0f;
        }
        if (target.m_21023_(PotionInit.aether_shield)) {
            int level2 = target.m_21124_(PotionInit.aether_shield).m_19564_() + 1;
            if (level2 >= 2 && target instanceof Player) {
                Player player = (Player)target;
                Predicate<ItemStack> flag = s -> !s.m_150930_(ItemInit.magic_aether_shield) && !s.m_150930_(ItemInit.magic_aether_shield2);
                List<ItemStack> magicList = IWand.getMagicList(IWand.getWandList(player), flag);
                for (ItemStack stack : magicList) {
                    IMagicItem magic = new MagicInfo(stack).getMagicItem();
                    int recast = magic.getRecastTime(stack);
                    if (recast <= 0) continue;
                    magic.setRecastTime(stack, Math.max(0, (int)((float)recast - damage * 60.0f)));
                }
            }
            return 0.0f;
        }
        if (target.m_21023_(PotionInit.future_vision)) {
            MobEffectInstance effect = target.m_21124_(PotionInit.future_vision);
            int level3 = effect.m_19564_() + 1;
            int time = effect.m_19557_();
            target.m_21195_(PotionInit.future_vision);
            if (level3 < 2) {
                return 0.0f;
            }
            if ((level3 -= 2) >= 1) {
                target.m_7292_(new MobEffectInstance(PotionInit.future_vision, time, level3, true, false));
            }
            return 0.0f;
        }
        if (attacker != null && attacker.m_21023_(PotionInit.flame)) {
            damage *= 0.67f;
        }
        if (target.m_21023_(PotionInit.damage_cut)) {
            level = target.m_21124_(PotionInit.damage_cut).m_19564_();
            cutRate = 1.0f - (0.1f + (float)level * 0.075f);
            damage *= cutRate;
        }
        if (target.m_21023_(PotionInit.aether_barrier)) {
            level = target.m_21124_(PotionInit.aether_barrier).m_19564_() + 1;
            cutRate = 1.5f + (float)level * 0.1f;
            damage /= cutRate;
            if (attacker instanceof Warden) {
                damage *= 0.25f;
            }
        }
        if (target.m_21023_(PotionInit.aether_armor)) {
            MobEffectInstance effect = target.m_21124_(PotionInit.aether_armor);
            int time = effect.m_19557_();
            int level4 = effect.m_19564_() + 1;
            if (attacker instanceof Warden) {
                damage = Math.max(0.0f, damage - 10.0f);
            }
            int maxValue = 2 + level4 * 2;
            time = (int)((float)time - Math.min((float)maxValue, damage) * 20.0f / (float)(hasQuillpen ? 4 : 1));
            damage = Math.max(0.0f, damage - (float)maxValue);
            target.m_7292_(new MobEffectInstance(effect.m_19544_(), time, level4 - 1, true, false));
        }
        if (target.m_21023_(PotionInit.queen_bless)) {
            damage *= 0.75f;
        }
        if (target.m_21023_(PotionInit.witch_bless)) {
            MobEffectInstance effect = target.m_21124_(PotionInit.witch_bless);
            int time = effect.m_19557_();
            damage -= (float)time;
            time = (int)((float)time - damage * 40.0f / (float)(hasQuillpen ? 4 : 1));
            target.m_7292_(new MobEffectInstance(effect.m_19544_(), time, 0, true, false));
            if (damage <= 0.0f) {
                return 0.0f;
            }
        }
        if (target.m_21023_(PotionInit.deadly_poison) && damage > 0.0f) {
            int level5 = target.m_21124_(PotionInit.deadly_poison).m_19564_() + 1;
            float addDama = target.m_6095_().m_204039_(TagInit.BOSS) && !(target instanceof Warden) ? (float)level5 * 1.0f : (float)level5 * 1.5f;
            damage += addDama;
        }
        if (target.m_21023_(PotionInit.magic_damage_receive) && src.m_7640_() instanceof AbstractMagicShot) {
            damage += (float)(target.m_21124_(PotionInit.magic_damage_receive).m_19564_() + 1);
        }
        return Math.max(0.0f, damage);
    }

    public static float bookCutDamage(Player player, LivingEntity attacker, float damage) {
        BookInfo info;
        IMagicBook book;
        List<ItemStack> stackBookList = IMagicBook.getBookList(player);
        if (stackBookList.isEmpty()) {
            return damage;
        }
        float addChance = 0.0f;
        if (player.m_21023_(PotionInit.attack_disable)) {
            addChance += 10.0f + (float)player.m_21124_(PotionInit.attack_disable).m_19564_() * 5.0f;
        }
        return (book = (info = new BookInfo(stackBookList.get(0))).getBook()).checkChance(book.getRecastPage(info) + addChance, player.m_9236_()) ? 0.0f : damage;
    }

    public static float barrierCut(LivingEntity target, ItemStack leg, float damage) {
        IPorch porch;
        Item item;
        if (!target.m_21023_(PotionInit.aether_barrier_origin)) {
            return damage;
        }
        MobEffectInstance effect = target.m_21124_(PotionInit.aether_barrier_origin);
        int time = effect.m_19557_();
        int level = effect.m_19564_();
        float cutTime = damage * 20.0f;
        if (!leg.m_41619_() && (item = leg.m_41720_()) instanceof IPorch && (porch = (IPorch)item).hasAcce(leg, ItemInit.magician_quillpen)) {
            cutTime *= 0.25f;
        }
        target.m_21195_(PotionInit.aether_barrier_origin);
        target.m_7292_(new MobEffectInstance(PotionInit.aether_barrier_origin, time - (int)cutTime, level, true, false));
        return damage / (float)(level + 1);
    }

    public static void targetKill(LivingEntity target, LivingEntity attacker, AbstractMagicShot shot, PorchInfo info) {
        int warriorCount;
        ItemStack stack = info.getStack();
        IPorch porch = info.getPorch();
        int bloodCount = porch.acceCount(stack, ItemInit.blood_sucking_ring, 5);
        if (bloodCount > 0) {
            attacker.m_5634_(attacker.m_21233_() * (float)bloodCount * 0.1f);
        }
        if ((warriorCount = porch.acceCount(stack, ItemInit.warrior_bracelet, 5)) > 0) {
            int time = 2400 * warriorCount;
            attacker.m_7292_(new MobEffectInstance(MobEffects.f_19600_, time, 2, true, false));
            attacker.m_7292_(new MobEffectInstance(PotionInit.drop_increase, time, 0, true, false));
        }
        if (porch.hasAcce(stack, ItemInit.ignis_soul) && shot instanceof FireMagicShot) {
            List<ItemStack> magicList = IWand.getMagicList(IWand.getWandList((Player)attacker), e -> true);
            for (ItemStack s : magicList) {
                IMagicItem magic = new MagicInfo(s).getMagicItem();
                int recast = magic.getRecastTime(s);
                if (recast <= 0) continue;
                magic.setRecastTime(s, Math.max(0, (int)((float)recast - (float)magic.getMaxRecastTime() * 0.1f)));
            }
        }
    }

    public static void porchAftereffect(LivingEntity entity, float damage, DamageSource src, PorchInfo info) {
        if (info.getPorch().hasAcce(info.getStack(), ItemInit.angel_flugel)) {
            entity.m_5634_(damage * 0.025f);
        }
    }

    public static void attackDisabled(LivingEntity target, PorchInfo info) {
        if (!info.getPorch().hasAcce(info.getStack(), ItemInit.angel_flugel)) {
            return;
        }
        PlayerHelper.setPotion(target, PotionInit.regeneration, 0, 200);
        PlayerHelper.setPotion(target, MobEffects.f_19600_, 3, 400);
        PlayerHelper.setPotion(target, PotionInit.mfcostdown, 2, 400);
    }
}

