/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.event;

import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import sweetmagic.api.iitem.IMFTool;
import sweetmagic.api.iitem.IPorch;
import sweetmagic.init.EnchantInit;
import sweetmagic.init.ItemInit;

public class XPPickupEvent {
    private static final EquipmentSlot[] ARMORSLOT = new EquipmentSlot[]{EquipmentSlot.MAINHAND, EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};

    @SubscribeEvent
    public static void onBulletRenderEvent(PlayerXpEvent.PickupXp event) {
        int xpValue = event.getOrb().f_20770_;
        Player player = event.getEntity();
        if (player == null || xpValue < 1) {
            return;
        }
        for (EquipmentSlot slot : ARMORSLOT) {
            ItemStack stack = player.m_6844_(slot);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            if (item instanceof IMFTool) {
                IMFTool mfTool = (IMFTool)item;
                if (mfTool.isMaxMF(stack)) continue;
                XPPickupEvent.healRepair(player, stack, mfTool, xpValue);
                continue;
            }
            item = stack.m_41720_();
            if (!(item instanceof IPorch)) continue;
            IPorch porch = (IPorch)item;
            XPPickupEvent.emelaldPiasEffect(player, stack, porch, xpValue);
        }
    }

    public static boolean healRepair(Player player, ItemStack stack, IMFTool mfTool, int value) {
        int level = EnchantmentHelper.m_44843_((Enchantment)EnchantInit.aetherheal, (ItemStack)stack);
        if (level <= 0 || mfTool.isMaxMF(stack)) {
            return false;
        }
        value = value >= 4 ? value / 3 : value;
        mfTool.insetMF(stack, value *= level);
        return true;
    }

    public static void emelaldPiasEffect(Player player, ItemStack stack, IPorch porch, int value) {
        int count = porch.acceCount(stack, ItemInit.emelald_pias, 10);
        if (count <= 0) {
            return;
        }
        float addXPRate = (float)count * 0.1f;
        float expValue = (float)value * addXPRate;
        player.m_6756_((int)expValue);
        player.m_5634_(expValue * 0.1f);
    }
}

