/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.handler;

import com.mojang.serialization.Codec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;
import sweetmagic.config.SMConfig;
import sweetmagic.event.AdvancedEvent;
import sweetmagic.event.AlstroemeriaClickEvent;
import sweetmagic.event.BlockBreakEvent;
import sweetmagic.event.BroomGuiEvent;
import sweetmagic.event.CompasRenderEvent;
import sweetmagic.event.EntitiySpawnEvent;
import sweetmagic.event.EquipmentChangeEvent;
import sweetmagic.event.KeyPressEvent;
import sweetmagic.event.LivingDethEvent;
import sweetmagic.event.PotionEvent;
import sweetmagic.event.SMLivingDamageEvent;
import sweetmagic.event.SMLivingTickEvent;
import sweetmagic.event.SMPlayerEvent;
import sweetmagic.event.VillagerEvent;
import sweetmagic.event.WandRenderEvent;
import sweetmagic.event.XPPickupEvent;
import sweetmagic.handler.GrassDropHandler;
import sweetmagic.init.BlockInit;
import sweetmagic.init.CapabilityInit;
import sweetmagic.init.EnchantInit;
import sweetmagic.init.EntityInit;
import sweetmagic.init.FeatuerInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.MenuInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.RecipeSerializerInit;
import sweetmagic.init.RecipeTypeInit;
import sweetmagic.init.RenderEntityInit;
import sweetmagic.init.SoundInit;
import sweetmagic.init.StructureInit;
import sweetmagic.init.TabInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.VillageInit;
import sweetmagic.worldgen.entity.EntityModifier;
import sweetmagic.worldgen.loot.LootTableModifier;

public class RegisterHandler {
    public static final RegisterHandler INSTANCE = new RegisterHandler();
    public static final DeferredRegister<Codec<? extends BiomeModifier>> BIOME_REGISTER = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"sweetmagic");
    public static RegistryObject<Codec<EntityModifier>> ENHTITY_REGISTER = BIOME_REGISTER.register("smmob_spawn", () -> Codec.unit((Object)EntityModifier.INSTANCE));
    public static final DeferredRegister<Codec<? extends IGlobalLootModifier>> LOOT_MODIFIER = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"sweetmagic");

    public void registerInit(IEventBus event) {
        event.addListener(BlockInit::registerBlock);
        event.addListener(ItemInit::registerItem);
        event.addListener(TileInit::registerTile);
        event.addListener(EntityInit::registerEntity);
        event.addListener(EntityInit::registerAttribute);
        event.addListener(EnchantInit::registerEnchant);
        event.addListener(PotionInit::registerPotion);
        event.addListener(TabInit::registerTabItems);
        ParticleInit.REGISTRY.register(event);
        RecipeTypeInit.REGISTRY.register(event);
        RecipeSerializerInit.REGISTRY.register(event);
        FeatuerInit.REGISTER.register(event);
        VillageInit.PRO_TYPE.register(event);
        VillageInit.POI_TYPE.register(event);
        TabInit.REGISTRY.register(event);
        StructureInit.REGISTRY.register(event);
        StructureInit.init();
        BIOME_REGISTER.register(event);
        LOOT_MODIFIER.register(event);
        LOOT_MODIFIER.register("add_loot_table", LootTableModifier.CODEC);
        IEventBus bus = MinecraftForge.EVENT_BUS;
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            event.addListener(RenderEntityInit::registerRenderEntity);
            event.addListener(RenderEntityInit::registerRenderLayer);
            event.addListener(ParticleInit::registerParticle);
            bus.addListener(WandRenderEvent::onWandRenderEvent);
            bus.addListener(WandRenderEvent::onFOVEvent);
            bus.addListener(CompasRenderEvent::onWandRenderEvent);
            bus.addListener(BroomGuiEvent::renderGuiEvent);
            MenuInit.registerGUI();
        });
        event.addListener(SoundInit::registerSound);
        bus.addGenericListener(Entity.class, CapabilityInit::attachEntityCapability);
        bus.addGenericListener(Level.class, CapabilityInit::attachEntityCapabilitys);
        event.addListener(CapabilityInit::registerCapability);
    }

    public void registerEvent(IEventBus event) {
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.register((Object)this);
        bus.addListener(LivingDethEvent::onEvent);
        bus.addListener(LivingDethEvent::onPlayerRespawn);
        bus.addListener(LivingDethEvent::onLivingDeathEvent);
        bus.addListener(LivingDethEvent::onPlayerLogout);
        bus.addListener(LivingDethEvent::cloneEvent);
        bus.addListener(LivingDethEvent::loginEvent);
        bus.addListener(LivingDethEvent::dropEvent);
        bus.addListener(LivingDethEvent::dropExpEvent);
        bus.addListener(XPPickupEvent::onBulletRenderEvent);
        bus.addListener(SMLivingDamageEvent::onHurt);
        bus.addListener(EntitiySpawnEvent::onEntityCheckSpawn);
        bus.addListener(AlstroemeriaClickEvent::rightClickBlock);
        bus.addListener(BlockBreakEvent::onBlockBreakEvent);
        bus.addListener(BlockBreakEvent::onBlockPlaceEvent);
        bus.addListener(SMLivingTickEvent::onTickEvent);
        bus.addListener(SMLivingTickEvent::mobGriefingEvent);
        bus.addListener(EquipmentChangeEvent::changeEvent);
        bus.addListener(PotionEvent::healEvent);
        bus.addListener(PotionEvent::potionAddEvent);
        bus.addListener(PotionEvent::potionRemoveEvent);
        bus.addListener(PotionEvent::knockBackEvent);
        bus.addListener(PotionEvent::fallEvent);
        bus.addListener(PotionEvent::teleportEvent);
        bus.addListener(VillagerEvent::villagerTrade);
        bus.addListener(SMPlayerEvent::sleepEvent);
        bus.addListener(SMPlayerEvent::onPlayerSetSpawn);
        bus.addListener(SMPlayerEvent::onSleepTimeCheck);
        bus.addListener(SMPlayerEvent::onPlayerSleep);
        bus.addListener(AdvancedEvent::addAdvanced);
    }

    public void registerConfig() {
        SMConfig.loadConfig(SMConfig.SPEC, FMLPaths.CONFIGDIR.get().resolve("sweetmagic-server.toml"));
    }

    public void registerGrassDrop(IEventBus event) {
        GrassDropHandler.REGISTER.register(event);
    }

    public static void onRegisterEvent(RegisterEvent event) {
        ResourceKey key = event.getRegistryKey();
        if (key.equals((Object)ForgeRegistries.Keys.MENU_TYPES)) {
            MenuInit.registerMenu(event);
        }
    }

    @SubscribeEvent
    public static void registerKeybind(RegisterKeyMappingsEvent event) {
        KeyPressEvent.registerKeybind(event);
    }
}

