/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import sweetmagic.SweetMagicCore;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.entity.animal.StellaWizard;
import sweetmagic.init.entity.animal.WitchAllay;
import sweetmagic.init.entity.animal.WitchCat;
import sweetmagic.init.entity.animal.WitchFox;
import sweetmagic.init.entity.animal.WitchGolem;
import sweetmagic.init.entity.animal.WitchIfrit;
import sweetmagic.init.entity.animal.WitchKitt;
import sweetmagic.init.entity.animal.WitchMaster;
import sweetmagic.init.entity.animal.WitchWindine;
import sweetmagic.init.entity.animal.WitchWolf;
import sweetmagic.init.entity.block.Broom;
import sweetmagic.init.entity.block.Chair;
import sweetmagic.init.entity.block.Cushion;
import sweetmagic.init.entity.block.Hitbox;
import sweetmagic.init.entity.monster.ArchSpider;
import sweetmagic.init.entity.monster.BlazeTempest;
import sweetmagic.init.entity.monster.BlazeTempestTornado;
import sweetmagic.init.entity.monster.BlitzWizard;
import sweetmagic.init.entity.monster.CherryPlant;
import sweetmagic.init.entity.monster.CreeperCalamity;
import sweetmagic.init.entity.monster.DwarfZombie;
import sweetmagic.init.entity.monster.DwarfZombieMaster;
import sweetmagic.init.entity.monster.ElectricCube;
import sweetmagic.init.entity.monster.ElectricGolem;
import sweetmagic.init.entity.monster.EnderMage;
import sweetmagic.init.entity.monster.EnderShadow;
import sweetmagic.init.entity.monster.EnderShadowMirage;
import sweetmagic.init.entity.monster.GemStone;
import sweetmagic.init.entity.monster.PhantomWolf;
import sweetmagic.init.entity.monster.PixeVex;
import sweetmagic.init.entity.monster.SkullFlame;
import sweetmagic.init.entity.monster.SkullFlameArcher;
import sweetmagic.init.entity.monster.SkullFrost;
import sweetmagic.init.entity.monster.SkullFrostRoyalGuard;
import sweetmagic.init.entity.monster.WindWitch;
import sweetmagic.init.entity.monster.WitchCrystal;
import sweetmagic.init.entity.monster.boss.AncientFairy;
import sweetmagic.init.entity.monster.boss.Arlaune;
import sweetmagic.init.entity.monster.boss.BlitzWizardMaster;
import sweetmagic.init.entity.monster.boss.BraveSkeleton;
import sweetmagic.init.entity.monster.boss.BullFight;
import sweetmagic.init.entity.monster.boss.DemonsBelial;
import sweetmagic.init.entity.monster.boss.ElshariaCurious;
import sweetmagic.init.entity.monster.boss.GemFrog;
import sweetmagic.init.entity.monster.boss.HolyAngel;
import sweetmagic.init.entity.monster.boss.IgnisKnight;
import sweetmagic.init.entity.monster.boss.QueenFrost;
import sweetmagic.init.entity.monster.boss.SilverLandRoad;
import sweetmagic.init.entity.monster.boss.StellaWizardMaster;
import sweetmagic.init.entity.monster.boss.TwilightHora;
import sweetmagic.init.entity.monster.boss.WhiteButler;
import sweetmagic.init.entity.monster.boss.WindWitchMaster;
import sweetmagic.init.entity.monster.boss.WitchSandryon;
import sweetmagic.init.entity.projectile.BelialFlameShot;
import sweetmagic.init.entity.projectile.BelialSword;
import sweetmagic.init.entity.projectile.BloodMagicShot;
import sweetmagic.init.entity.projectile.BraveShot;
import sweetmagic.init.entity.projectile.BubbleMagicShot;
import sweetmagic.init.entity.projectile.BubleFrogshot;
import sweetmagic.init.entity.projectile.BulletMagicShot;
import sweetmagic.init.entity.projectile.CalamityBomb;
import sweetmagic.init.entity.projectile.CherryMagicShot;
import sweetmagic.init.entity.projectile.CherryRainMagic;
import sweetmagic.init.entity.projectile.CommetBulet;
import sweetmagic.init.entity.projectile.CriticalMagicShot;
import sweetmagic.init.entity.projectile.CycloneMagicShot;
import sweetmagic.init.entity.projectile.DigMagicShot;
import sweetmagic.init.entity.projectile.ElectricMagicShot;
import sweetmagic.init.entity.projectile.ElectricSphere;
import sweetmagic.init.entity.projectile.EnderBall;
import sweetmagic.init.entity.projectile.EvilArrow;
import sweetmagic.init.entity.projectile.ExplosionMagicShot;
import sweetmagic.init.entity.projectile.ExplosionThunderShot;
import sweetmagic.init.entity.projectile.FireMagicShot;
import sweetmagic.init.entity.projectile.FrostLaserMagic;
import sweetmagic.init.entity.projectile.FrostMagicShot;
import sweetmagic.init.entity.projectile.GemShot;
import sweetmagic.init.entity.projectile.GravityMagicShot;
import sweetmagic.init.entity.projectile.HolyBusterMagic;
import sweetmagic.init.entity.projectile.IgnisBlastMagic;
import sweetmagic.init.entity.projectile.InfinitWandMagic;
import sweetmagic.init.entity.projectile.KnifeShot;
import sweetmagic.init.entity.projectile.LightMagicShot;
import sweetmagic.init.entity.projectile.LightningRod;
import sweetmagic.init.entity.projectile.LigningBulletShot;
import sweetmagic.init.entity.projectile.MagicSquareMagic;
import sweetmagic.init.entity.projectile.NormalMagicShot;
import sweetmagic.init.entity.projectile.PoisonMagicShot;
import sweetmagic.init.entity.projectile.RockBlastMagicShot;
import sweetmagic.init.entity.projectile.ShootingStar;
import sweetmagic.init.entity.projectile.SickleShot;
import sweetmagic.init.entity.projectile.SoulBlazeShot;
import sweetmagic.init.entity.projectile.ToxicCircle;
import sweetmagic.init.entity.projectile.TridentThunder;
import sweetmagic.init.entity.projectile.TripleTornadoShot;
import sweetmagic.init.entity.projectile.TwiLightShot;
import sweetmagic.init.entity.projectile.WindStormMagic;
import sweetmagic.init.entity.projectile.WindStormShot;

public class EntityInit {
    private static final MobCategory MISC = MobCategory.MISC;
    private static final MobCategory CREATURE = MobCategory.CREATURE;
    private static final MobCategory MONSTER = MobCategory.MONSTER;
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPE = SweetMagicCore.getDef(ForgeRegistries.ENTITY_TYPES);
    public static Map<EntityType<?>, String> entityMap = new LinkedHashMap();
    public static Map<EntityInfo, String> entityEggMap = new LinkedHashMap<EntityInfo, String>();
    public static List<Item> eggList = new ArrayList<Item>();
    public static EntityType<EnderBall> enderBall = EntityInit.getEntity("enderball", EnderBall::new);
    public static EntityType<EvilArrow> evilArrow = EntityInit.getEntity("evilarrow", EvilArrow::new);
    public static EntityType<CalamityBomb> calamityBomb = EntityInit.getEntity("calamitybomb", CalamityBomb::new);
    public static EntityType<LightningRod> lightningRod = EntityInit.getEntity("lightningrod", LightningRod::new);
    public static EntityType<TridentThunder> tridentThunder = EntityInit.getEntity("tridentthunder", TridentThunder::new, MISC, 0.5f, 0.5f);
    public static EntityType<LightMagicShot> lightMagic = EntityInit.getEntity("lightmagic", LightMagicShot::new);
    public static EntityType<FireMagicShot> fireMagic = EntityInit.getEntity("firemagic", FireMagicShot::new);
    public static EntityType<FrostMagicShot> frostMagic = EntityInit.getEntity("frostmagic", FrostMagicShot::new);
    public static EntityType<CycloneMagicShot> cycloneMagic = EntityInit.getEntity("cyclonemagic", CycloneMagicShot::new);
    public static EntityType<ExplosionMagicShot> explosionMagic = EntityInit.getEntity("explosionmagic", ExplosionMagicShot::new);
    public static EntityType<GravityMagicShot> gravityMagic = EntityInit.getEntity("gravitymagic", GravityMagicShot::new);
    public static EntityType<PoisonMagicShot> poisonMagic = EntityInit.getEntity("poisonmagic", PoisonMagicShot::new);
    public static EntityType<ElectricMagicShot> electricMagic = EntityInit.getEntity("electricmagic", ElectricMagicShot::new);
    public static EntityType<DigMagicShot> digMagic = EntityInit.getEntity("digmagic", DigMagicShot::new);
    public static EntityType<NormalMagicShot> normalMagic = EntityInit.getEntity("normalmagic", NormalMagicShot::new);
    public static EntityType<CriticalMagicShot> criticalMagic = EntityInit.getEntity("criticalmagic", CriticalMagicShot::new);
    public static EntityType<BulletMagicShot> bulletMagic = EntityInit.getEntity("bulletmagic", BulletMagicShot::new);
    public static EntityType<BubbleMagicShot> bubbleMagic = EntityInit.getEntity("bubblemagic", BubbleMagicShot::new);
    public static EntityType<BloodMagicShot> bloodMagic = EntityInit.getEntity("bloodmagic", BloodMagicShot::new);
    public static EntityType<RockBlastMagicShot> rockBlastMagic = EntityInit.getEntity("rockblastmagic", RockBlastMagicShot::new);
    public static EntityType<FrostLaserMagic> frostLaser = EntityInit.getEntity("frost_laser", FrostLaserMagic::new);
    public static EntityType<HolyBusterMagic> holyBusert = EntityInit.getEntity("holy_buster", HolyBusterMagic::new);
    public static EntityType<IgnisBlastMagic> ignisBlast = EntityInit.getEntity("ignis_blast", IgnisBlastMagic::new);
    public static EntityType<WindStormMagic> windStorm = EntityInit.getEntity("wind_storm", WindStormMagic::new);
    public static EntityType<MagicSquareMagic> magicSquare = EntityInit.getEntity("magic_square", MagicSquareMagic::new, MISC, 1.0f, 0.001f);
    public static EntityType<TripleTornadoShot> tripleTornado = EntityInit.getEntity("triple_tprnado", TripleTornadoShot::new, MISC, 1.0f, 0.001f);
    public static EntityType<WindStormShot> windBlast = EntityInit.getEntity("wind_blast", WindStormShot::new);
    public static EntityType<CherryRainMagic> cherryRain = EntityInit.getEntity("cherry_rain", CherryRainMagic::new);
    public static EntityType<CherryMagicShot> cherryMagic = EntityInit.getEntity("cherrymagic", CherryMagicShot::new);
    public static EntityType<ToxicCircle> toxicCircle = EntityInit.getEntity("toxic_circle", ToxicCircle::new);
    public static EntityType<KnifeShot> knifeShot = EntityInit.getEntity("knifeshot", KnifeShot::new);
    public static EntityType<SickleShot> sickleShot = EntityInit.getEntity("sickleshot", SickleShot::new);
    public static EntityType<SoulBlazeShot> soulBlazeShot = EntityInit.getEntity("soulblaze", SoulBlazeShot::new);
    public static EntityType<TwiLightShot> twiLightShot = EntityInit.getEntity("twilightshot", TwiLightShot::new);
    public static EntityType<BraveShot> braveShot = EntityInit.getEntity("braveshot", BraveShot::new);
    public static EntityType<ExplosionThunderShot> explosionThunder = EntityInit.getEntity("explosionthunder", ExplosionThunderShot::new);
    public static EntityType<LigningBulletShot> ligningBullet = EntityInit.getEntity("ligningbullet", LigningBulletShot::new);
    public static EntityType<InfinitWandMagic> infinitWand = EntityInit.getEntity("infinit_wand", InfinitWandMagic::new);
    public static EntityType<ElectricSphere> electricSphere = EntityInit.getEntity("electricsphere", ElectricSphere::new);
    public static EntityType<CommetBulet> commetBulet = EntityInit.getEntity("commetbulet", CommetBulet::new);
    public static EntityType<ShootingStar> shootingStar = EntityInit.getEntity("shooting_star", ShootingStar::new);
    public static EntityType<BelialFlameShot> belialFlameShot = EntityInit.getEntity("belial_flame", BelialFlameShot::new);
    public static EntityType<BelialSword> belialSword = EntityInit.getEntity("belial_sword", BelialSword::new, MISC, 1.5f, 3.0f);
    public static EntityType<GemShot> gemShot = EntityInit.getEntity("gemshot", GemShot::new);
    public static EntityType<BubleFrogshot> bubleFrogShot = EntityInit.getEntity("bublefrog", BubleFrogshot::new);
    public static EntityType<Chair> chair = EntityInit.getEntity("chair", Chair::new);
    public static EntityType<Cushion> cushion = EntityInit.getEntityFire("cushion", Cushion::new, MISC, 0.75f, 0.0625f);
    public static EntityType<Broom> broom = EntityInit.getEntityFire("broom", Broom::new, MISC, 1.0f, 0.9f);
    public static EntityType<Hitbox> hitbox = EntityInit.getEntityFire("hitbox", Hitbox::new, MISC, 1.0f, 0.9f);
    public static EntityType<WitchCrystal> witchCrystal = EntityInit.getEntity("witch_crystal", WitchCrystal::new, MONSTER, 1.0f, 2.0f);
    public static EntityType<CherryPlant> cherryPlant = EntityInit.getEntity("cherry_plant", CherryPlant::new, MONSTER, 1.75f, 1.75f);
    public static EntityType<GemStone> gemStone = EntityInit.getEntity("gem_stone", GemStone::new, MONSTER, 1.75f, 1.75f);
    public static EntityType<WitchWolf> witchWolf = EntityInit.getEntityFire("witch_wolf", WitchWolf::new, CREATURE, 0.85f, 0.9f);
    public static EntityType<WitchAllay> witchAllay = EntityInit.getEntityFire("witch_allay", WitchAllay::new, CREATURE, 0.75f, 0.75f);
    public static EntityType<WitchGolem> witchGolem = EntityInit.getEntityFire("witch_golem", WitchGolem::new, CREATURE, 1.25f, 2.75f);
    public static EntityType<WitchFox> witchFox = EntityInit.getEntityFire("witch_fox", WitchFox::new, CREATURE, 0.85f, 0.9f);
    public static EntityType<WitchCat> witchCat = EntityInit.getEntityFire("witch_cat", WitchCat::new, CREATURE, 0.85f, 0.9f);
    public static EntityType<WitchMaster> witchMaster = EntityInit.getEntityFire("witch_master", WitchMaster::new, CREATURE, 0.7f, 1.275f);
    public static EntityType<WitchWindine> witchWindine = EntityInit.getEntityFire("witch_windine", WitchWindine::new, CREATURE, 0.8f, 1.95f);
    public static EntityType<WitchIfrit> witchIfrit = EntityInit.getEntityFire("witch_ifrit", WitchIfrit::new, CREATURE, 0.8f, 1.95f);
    public static EntityType<WitchKitt> witchKitt = EntityInit.getEntityFire("witch_kitt", WitchKitt::new, CREATURE, 0.8f, 1.5f);
    public static EntityType<StellaWizard> stellaWizard = EntityInit.getEntityFire("stella_wizard", StellaWizard::new, CREATURE, 1.0f, 2.25f);
    public static EntityType<SkullFrost> skullFrost = EntityInit.getEntityEgg("skullfrost", SkullFrost::new, true, 0.6f, 1.99f, 7842303);
    public static EntityType<BlazeTempest> blazeTempest = EntityInit.getEntityEgg("blazetempest", BlazeTempest::new, true, 0.6f, 1.8f, 1753367);
    public static EntityType<ArchSpider> archSpider = EntityInit.getEntityEgg("archspider", ArchSpider::new, false, 2.0f, 1.2f, 12197663);
    public static EntityType<ElectricCube> electricCube = EntityInit.getEntityEgg("electriccube", ElectricCube::new, false, 2.04f, 2.04f, 15385151);
    public static EntityType<CreeperCalamity> creeperCalamity = EntityInit.getEntityEgg("creepercalamity", CreeperCalamity::new, false, 0.6f, 1.7f, 0x5B5B5B);
    public static EntityType<EnderMage> enderMage = EntityInit.getEntityEgg("endermage", EnderMage::new, false, 0.85f, 2.9f, 12859375);
    public static EntityType<SkullFlame> skullFlame = EntityInit.getEntityEgg("skullflame", SkullFlame::new, true, 0.6f, 1.99f, 16017208);
    public static EntityType<DwarfZombie> dwarfZombie = EntityInit.getEntityEgg("dwarfzombie", DwarfZombie::new, true, 0.6f, 1.99f, 9850164);
    public static EntityType<WindWitch> windWitch = EntityInit.getEntityEgg("windwitch", WindWitch::new, true, 0.45f, 1.4f, 6507327);
    public static EntityType<PixeVex> pixeVex = EntityInit.getEntityEgg("pixevex", PixeVex::new, true, 0.525f, 1.4f, 16752292);
    public static EntityType<PhantomWolf> phantomWolf = EntityInit.getEntityEgg("phantomwolf", PhantomWolf::new, true, 0.525f, 1.4f, 0xE5E5E5);
    public static EntityType<SkullFrostRoyalGuard> skullFrostRoyalGuard = EntityInit.getEntityUniqueEgg("skullfrost_royalguard", SkullFrostRoyalGuard::new, true, 1.0f, 2.6f, 7842303);
    public static EntityType<SkullFlameArcher> skullFlameArcher = EntityInit.getEntityUniqueEgg("skullflame_archer", SkullFlameArcher::new, true, 1.0f, 2.6f, 16017208);
    public static EntityType<BlazeTempestTornado> blazeTempestTornado = EntityInit.getEntityUniqueEgg("blazetempest_tornado", BlazeTempestTornado::new, false, 1.0f, 2.6f, 1753367);
    public static EntityType<EnderShadow> enderShadow = EntityInit.getEntityUniqueEgg("endershadow", EnderShadow::new, false, 0.85f, 3.5f, 12859375);
    public static EntityType<EnderShadowMirage> enderShadowMirage = EntityInit.getEntity("endershadow_mirage", EnderShadowMirage::new, MONSTER, 0.85f, 2.9f);
    public static EntityType<DwarfZombieMaster> dwarfZombieMaster = EntityInit.getEntityUniqueEgg("dwarfzombie_master", DwarfZombieMaster::new, true, 1.0f, 2.6f, 9850164);
    public static EntityType<ElectricGolem> electricGolem = EntityInit.getEntityUniqueEgg("electricgolem", ElectricGolem::new, true, 1.25f, 2.75f, 15385151);
    public static EntityType<BlitzWizard> blitzWizard = EntityInit.getEntityUniqueEgg("blitz_wizard", BlitzWizard::new, true, 1.2f, 2.25f, 11150671);
    public static EntityType<QueenFrost> queenFrost = EntityInit.getEntityBossEgg("queenfrost", QueenFrost::new, 1.2f, 3.75f, 8106999);
    public static EntityType<HolyAngel> holyAngel = EntityInit.getEntityBossEgg("holyangel", HolyAngel::new, 1.2f, 3.75f, 6821167);
    public static EntityType<IgnisKnight> ignisKnight = EntityInit.getEntityBossEgg("ignisknight", IgnisKnight::new, 1.2f, 2.25f, 5066165);
    public static EntityType<WindWitchMaster> windWitchMaster = EntityInit.getEntityBossEgg("windwitch_master", WindWitchMaster::new, 1.2f, 2.25f, 1753367);
    public static EntityType<BullFight> bullfight = EntityInit.getEntityBossEgg("bullfight", BullFight::new, 3.0f, 2.25f, 16730380);
    public static EntityType<AncientFairy> ancientFairy = EntityInit.getEntityBossEgg("ancientfairy", AncientFairy::new, 1.2f, 3.5f, 9237157);
    public static EntityType<Arlaune> arlaune = EntityInit.getEntityBossEgg("arlaune", Arlaune::new, 1.2f, 2.5f, 16422063);
    public static EntityType<GemFrog> gemFrog = EntityInit.getEntityBossEgg("gemfrog", GemFrog::new, 4.0f, 3.0f, 9798945);
    public static EntityType<SilverLandRoad> silverLandRoad = EntityInit.getEntityBossEgg("silver_landroad", SilverLandRoad::new, 2.0f, 2.0f, 0xE5E5E5);
    public static EntityType<WhiteButler> whiteButler = EntityInit.getEntityBossEgg("white_butler", WhiteButler::new, 1.2f, 2.5f, 0xA5A5A5);
    public static EntityType<BlitzWizardMaster> blitzWizardMaster = EntityInit.getEntityBossEgg("blitz_wizard_master", BlitzWizardMaster::new, 1.2f, 2.5f, 11150671);
    public static EntityType<StellaWizardMaster> stellaWizardMaster = EntityInit.getEntityBossEgg("stella_wizard_master", StellaWizardMaster::new, 1.2f, 2.5f, 15133282);
    public static EntityType<DemonsBelial> demonsBelial = EntityInit.getEntityBossEgg("demons_belial", DemonsBelial::new, 1.75f, 3.25f, 396318);
    public static EntityType<TwilightHora> twilightHora = EntityInit.getEntityBossEgg("twilight_hora", TwilightHora::new, 1.2f, 2.5f, 10828602);
    public static EntityType<BraveSkeleton> braveSkeleton = EntityInit.getEntityBossEgg("brave_skeleton", BraveSkeleton::new, 1.2f, 3.0f, 16537344);
    public static EntityType<ElshariaCurious> elshariaCurious = EntityInit.getEntityBossEgg("elsharia_curious", ElshariaCurious::new, 1.2f, 3.5f, 996428);
    public static EntityType<WitchSandryon> witchSandryon = EntityInit.getEntityBossEgg("witch_sandryon", WitchSandryon::new, 1.2f, 2.25f, 10480889);

    @SubscribeEvent
    public static void registerAttribute(EntityAttributeCreationEvent event) {
        HashMap<Object, AttributeSupplier.Builder> map = new HashMap<Object, AttributeSupplier.Builder>();
        map.put(skullFrost, SkullFrost.registerAttributes());
        map.put(blazeTempest, BlazeTempest.registerAttributes());
        map.put(archSpider, ArchSpider.registerAttributes());
        map.put(electricCube, ElectricCube.registerAttributes());
        map.put(creeperCalamity, CreeperCalamity.registerAttributes());
        map.put(enderMage, EnderMage.registerAttributes());
        map.put(skullFlame, SkullFlame.registerAttributes());
        map.put(dwarfZombie, DwarfZombie.registerAttributes());
        map.put(windWitch, WindWitch.registerAttributes());
        map.put(skullFrostRoyalGuard, SkullFrostRoyalGuard.registerAttributes());
        map.put(skullFlameArcher, SkullFlameArcher.registerAttributes());
        map.put(blazeTempestTornado, BlazeTempestTornado.registerAttributes());
        map.put(enderShadow, EnderShadow.registerAttributes());
        map.put(enderShadowMirage, EnderShadowMirage.registerAttributes());
        map.put(dwarfZombieMaster, DwarfZombieMaster.registerAttributes());
        map.put(witchCrystal, WitchCrystal.registerAttributes());
        map.put(cherryPlant, CherryPlant.registerAttributes());
        map.put(gemStone, GemStone.registerAttributes());
        map.put(witchCat, WitchCat.registerAttributes());
        map.put(witchWolf, WitchWolf.registerAttributes());
        map.put(witchAllay, WitchAllay.registerAttributes());
        map.put(witchGolem, WitchGolem.registerAttributes());
        map.put(witchFox, WitchFox.registerAttributes());
        map.put(witchMaster, WitchMaster.registerAttributes());
        map.put(witchWindine, WitchWindine.registerAttributes());
        map.put(witchIfrit, WitchIfrit.registerAttributes());
        map.put(witchKitt, WitchKitt.registerAttributes());
        map.put(stellaWizard, StellaWizard.registerAttributes());
        map.put(pixeVex, PixeVex.registerAttributes());
        map.put(phantomWolf, PhantomWolf.registerAttributes());
        map.put(electricGolem, ElectricGolem.registerAttributes());
        map.put(blitzWizard, BlitzWizard.registerAttributes());
        map.put(queenFrost, QueenFrost.registerAttributes());
        map.put(holyAngel, HolyAngel.registerAttributes());
        map.put(ignisKnight, IgnisKnight.registerAttributes());
        map.put(windWitchMaster, WindWitchMaster.registerAttributes());
        map.put(bullfight, BullFight.registerAttributes());
        map.put(ancientFairy, AncientFairy.registerAttributes());
        map.put(arlaune, Arlaune.registerAttributes());
        map.put(gemFrog, GemFrog.registerAttributes());
        map.put(silverLandRoad, SilverLandRoad.registerAttributes());
        map.put(whiteButler, WhiteButler.registerAttributes());
        map.put(blitzWizardMaster, BlitzWizardMaster.registerAttributes());
        map.put(stellaWizardMaster, StellaWizardMaster.registerAttributes());
        map.put(demonsBelial, DemonsBelial.registerAttributes());
        map.put(twilightHora, TwilightHora.registerAttributes());
        map.put(braveSkeleton, BraveSkeleton.registerAttributes());
        map.put(elshariaCurious, ElshariaCurious.registerAttributes());
        map.put(witchSandryon, WitchSandryon.registerAttributes());
        map.forEach((e, a) -> event.put(e, a.m_22265_()));
    }

    public static void registerSpawnSetting(List<MobSpawnSettings.SpawnerData> spawnSet) {
        EntityInit.spawnSet(spawnSet, skullFrost, 100, 2, 2);
        EntityInit.spawnSet(spawnSet, blazeTempest, 100, 2, 2);
        EntityInit.spawnSet(spawnSet, archSpider, 100, 2, 2);
        EntityInit.spawnSet(spawnSet, creeperCalamity, 100, 2, 2);
        EntityInit.spawnSet(spawnSet, electricCube, 100, 2, 2);
        EntityInit.spawnSet(spawnSet, enderMage, 100, 2, 2);
        EntityInit.spawnSet(spawnSet, windWitch, 100, 2, 2);
        EntityInit.spawnSet(spawnSet, skullFlame, 100, 2, 2);
        EntityInit.spawnSet(spawnSet, dwarfZombie, 100, 2, 2);
    }

    public static void spawnSet(List<MobSpawnSettings.SpawnerData> spawnSet, EntityType<?> eType, int weight, int min, int max) {
        spawnSet.add(new MobSpawnSettings.SpawnerData(eType, weight, min, max));
    }

    @SubscribeEvent
    public static void registerSpawn(SpawnPlacementRegisterEvent event) {
        EntityInit.register(skullFrost, ISMMob::checkMonsterSpawnRules);
        EntityInit.register(blazeTempest, ISMMob::checkMonsterSpawnRules);
        EntityInit.register(archSpider, ISMMob::checkMonsterSpawnRules);
        EntityInit.register(creeperCalamity, ISMMob::checkMonsterSpawnRules);
        EntityInit.register(electricCube, ISMMob::checkMonsterSpawnRules);
        EntityInit.register(enderMage, ISMMob::checkMonsterSpawnRules);
        EntityInit.register(windWitch, ISMMob::checkMonsterSpawnRules);
        EntityInit.register(skullFlame, ISMMob::checkMonsterSpawnRulesSM);
        EntityInit.register(dwarfZombie, ISMMob::checkMonsterSpawnRulesSM);
    }

    public static <T extends Entity> EntityType<T> getEntity(String name, EntityType.EntityFactory<T> fact, MobCategory cate, float xSize, float ySize) {
        EntityType eType = EntityInit.entityBuild(fact, cate).m_20699_(xSize, ySize).m_20702_(8).setTrackingRange(512).setUpdateInterval(1).m_20712_(name);
        entityMap.put(eType, name);
        return eType;
    }

    public static <T extends Entity> EntityType<T> getEntityFire(String name, EntityType.EntityFactory<T> fact, MobCategory cate, float xSize, float ySize) {
        EntityType eType = EntityInit.entityBuild(fact, cate).m_20719_().m_20699_(xSize, ySize).m_20702_(8).setTrackingRange(512).setUpdateInterval(1).m_20712_(name);
        entityMap.put(eType, name);
        return eType;
    }

    public static <T extends Entity> EntityType<T> getEntity(String name, EntityType.EntityFactory<T> fact) {
        return EntityInit.getEntity(name, fact, MISC, 1.0f, 1.0f);
    }

    public static <T extends Entity> EntityType<T> getEntityEgg(String name, EntityType.EntityFactory<T> fact, boolean isFire, float x, float z, int secondary) {
        EntityType.Builder build = isFire ? EntityInit.entityBuild(fact, MONSTER).m_20719_() : EntityInit.entityBuild(fact, MONSTER);
        EntityType eType = build.m_20699_(x, z).m_20702_(8).m_20712_("sweetmagic:" + name);
        entityEggMap.put(new EntityInfo(eType, 15985789, secondary), name);
        return eType;
    }

    public static <T extends Entity> EntityType<T> getEntityUniqueEgg(String name, EntityType.EntityFactory<T> fact, boolean isFire, float x, float z, int secondary) {
        EntityType.Builder build = isFire ? EntityInit.entityBuild(fact, MONSTER).m_20719_() : EntityInit.entityBuild(fact, MONSTER);
        EntityType eType = build.m_20699_(x, z).m_20702_(8).m_20712_("sweetmagic:" + name);
        entityEggMap.put(new EntityInfo(eType, 16237196, secondary), name);
        return eType;
    }

    public static <T extends Entity> EntityType<T> getEntityBossEgg(String name, EntityType.EntityFactory<T> fact, float x, float z, int secondary) {
        EntityType eType = EntityInit.entityBuild(fact, MONSTER).m_20719_().m_20699_(x, z).m_20702_(8).m_20712_("sweetmagic:" + name);
        entityEggMap.put(new EntityInfo(eType, 15250701, secondary), name);
        return eType;
    }

    public static <T extends Entity> EntityType.Builder<T> entityBuild(EntityType.EntityFactory<T> fact, MobCategory cate) {
        return EntityType.Builder.m_20704_(fact, (MobCategory)cate);
    }

    @SubscribeEvent
    public static void registerEntity(RegisterEvent event) {
        event.register(ForgeRegistries.Keys.ENTITY_TYPES, (T h) -> {
            entityMap.forEach((key, val) -> h.register(SweetMagicCore.getSRC(val), key));
            entityEggMap.forEach((key, val) -> h.register(SweetMagicCore.getSRC(val), key.eType()));
        });
        event.register(ForgeRegistries.Keys.ITEMS, (T h) -> {
            for (Map.Entry<EntityInfo, String> map : entityEggMap.entrySet()) {
                EntityInfo info = map.getKey();
                ForgeSpawnEggItem item = new ForgeSpawnEggItem(() -> info.eType(), info.primary(), info.secondary(), new Item.Properties());
                h.register(SweetMagicCore.getSRC(map.getValue() + "_spawn_egg"), (Object)item);
                eggList.add((Item)item);
            }
        });
    }

    public static <T extends Mob> void register(EntityType<T> eType, SpawnPlacements.SpawnPredicate<T> spawnRule) {
        SpawnPlacements.m_21754_(eType, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, spawnRule);
    }

    public record EntityInfo(EntityType<?> eType, int primary, int secondary) {
    }
}

