/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import sweetmagic.worldgen.structure.SMStructure;

public class StructureInit {
    public static final DeferredRegister<StructureType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.f_256938_, (String)"sweetmagic");
    public static RegistryObject<StructureType<SMStructure>> SM_JIGSAW_STRUCTURE = REGISTRY.register("sm_jigsaw", () -> () -> SMStructure.CODEC);
    public static int count = 0;
    public static Map<Integer, StructureInfo> strucMap = new LinkedHashMap<Integer, StructureInfo>();

    public static void init() {
        StructureInit.register(1, false, "tomb");
        StructureInit.register(2, false, "witch_house");
        StructureInit.register(2, false, "well");
        StructureInit.register(3, false, "witch_tower");
        StructureInit.register(3, false, "town_tower");
        StructureInit.register(3, false, "labyrinth");
        StructureInit.register(3, false, "desert_mine");
        StructureInit.register(2, false, "ruins_site");
        StructureInit.register(2, false, "ruins_site_light");
        StructureInit.register(3, false, "ruins_site_fire");
        StructureInit.register(3, false, "ruins_site_wind");
        StructureInit.register(3, true, "arena");
        StructureInit.register(3, true, "witch_large_house");
        StructureInit.register(3, true, "well_old");
        StructureInit.register(4, true, "pyramid");
        StructureInit.register(4, true, "white_silver_house");
        StructureInit.register(4, true, "broken_ruins_site_ice");
        StructureInit.register(4, true, "broken_ruins_site_light");
        StructureInit.register(5, true, "broken_ruins_site_fire");
        StructureInit.register(5, true, "castle");
        StructureInit.register(6, true, "broken_ruins_site_wind");
        StructureInit.register(6, true, "wizard_house");
        StructureInit.register(6, true, "wizard_fortress");
        StructureInit.register(7, true, "large_labyrinth");
    }

    public static void register(int level, boolean isSMDim, String name) {
        strucMap.put(count, new StructureInfo(level, isSMDim, name));
        ++count;
    }

    public record StructureInfo(int level, boolean isSMDim, String name) {
        public String getDim() {
            return this.isSMDim ? "sweetmagic" : "overworld";
        }
    }
}

