/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.crop;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.PlantType;
import sweetmagic.api.iblock.ISMCraftBlock;
import sweetmagic.api.iblock.ISMCrop;
import sweetmagic.api.util.ISMTip;
import sweetmagic.init.BlockInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.SoundInit;
import sweetmagic.init.TabInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.base.BaseSMBlock;
import sweetmagic.init.block.magic.PedalCreate;
import sweetmagic.init.item.magic.MFTime;
import sweetmagic.init.item.magic.MFWeather;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileAlstroemeria;
import sweetmagic.recipe.RecipeHelper;
import sweetmagic.recipe.alstrameria.AlstroemeriaRecipe;
import sweetmagic.recipe.base.AbstractRecipe;
import sweetmagic.util.SMUtil;

public class Alstroemeria
extends BushBlock
implements ISMCrop,
EntityBlock,
ISMCraftBlock,
ISMTip {
    private final String name;
    private static final VoxelShape[] CROP_VEXE = new VoxelShape[]{Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)9.6, (double)14.0)};

    public Alstroemeria(String name) {
        super(BaseSMBlock.setProSol(SoundType.f_56740_, 0.0f, 8192.0f).m_60910_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)this.getSMMaxAge(), (Comparable)Integer.valueOf(0)));
        BlockInit.BlockInfo.create((Block)this, TabInit.smMagicTab, name);
        this.name = name;
    }

    @Override
    public int getMaxBlockState() {
        return 1;
    }

    @Override
    public IntegerProperty getSMMaxAge() {
        return ISMCrop.AGE1;
    }

    @Override
    public void setGlowChance(int chance) {
    }

    @Override
    public int getGlowChange() {
        return 0;
    }

    @Override
    public int RCSetState() {
        return 1;
    }

    @Override
    public ItemLike getCrop() {
        return BlockInit.twilight_alstroemeria;
    }

    @Override
    public ItemLike getSeed() {
        return BlockInit.twilight_alstroemeria;
    }

    @Override
    public BlockState getDefault() {
        return this.m_49966_();
    }

    @Override
    public int getDropValue(RandomSource rand, int fortune) {
        return 0;
    }

    public ItemStack m_7397_(BlockGetter get, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)this);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext col) {
        return CROP_VEXE[this.getNowState(state)];
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack stack = player.m_21120_(hand);
        boolean isTimeChange = false;
        if (player.m_6144_() && stack.m_41619_()) {
            isTimeChange = this.timeSet(world, (NonNullList<ItemStack>)player.m_150109_().f_35974_, player);
        }
        if (isTimeChange) {
            this.playerSound(world, pos, SoundInit.CHANGETIME, 0.0625f, 1.0f);
        }
        if (!this.isMaxAge(state)) {
            BlockItem blockItem;
            Item item = stack.m_41720_();
            if (item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() == BlockInit.twilightlight) {
                this.setTwilightlight(world, pos, player, stack, blockItem.m_40614_());
            }
            return InteractionResult.SUCCESS;
        }
        if (!player.m_6144_() && !stack.m_41619_()) {
            this.getRecipeAlstroemeria(world, pos, player, stack, false);
        }
        return InteractionResult.m_19078_((boolean)world.m_5776_());
    }

    public boolean timeSet(Level world, NonNullList<ItemStack> pInv, Player player) {
        Boolean tmFlg = false;
        Object[] objSun = SMUtil.getStackFromPInv(pInv, ItemInit.sannyflower_petal, (byte)1);
        Object[] objMoon = SMUtil.getStackFromPInv(pInv, ItemInit.moonblossom_petal, (byte)1);
        Object[] objDM = SMUtil.getStackFromPInv(pInv, ItemInit.dm_flower, (byte)1);
        Object[] obFire = SMUtil.getStackFromPInv(pInv, ItemInit.fire_nasturtium_petal, (byte)1);
        if (objDM != null) {
            MFWeather item = (MFWeather)SMUtil.getItem(objDM[1]);
            item.changeWeather(world);
            SMUtil.getStack(objDM[1]).m_41774_(1);
            tmFlg = true;
        } else if (obFire != null) {
            MFWeather item = (MFWeather)SMUtil.getItem(obFire[1]);
            item.changeWeather(world);
            SMUtil.getStack(obFire[1]).m_41774_(1);
            tmFlg = true;
        } else if (objSun != null) {
            if (objMoon != null) {
                this.setTime(world, 10400);
                SMUtil.getStack(objSun[1]).m_41774_(1);
                SMUtil.getStack(objMoon[1]).m_41774_(1);
            } else {
                ItemStack stack = SMUtil.getStack(objSun[1]);
                this.setTime(world, this.getMFTime(stack.m_41720_()).getTime());
                stack.m_41774_(1);
            }
            tmFlg = true;
        } else if (objMoon != null) {
            ItemStack stack = SMUtil.getStack(objMoon[1]);
            this.setTime(world, this.getMFTime(stack.m_41720_()).getTime());
            stack.m_41774_(1);
            tmFlg = true;
        }
        return tmFlg;
    }

    public TimeWeatherType getTimeWeather(Level world, NonNullList<ItemStack> pInv, Player player) {
        TimeWeatherType timeWeather = null;
        Object[] objSun = SMUtil.getStackFromPInv(pInv, ItemInit.sannyflower_petal, (byte)1);
        Object[] objMoon = SMUtil.getStackFromPInv(pInv, ItemInit.moonblossom_petal, (byte)1);
        Object[] objDM = SMUtil.getStackFromPInv(pInv, ItemInit.dm_flower, (byte)1);
        Object[] obFire = SMUtil.getStackFromPInv(pInv, ItemInit.fire_nasturtium_petal, (byte)1);
        if (objDM != null) {
            return TimeWeatherType.RAIN;
        }
        if (obFire != null) {
            return TimeWeatherType.SUN;
        }
        if (objSun != null) {
            return objMoon != null ? TimeWeatherType.TWILIGHT : TimeWeatherType.DAYTIME;
        }
        if (objMoon != null) {
            return TimeWeatherType.NIGHT;
        }
        return timeWeather;
    }

    public void setTime(Level world, int time) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel sever = (ServerLevel)world;
        int dayTime = 24000;
        long day = sever.m_46468_() / (long)dayTime + 1L;
        sever.m_8615_((long)time + day * (long)dayTime);
    }

    public MFTime getMFTime(Item item) {
        return (MFTime)item;
    }

    public void setTwilightlight(Level world, BlockPos pos, Player player, ItemStack stack, Block block) {
        if (!world.m_46859_(pos.m_7494_())) {
            return;
        }
        world.m_7731_(pos.m_7494_(), block.m_49966_(), 3);
        world.m_7731_(pos, (BlockState)world.m_8055_(pos).m_61124_((Property)this.getSMMaxAge(), (Comparable)Integer.valueOf(1)), 3);
        SoundType sound = this.getSoundType(block.m_49966_(), (LevelReader)world, pos.m_7494_(), (Entity)player);
        this.playerSound(world, pos.m_7494_(), sound.m_56777_(), (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.8f);
        this.bloomAlstoemeria(world, pos.m_7495_());
        if (!player.m_7500_()) {
            stack.m_41774_(1);
        }
    }

    public boolean getRecipeAlstroemeria(Level world, BlockPos pos, Player player, ItemStack stack, boolean isAllCraft) {
        List<ItemStack> stackList = RecipeHelper.getPlayerInv(player, stack);
        Optional<AlstroemeriaRecipe> recipe = AlstroemeriaRecipe.getRecipe(world, stackList);
        if (recipe.isEmpty()) {
            return true;
        }
        if (!world.m_5776_()) {
            BlockItem bItem;
            RecipeHelper.RecipeUtil recipeUtil = isAllCraft ? RecipeHelper.recipeAllCraft(stackList, recipe.get()) : RecipeHelper.recipeSingleCraft(stackList, recipe.get());
            List<ItemStack> resultList = recipeUtil.getResultList();
            ItemStack inputStack = recipeUtil.getInputList().get(0);
            Item item = inputStack.m_41720_();
            if (item instanceof BlockItem && (bItem = (BlockItem)item).m_40614_() instanceof PedalCreate) {
                CompoundTag tags = inputStack.m_41783_();
                resultList.get(0).m_41751_(tags);
            }
            resultList.forEach(s -> world.m_7967_((Entity)new ItemEntity(world, player.f_19854_, player.f_19855_, player.f_19856_, s.m_41777_())));
            this.playerSound(world, pos, SoundEvents.f_11929_, 0.5f, 1.0f / (world.m_213780_().m_188501_() * 0.4f + 1.2f) + 0.5f);
        } else {
            for (int i = 0; i < 4; ++i) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123756_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.75, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
            }
        }
        return true;
    }

    public void playerSound(Level world, BlockPos pos, SoundEvent sound, float vol, float pitch) {
        world.m_5594_(null, pos, sound, SoundSource.BLOCKS, vol, pitch);
    }

    public void bloomAlstoemeria(Level world, BlockPos pos) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel sever = (ServerLevel)world;
        float posX = (float)pos.m_123341_() + 0.5f;
        float posY = (float)pos.m_123342_() + 1.1f;
        float posZ = (float)pos.m_123343_() + 0.5f;
        RandomSource rand = world.m_213780_();
        for (int k = 0; k < 6; ++k) {
            float f1 = posX - 0.625f + rand.m_188501_() * 1.25f;
            float f2 = posY + 0.5f + rand.m_188501_() * 0.5f;
            float f3 = posZ - 0.625f + rand.m_188501_() * 1.25f;
            sever.m_8767_((ParticleOptions)ParticleInit.TWILIGHTLIGHT, (double)f1, (double)f2, (double)f3, 2, 0.0, 0.0, 0.0, (double)0.01f);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> build) {
        build.m_61104_(new Property[]{this.getSMMaxAge()});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileAlstroemeria(pos, state);
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createMailBoxTicker(Level world, BlockEntityType<T> tileType, BlockEntityType<? extends TileAbstractSM> grill) {
        return Alstroemeria.createTickerHelper(tileType, grill, world.m_5776_() ? TileAbstractSM::clientTick : TileAbstractSM::serverTick);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return Alstroemeria.createMailBoxTicker(level, type, TileInit.alst);
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> type1, BlockEntityType<E> type2, BlockEntityTicker<? super E> ticker) {
        return type2 == type1 ? ticker : null;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        return Arrays.asList(new ItemStack(this.getCrop()));
    }

    public PlantType getPlantType(BlockGetter world, BlockPos pos) {
        return PlantType.CROP;
    }

    @Override
    public boolean notNullRecipe(Level world, List<ItemStack> stackList) {
        return !AlstroemeriaRecipe.getRecipe(world, stackList).isEmpty();
    }

    @Override
    public AbstractRecipe getRecipe(Level world, List<ItemStack> stackList) {
        return AlstroemeriaRecipe.getRecipe(world, stackList).get();
    }

    @Override
    public boolean canShiftCraft() {
        return true;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter get, List<Component> toolTip, TooltipFlag flag) {
        toolTip.add((Component)this.getText(this.name + "_open").m_130940_(GOLD));
        toolTip.add((Component)this.getText(this.name).m_130940_(GREEN));
    }

    public static enum TimeWeatherType {
        SUN,
        RAIN,
        DAYTIME,
        TWILIGHT,
        NIGHT;

    }
}

