/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.crop;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import sweetmagic.init.BlockInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.block.crop.SweetCrops_STAGE4;
import sweetmagic.init.block.sm.PottingSoil;

public class SweetCrops_DoublePlant
extends SweetCrops_STAGE4 {
    private static final VoxelShape[] CROP_VEXE = new VoxelShape[]{Block.m_49796_((double)1.6, (double)0.0, (double)1.6, (double)14.4, (double)4.0, (double)14.4), Block.m_49796_((double)1.6, (double)0.0, (double)1.6, (double)14.4, (double)8.0, (double)14.4), Block.m_49796_((double)1.6, (double)0.0, (double)1.6, (double)14.4, (double)16.0, (double)14.4), Block.m_49796_((double)1.6, (double)0.0, (double)1.6, (double)14.4, (double)16.0, (double)14.4), Block.m_49796_((double)1.6, (double)0.0, (double)1.6, (double)14.4, (double)16.0, (double)14.4)};

    public SweetCrops_DoublePlant(String name, int data, int chance) {
        super(name, data, chance, true);
    }

    @Override
    public ItemLike getCrop() {
        return switch (this.data) {
            case 1 -> ItemInit.eggplant;
            case 2 -> ItemInit.tomato_seed;
            default -> ItemInit.corn;
        };
    }

    @Override
    public ItemLike getSeed() {
        return switch (this.data) {
            case 1 -> ItemInit.eggplant_seed;
            case 2 -> ItemInit.tomato_seed;
            default -> ItemInit.corn_seed;
        };
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext con) {
        return CROP_VEXE[this.getNowState(state)];
    }

    @Override
    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        if (!this.isMaxAge(state) && ForgeHooks.onCropsGrowPre((Level)world, (BlockPos)pos, (BlockState)state, (boolean)this.isGlowChange(rand))) {
            int nowAge = this.getNowState(state);
            BlockState glowState = (BlockState)state.m_61124_((Property)this.getSMMaxAge(), (Comparable)Integer.valueOf(nowAge + 1));
            world.m_7731_(pos, glowState, 2);
            world.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)glowState));
            ForgeHooks.onCropsGrowPost((Level)world, (BlockPos)pos, (BlockState)state);
            if (nowAge + 1 >= 2 && world.m_46859_(pos.m_7494_()) && this.checkPlace(world.m_8055_(pos.m_7495_()), (BlockGetter)world, pos.m_7495_())) {
                world.m_7731_(pos.m_7494_(), (BlockState)this.m_49966_().m_61124_((Property)this.getSMMaxAge(), (Comparable)Integer.valueOf(1)), 2);
            }
        }
    }

    @Override
    public void growCrops(Level world, BlockPos pos, BlockState state) {
        int age = Math.min(this.getNowState(state) + this.getBonemealAgeIncrease(world), this.getMaxBlockState());
        world.m_7731_(pos, this.getStateForAge(age), 2);
        if (age >= 2 && world.m_46859_(pos.m_7494_()) && this.checkPlace(world.m_8055_(pos.m_7495_()), (BlockGetter)world, pos.m_7495_())) {
            world.m_7731_(pos.m_7494_(), (BlockState)this.m_49966_().m_61124_((Property)this.getSMMaxAge(), (Comparable)Integer.valueOf(1)), 2);
        }
    }

    @Override
    public void onRicghtClick(Level world, Player player, BlockState state, BlockPos pos, ItemStack stack) {
        this.dropItem(world, state, pos, player, stack);
        BlockPos targetPot = this.isFarm(world.m_8055_(pos.m_7495_())) ? pos.m_7494_() : pos.m_7495_();
        BlockState targetState = world.m_8055_(targetPot);
        Block block = targetState.m_60734_();
        if (block instanceof SweetCrops_DoublePlant) {
            SweetCrops_DoublePlant crop = (SweetCrops_DoublePlant)block;
            this.dropItem(world, targetState, targetPot, player, stack);
        }
    }

    public void dropItem(Level world, BlockState state, BlockPos pos, Player player, ItemStack stack) {
        RandomSource rand = world.m_213780_();
        ItemEntity drop = this.getDropItem(world, player, stack, this.getCrop(), this.getDropValue(rand, 0));
        world.m_7967_((Entity)drop);
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)this.getSMMaxAge(), (Comparable)Integer.valueOf(this.RCSetState())), 2);
        this.playCropSound(world, rand, pos);
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos underPos1 = pos.m_7495_();
        BlockState underState1 = world.m_8055_(underPos1);
        BlockPos underPos2 = pos.m_6625_(2);
        BlockState underState2 = world.m_8055_(underPos2);
        return this.m_6266_(world.m_8055_(underPos1), (BlockGetter)world, underPos1) || world.m_46859_(pos.m_7494_()) && underState1.m_60734_() == this && this.m_6266_(underState2, (BlockGetter)world, underPos2);
    }

    @Override
    public boolean checkPlace(BlockState state, BlockGetter get, BlockPos pos) {
        return super.checkPlace(state, get, pos) || state.m_60734_() == this && super.checkPlace(state, get, pos.m_7495_()) && (Integer)state.m_61143_((Property)this.getSMMaxAge()) >= 2;
    }

    public boolean isFarm(BlockState state) {
        return state.m_60713_(Blocks.f_50093_) || state.m_204336_(BlockTags.f_144274_) || state.m_60734_() instanceof PottingSoil || state.m_60713_(BlockInit.aether_planter);
    }
}

