/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.magic;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.base.BaseMFBlock;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileAetherHopper;
import sweetmagic.init.tile.sm.TileAetherHopperAdvanced;

public class AetherHopper
extends BaseMFBlock {
    private final int data;
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;

    public AetherHopper(String name, int data) {
        super(name, false);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.DOWN));
        this.data = data;
    }

    @Override
    public boolean actionBlock(Level world, BlockPos pos, Player player, ItemStack stack) {
        if (world.m_5776_()) {
            return false;
        }
        this.openGUI(world, pos, player, this.getTile(world, pos));
        return true;
    }

    @Override
    public int getTier() {
        return this.data + 1;
    }

    @Override
    public int getMaxMF() {
        return switch (this.data) {
            case 1 -> 50000;
            default -> 20000;
        };
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return switch (this.data) {
            case 1 -> new TileAetherHopperAdvanced(pos, state);
            default -> new TileAetherHopper(pos, state);
        };
    }

    @Override
    public BlockEntityType<? extends TileAbstractSM> getTileType() {
        return switch (this.data) {
            case 1 -> TileInit.aetherHopperAdvanced;
            default -> TileInit.aetherHopper;
        };
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return this.createMailBoxTicker(world, type, this.getTileType());
    }

    @Override
    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> build) {
        build.m_61104_(new Property[]{FACING});
    }

    @Override
    @NotNull
    public BlockState m_5573_(BlockPlaceContext con) {
        return con.m_43723_() != null ? (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)con.m_43719_().m_122424_()) : this.m_49966_();
    }

    @Override
    public boolean keepTileInfo() {
        return true;
    }

    @Override
    public ItemStack inheritingNBT(ItemStack oldStack, ItemStack newStack) {
        if (oldStack.m_41784_().m_128441_("BlockEntityTag")) {
            CompoundTag tags = oldStack.m_41737_("BlockEntityTag");
            int oldSlotSize = 24;
            ItemStackHandler oldInputInv = new ItemStackHandler(oldSlotSize);
            oldInputInv.deserializeNBT(tags.m_128469_("inputInv"));
            int newSlotSize = oldSlotSize * 2;
            ItemStackHandler newInputInv = new ItemStackHandler(newSlotSize);
            for (int i = 0; i < oldSlotSize; ++i) {
                newInputInv.setStackInSlot(i, oldInputInv.getStackInSlot(i));
            }
            tags.m_128473_("inputInv");
            tags.m_128365_("inputInv", (Tag)newInputInv.serializeNBT());
            CompoundTag newTags = new CompoundTag();
            newTags.m_128365_("BlockEntityTag", (Tag)tags);
            newTags.m_128405_("mf", oldStack.m_41783_().m_128451_("mf"));
            newStack.m_41751_(newTags);
        }
        return newStack;
    }

    @Override
    @Deprecated
    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Override
    @Deprecated
    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Override
    public void addTip(List<Component> toolTip, ItemStack stack, CompoundTag tags) {
        toolTip.add((Component)this.getText("aether_hopper").m_130940_(GREEN));
        toolTip.add((Component)this.getText("aether_hopper_send").m_130940_(GREEN));
    }

    @Override
    public boolean isRSStop() {
        return true;
    }
}

