/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.magic;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sweetmagic.api.iblock.ISMNeedItem;
import sweetmagic.api.iitem.IWand;
import sweetmagic.init.BlockInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.TabInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.base.BaseFaceBlock;
import sweetmagic.init.tile.sm.TileAbstractMagicianLectern;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileMagicianLecternFire;
import sweetmagic.init.tile.sm.TileMagicianLecternFrost;
import sweetmagic.init.tile.sm.TileMagicianLecternLight;
import sweetmagic.init.tile.sm.TileMagicianLecternWind;
import sweetmagic.recipe.RecipeHelper;

public class MagicianLectern
extends BaseFaceBlock
implements EntityBlock,
ISMNeedItem {
    private final int data;
    private static final VoxelShape AABB = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)12.5, (double)13.0);

    public MagicianLectern(String name, int data) {
        super(name, MagicianLectern.setPro(SoundType.f_56736_, 2.0f, 8192.0f));
        this.m_49959_(this.setState());
        BlockInit.BlockInfo.create(this, TabInit.smTab, name);
        this.data = data;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext con) {
        return AABB;
    }

    @Override
    public boolean canRightClick(Player player, ItemStack stack) {
        return true;
    }

    @Override
    public boolean actionBlock(Level world, BlockPos pos, Player player, ItemStack stack) {
        if (!this.hasNeedItem(player, stack)) {
            return false;
        }
        TileAbstractMagicianLectern tile = (TileAbstractMagicianLectern)this.getTile(world, pos);
        if (tile.summonType.is(TileAbstractMagicianLectern.SummonType.CHARGE) || tile.summonType.is(TileAbstractMagicianLectern.SummonType.SUMMON)) {
            return false;
        }
        if (world.m_5776_()) {
            return true;
        }
        if (world.m_46791_() == Difficulty.PEACEFUL) {
            if (!world.m_5776_()) {
                player.m_213846_((Component)this.getText("magician_lectern_peaceful").m_130940_(RED));
            }
            return true;
        }
        List<ItemStack> stackList = RecipeHelper.getPlayerInv(player, stack);
        boolean hasHardItem = this.isHard(player);
        List<ItemStack> wandList = stackList.stream().filter(s -> {
            IWand wand;
            Item patt3183$temp = s.m_41720_();
            return patt3183$temp instanceof IWand && this.checkWand(hasHardItem, (ItemStack)s, wand = (IWand)patt3183$temp);
        }).toList();
        if (wandList.isEmpty()) {
            if (!world.m_5776_()) {
                player.m_213846_((Component)this.getText(hasHardItem ? "magician_lectern_wand_hard" : "magician_lectern_wand").m_130940_(RED));
            }
            return true;
        }
        tile.summonType = TileAbstractMagicianLectern.SummonType.CHARGE;
        tile.stack = stack.m_41777_();
        tile.wave = 1;
        tile.tileTime = 0;
        tile.chargeSummonSize = 0.0f;
        tile.dethMobCount = 0;
        tile.summonMaxCount = 24;
        tile.summonCount = 0;
        tile.waitTime = 0;
        tile.maxWaitTime = 0;
        tile.chageTime = 0;
        tile.isHard = hasHardItem;
        if (this.data >= 2) {
            tile.wave = 4;
        }
        tile.setMobSize(world, pos);
        tile.sendPKT();
        ArrayList<ItemStack> needList = new ArrayList<ItemStack>(this.getNeedItemList());
        block0: for (ItemStack needStack : needList) {
            for (ItemStack pStack : stackList) {
                if (!needStack.m_150930_(pStack.m_41720_()) || pStack.m_41613_() < needStack.m_41613_()) continue;
                pStack.m_41774_(needStack.m_41613_());
                continue block0;
            }
        }
        return true;
    }

    public boolean checkWand(boolean hasHardItem, ItemStack stack, IWand wand) {
        if (hasHardItem) {
            return wand.getWandTier() >= 3 && (wand.getWandLevel(stack) >= 12 || wand.isCreativeWand());
        }
        return wand.getWandTier() >= 2 && (wand.getWandLevel(stack) >= 8 || wand.isCreativeWand());
    }

    @Override
    @Deprecated
    public void m_6810_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        TileAbstractMagicianLectern tile = (TileAbstractMagicianLectern)this.getTile(world, pos);
        tile.removeAllPlayerBossBar();
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return switch (this.data) {
            case 1 -> new TileMagicianLecternLight(pos, state);
            case 2 -> new TileMagicianLecternFire(pos, state);
            case 3 -> new TileMagicianLecternWind(pos, state);
            default -> new TileMagicianLecternFrost(pos, state);
        };
    }

    @Override
    public BlockEntityType<? extends TileAbstractSM> getTileType() {
        return switch (this.data) {
            case 1 -> TileInit.magicianLecternLight;
            case 2 -> TileInit.magicianLecternFire;
            case 3 -> TileInit.magicianLecternWind;
            default -> TileInit.magicianLecternFrost;
        };
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return this.createMailBoxTicker(world, type, this.getTileType());
    }

    @Override
    public void addBlockTip(List<Component> toolTip) {
        ItemStack magic = new ItemStack((ItemLike)this.getNeedHardItem());
        toolTip.add((Component)this.getText("magician_lectern").m_130940_(GREEN));
        toolTip.add((Component)this.getText("magician_lectern_hard").m_130940_(GREEN));
        toolTip.add((Component)this.getTipArray(new Object[]{this.getText("magician_lectern_item"), magic.m_41786_()}).m_130940_(GREEN));
    }

    @Override
    public List<ItemStack> getNeedItemList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        stackList.add(new ItemStack((ItemLike)ItemInit.mf_bottle, 3));
        stackList.add(new ItemStack((ItemLike)ItemInit.divine_crystal, 1));
        stackList.add(new ItemStack((ItemLike)ItemInit.acce_bag));
        return stackList;
    }

    @Override
    public List<ItemStack> getNeedHardItemList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        stackList.add(new ItemStack((ItemLike)this.getNeedHardItem()));
        stackList.add(new ItemStack((ItemLike)ItemInit.mf_bottle, 5));
        stackList.add(new ItemStack((ItemLike)ItemInit.divine_crystal, 2));
        stackList.add(new ItemStack((ItemLike)ItemInit.acce_bag, 2));
        return stackList;
    }

    @Override
    public Item getNeedHardItem() {
        return switch (this.data) {
            case 1 -> ItemInit.magic_holybuster;
            case 2 -> ItemInit.magic_ignisblast;
            case 3 -> ItemInit.magic_windstorm;
            default -> ItemInit.magic_frostlaser;
        };
    }
}

