/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.magic;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.base.BaseMFBlock;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileAccessoryTable;
import sweetmagic.init.tile.sm.TileAetherPlanter;
import sweetmagic.init.tile.sm.TileAetherRepair;
import sweetmagic.init.tile.sm.TileAetherReverse;
import sweetmagic.init.tile.sm.TileAlstroemeriaAquarium;
import sweetmagic.init.tile.sm.TileClerodendrumLamp;
import sweetmagic.init.tile.sm.TileEnchantEduce;
import sweetmagic.init.tile.sm.TileMFBottler;
import sweetmagic.init.tile.sm.TileMFBottlerAdcanced;
import sweetmagic.init.tile.sm.TileMFGenerater;
import sweetmagic.init.tile.sm.TileMFMinerAdvanced;
import sweetmagic.init.tile.sm.TileMFSpawner;
import sweetmagic.init.tile.sm.TileMFWoodCutter;
import sweetmagic.init.tile.sm.TileMagiaAccelerator;
import sweetmagic.init.tile.sm.TileMagiaDrawer;
import sweetmagic.init.tile.sm.TileMagiaRewrite;
import sweetmagic.init.tile.sm.TileMagiaTable;
import sweetmagic.init.tile.sm.TileReplicaAltar;
import sweetmagic.init.tile.sm.TileWandReconstruct;

public class ToolRepair
extends BaseMFBlock {
    private final int data;
    private static final VoxelShape TOOL = Block.m_49796_((double)3.2, (double)0.0, (double)3.2, (double)12.8, (double)10.4, (double)12.8);
    private static final VoxelShape AABB = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    private static final VoxelShape ACCEL = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape ACCESSORY = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.7, (double)13.0);
    private static final VoxelShape AQUARIUM = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape CLERO = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0);

    public ToolRepair(String name, int data) {
        super(name);
        this.data = data;
    }

    @Override
    public int getMaxMF() {
        return switch (this.data) {
            case 2 -> 1000000;
            case 5 -> 200000;
            case 7 -> 50000;
            case 8 -> 20000;
            case 10 -> 500000;
            case 11 -> 2000000;
            case 14 -> 10000;
            case 15 -> 200000;
            case 16 -> 20000;
            case 17 -> 1000000;
            case 18 -> 200000;
            default -> 100000;
        };
    }

    @Override
    public int getTier() {
        return switch (this.data) {
            case 0 -> 2;
            case 2 -> 2;
            case 5 -> 2;
            case 6 -> 2;
            case 7 -> 2;
            case 8 -> 2;
            case 9 -> 2;
            case 10 -> 2;
            case 11 -> 3;
            case 12 -> 2;
            case 13 -> 2;
            case 15 -> 3;
            case 16 -> 2;
            case 17 -> 2;
            case 18 -> 2;
            default -> 1;
        };
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return this.data == 2 ? RenderShape.ENTITYBLOCK_ANIMATED : super.m_7514_(state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext col) {
        return switch (this.data) {
            case 0 -> TOOL;
            case 2 -> AABB;
            case 5 -> ACCEL;
            case 6 -> ACCESSORY;
            case 7 -> AQUARIUM;
            case 16 -> CLERO;
            default -> Shapes.m_83144_();
        };
    }

    @Override
    public boolean canRightClick(Level world, BlockPos pos, Player player, ItemStack stack) {
        BlockItem bItem;
        Item item;
        return !(this.data == 8 && (stack.m_41720_() instanceof ItemNameBlockItem || stack.m_150930_(Items.f_41911_) || (item = stack.m_41720_()) instanceof BlockItem && (bItem = (BlockItem)item).m_40614_() instanceof MushroomBlock && world.m_46859_(pos.m_7494_())));
    }

    @Override
    public boolean actionBlock(Level world, BlockPos pos, Player player, ItemStack stack) {
        if (world.m_5776_()) {
            return true;
        }
        this.openGUI(world, pos, player, this.getTile(world, pos));
        if (this.data == 4) {
            this.playerSound(world, pos, SoundEvents.f_12311_, 0.5f, world.m_213780_().m_188501_() * 0.1f + 0.9f);
        }
        return true;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return switch (this.data) {
            case 1 -> new TileEnchantEduce(pos, state);
            case 2 -> new TileMagiaRewrite(pos, state);
            case 3 -> new TileAetherReverse(pos, state);
            case 4 -> new TileMagiaDrawer(pos, state);
            case 5 -> new TileMagiaAccelerator(pos, state);
            case 6 -> new TileAccessoryTable(pos, state);
            case 7 -> new TileAlstroemeriaAquarium(pos, state);
            case 8 -> new TileAetherPlanter(pos, state);
            case 9 -> new TileMFMinerAdvanced(pos, state);
            case 10 -> new TileMFBottler(pos, state);
            case 11 -> new TileMFBottlerAdcanced(pos, state);
            case 12 -> new TileMFGenerater(pos, state);
            case 13 -> new TileMagiaTable(pos, state);
            case 14 -> new TileMFWoodCutter(pos, state);
            case 15 -> new TileMFSpawner(pos, state);
            case 16 -> new TileClerodendrumLamp(pos, state);
            case 17 -> new TileWandReconstruct(pos, state);
            case 18 -> new TileReplicaAltar(pos, state);
            default -> new TileAetherRepair(pos, state);
        };
    }

    @Override
    public BlockEntityType<? extends TileAbstractSM> getTileType() {
        return switch (this.data) {
            case 1 -> TileInit.enchantEduce;
            case 2 -> TileInit.magiaWrite;
            case 3 -> TileInit.aetherReverse;
            case 4 -> TileInit.magiarDrawer;
            case 5 -> TileInit.magiaAccelerator;
            case 6 -> TileInit.accessoryProcessing;
            case 7 -> TileInit.alstroemeriaAquarium;
            case 8 -> TileInit.aetherPlanter;
            case 9 -> TileInit.mfMinerAdvanced;
            case 10 -> TileInit.mfBottler;
            case 11 -> TileInit.mfBottlerAdvance;
            case 12 -> TileInit.mfGenerater;
            case 13 -> TileInit.magiaTable;
            case 14 -> TileInit.woodCutter;
            case 15 -> TileInit.mfSpawner;
            case 16 -> TileInit.clerodendrumLamp;
            case 17 -> TileInit.wandReconstruct;
            case 18 -> TileInit.replicaAltar;
            default -> TileInit.aetherRepair;
        };
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return this.createMailBoxTicker(world, type, this.getTileType());
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction face, IPlantable plant) {
        if (this.data != 8) {
            return super.canSustainPlant(state, world, pos, face, plant);
        }
        PlantType plantType = plant.getPlantType(world, pos.m_121945_(face));
        return plantType != PlantType.NETHER && plantType != PlantType.WATER;
    }

    @Override
    public boolean isRSStop() {
        return this.data == 4 || this.data == 7 || this.data == 15 || this.data == 16;
    }

    @Override
    public void addTip(List<Component> toolTip, ItemStack stack, CompoundTag tags) {
        super.addTip(toolTip, stack, tags);
        if (this.data == 7) {
            toolTip.add((Component)this.getText("hopper_send").m_130940_(GOLD));
        } else if (this.data == 12) {
            toolTip.add((Component)this.getText(this.name + "_tank").m_130940_(GOLD));
            toolTip.add((Component)this.getText(this.name + "_magma", new Object[]{Blocks.f_50450_.m_49954_().getString()}).m_130940_(GOLD));
        } else if (this.data == 17) {
            toolTip.add((Component)this.getText(this.name + "_tier5").m_130940_(GOLD));
        } else if (this.data == 18) {
            toolTip.add((Component)this.getText(this.name + "_level").m_130940_(GOLD));
        }
    }
}

