/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.sm;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import sweetmagic.api.iblock.ISMCraftBlock;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.base.BaseCookBlock;
import sweetmagic.init.tile.sm.TileBottle;
import sweetmagic.recipe.RecipeHelper;
import sweetmagic.recipe.base.AbstractRecipe;
import sweetmagic.recipe.bottle.BottleRecipe;

public class Bottle
extends BaseCookBlock
implements ISMCraftBlock {
    private static final VoxelShape AABB = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0);

    public Bottle(String name) {
        super(name);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext col) {
        return AABB;
    }

    @Override
    public boolean actionBlock(Level world, BlockPos pos, Player player, ItemStack stack) {
        if (world.m_5776_()) {
            return true;
        }
        BlockState state = world.m_8055_(pos);
        int cookState = this.getState(state);
        if (cookState == 0) {
            this.recipeCraft(world, pos, player, stack);
        } else if (cookState == 2) {
            TileBottle tile = (TileBottle)this.getTile(TileBottle::new, world, pos);
            this.spawnItemList(world, player.m_20183_(), tile.resultList);
            tile.player = player;
            tile.getExpValue();
            this.setState(world, pos, 0);
            tile.clearInfo();
            tile.sendPKT();
        }
        return true;
    }

    public void recipeCraft(Level world, BlockPos pos, Player player, ItemStack stack) {
        List<ItemStack> stackList = RecipeHelper.getPlayerInv(player, stack);
        Optional<BottleRecipe> recipe = BottleRecipe.getRecipe(world, stackList);
        if (recipe.isEmpty()) {
            return;
        }
        RecipeHelper.RecipeUtil recipeUtil = RecipeHelper.recipeAllCraft(stackList, recipe.get());
        TileBottle tile = (TileBottle)this.getTile(TileBottle::new, world, pos);
        tile.craftList = recipeUtil.getInputList();
        tile.resultList = recipeUtil.getResultList();
        tile.player = player;
        tile.craftStart();
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileBottle(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return this.createMailBoxTicker(world, type, TileInit.bottle);
    }

    @Override
    public void addBlockTip(List<Component> toolTip) {
        toolTip.add((Component)this.getText(this.name).m_130940_(GREEN));
    }

    @Override
    public boolean notNullRecipe(Level world, List<ItemStack> stackList) {
        return !BottleRecipe.getRecipe(world, stackList).isEmpty();
    }

    @Override
    public AbstractRecipe getRecipe(Level world, List<ItemStack> stackList) {
        return BottleRecipe.getRecipe(world, stackList).get();
    }

    @Override
    public boolean isView() {
        return false;
    }
}

