/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.sm;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import sweetmagic.init.BlockInit;
import sweetmagic.init.TabInit;
import sweetmagic.init.block.base.BaseFaceBlock;
import sweetmagic.init.tile.sm.TileBottleRack;
import sweetmagic.init.tile.sm.TileCeilingShelf;
import sweetmagic.init.tile.sm.TileFruitCrate;
import sweetmagic.init.tile.sm.TileModenRack;
import sweetmagic.init.tile.sm.TileWallPartition;
import sweetmagic.init.tile.sm.TileWallRack;
import sweetmagic.init.tile.sm.TileWallShelf;
import sweetmagic.init.tile.sm.TileWoodenToolBox;
import sweetmagic.util.FaceAABB;

public class ModenRack
extends BaseFaceBlock
implements EntityBlock {
    public final int data;
    private static final VoxelShape[] WALL_RACK = FaceAABB.create(0.0, 15.0, 4.0, 16.0, 16.0, 16.0);
    private static final VoxelShape[] WALL_SHELF = FaceAABB.create(0.0, 0.0, 8.0, 16.0, 16.0, 16.0);
    private static final VoxelShape[] WALL_PATITION = FaceAABB.create(0.0, 0.0, 14.5, 16.0, 16.0, 16.0);
    private static final VoxelShape[] BOTTLE_RACK = FaceAABB.create(0.0, 0.0, 10.0, 16.0, 16.0, 16.0);
    private static final VoxelShape[] FRUIT_CREATE = FaceAABB.create(1.0, 0.0, -3.25, 15.0, 13.5, 15.0);
    private static final VoxelShape[] FRUIT_CREATE_BOX = FaceAABB.create(2.0, 0.0, 1.0, 14.0, 6.5, 15.0);
    private static final VoxelShape[] BOX = FaceAABB.create(0.0, 0.0, 8.0, 16.0, 16.0, 16.0);

    public ModenRack(String name, int data, boolean isIron) {
        super(name, ModenRack.setPro(isIron ? SoundType.f_56743_ : SoundType.f_56736_, 0.5f, 8192.0f));
        this.data = data;
        this.m_49959_(this.setState());
        BlockInit.BlockInfo.create(this, TabInit.smTab, name);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext con) {
        return switch (this.data) {
            case 1 -> FaceAABB.getAABB(WALL_RACK, state);
            case 2 -> FaceAABB.getAABB(WALL_SHELF, state);
            case 3 -> FaceAABB.getAABB(WALL_PATITION, state);
            case 4 -> FaceAABB.getAABB(BOTTLE_RACK, state);
            case 6 -> FaceAABB.getAABB(FRUIT_CREATE, state);
            case 7 -> FaceAABB.getAABB(FRUIT_CREATE_BOX, state);
            case 9 -> FaceAABB.getAABB(BOX, state);
            default -> Shapes.m_83144_();
        };
    }

    @Override
    public boolean canRightClick(Player player, ItemStack stack) {
        return true;
    }

    @Override
    public boolean actionBlock(Level world, BlockPos pos, Player player, ItemStack stack) {
        if (world.m_5776_()) {
            return true;
        }
        this.openGUI(world, pos, player, this.getTile(world, pos));
        return true;
    }

    @Override
    public boolean isKeepTile() {
        return true;
    }

    @Override
    public void addBlockTip(List<Component> toolTip) {
        toolTip.add((Component)this.getText("sm_chest").m_130940_(GREEN));
        if (this.data == 5) {
            toolTip.add((Component)this.getText(this.name).m_130940_(GREEN));
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return switch (this.data) {
            case 1 -> new TileWallRack(pos, state);
            case 2 -> new TileWallShelf(pos, state);
            case 3 -> new TileWallPartition(pos, state);
            case 4 -> new TileBottleRack(pos, state);
            case 5 -> new TileCeilingShelf(pos, state);
            case 6 -> new TileFruitCrate(pos, state);
            case 7 -> new TileFruitCrate(pos, state);
            case 8 -> new TileWoodenToolBox(pos, state);
            case 9 -> new TileWallRack(pos, state);
            default -> new TileModenRack(pos, state);
        };
    }

    @Override
    protected boolean isDrop() {
        return false;
    }
}

