/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.sm;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import sweetmagic.init.BlockInit;
import sweetmagic.init.TabInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.base.BaseFaceBlock;
import sweetmagic.init.tile.sm.TileNotePC;
import sweetmagic.util.FaceAABB;

public class NotePC
extends BaseFaceBlock
implements EntityBlock {
    private final Block block;
    public static final BooleanProperty CLOSE = BooleanProperty.m_61465_((String)"close");
    private static final VoxelShape[] AABB = FaceAABB.create(1.5, 0.0, 1.0, 14.5, 9.75, 15.0);
    private static final VoxelShape[] CLO = FaceAABB.create(1.5, 0.0, 1.0, 14.5, 1.25, 11.0);

    public NotePC(String name, Block block) {
        super(name, NotePC.setPro(SoundType.f_56743_, 0.5f, 8192.0f));
        this.m_49959_((BlockState)this.setState().m_61124_((Property)CLOSE, (Comparable)Boolean.valueOf(false)));
        BlockInit.BlockInfo.create(this, TabInit.smTab, name);
        this.block = block;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext con) {
        return (Boolean)state.m_61143_((Property)CLOSE) != false ? FaceAABB.getAABB(CLO, state) : FaceAABB.getAABB(AABB, state);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> build) {
        build.m_61104_(new Property[]{FACING, CLOSE});
    }

    @Override
    public boolean canRightClick(Player player, ItemStack stack) {
        return true;
    }

    @Override
    public boolean actionBlock(Level world, BlockPos pos, Player player, ItemStack stack) {
        if (world.m_5776_()) {
            return true;
        }
        BlockState state = world.m_8055_(pos);
        boolean close = (Boolean)state.m_61143_((Property)CLOSE);
        if (player.m_6144_()) {
            world.m_7731_(pos, (BlockState)state.m_61122_((Property)CLOSE), 3);
            this.playerSound(world, pos, SoundEvents.f_12412_, 0.25f, 1.15f);
        } else {
            TileNotePC tile = (TileNotePC)this.getTile(world, pos);
            if (tile.ownerUUID != null && tile.getOwner() == null && tile.ownerUUID == player.m_20148_()) {
                tile.setOwner(player);
                tile.clearInfo();
            } else if (tile.ownerUUID == null) {
                tile.setOwner(player);
                tile.clearInfo();
            }
            this.openGUI(world, pos, player, tile);
            if (close) {
                world.m_7731_(pos, (BlockState)state.m_61122_((Property)CLOSE), 3);
                this.playerSound(world, pos, SoundEvents.f_12412_, 0.25f, 1.15f);
            }
        }
        return true;
    }

    @Override
    public boolean isKeepTile() {
        return true;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileNotePC(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return this.createMailBoxTicker(world, type, TileInit.notePC);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(world, pos, state, placer, stack);
        TileNotePC tile = (TileNotePC)this.getTile(world, pos);
        if (!world.m_5776_() && placer instanceof Player) {
            Player player = (Player)placer;
            tile.setOwner(player);
            tile.clearInfo();
        }
    }

    @Override
    public void addBlockTip(List<Component> toolTip) {
        boolean isShift = Screen.m_96638_();
        int size = isShift ? 7 : 1;
        for (int i = 0; i < size; ++i) {
            toolTip.add((Component)this.getText("note_pc" + i).m_130940_(i > 1 ? GOLD : GREEN));
        }
        if (!isShift) {
            this.getShiftTip(toolTip);
            if (this.block == null) {
                return;
            }
            toolTip.add((Component)this.getText("originatorblock", new Object[]{this.block.m_49954_().getString()}).m_130940_(GOLD));
            toolTip.add((Component)this.getText("note_pc_sell").m_130940_(RED));
        }
    }

    @Override
    protected boolean isDrop() {
        return false;
    }
}

