/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.sm;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import sweetmagic.api.iblock.ISMCraftBlock;
import sweetmagic.init.TabInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.base.BaseCookBlock;
import sweetmagic.init.tile.sm.TileOven;
import sweetmagic.recipe.RecipeHelper;
import sweetmagic.recipe.base.AbstractRecipe;
import sweetmagic.recipe.oven.OvenRecipe;
import sweetmagic.util.FaceAABB;

public class Oven
extends BaseCookBlock
implements ISMCraftBlock {
    private final int data;
    private static final VoxelShape[] AABB = FaceAABB.create(1.0, 0.0, 3.0, 15.0, 12.5, 14.0);

    public Oven(String name) {
        super(name);
        this.data = 0;
    }

    public Oven(String name, int data) {
        super(name, TabInit.smTab);
        this.data = data;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext con) {
        return switch (this.data) {
            case 2 -> FaceAABB.getAABB(AABB, state);
            default -> Shapes.m_83144_();
        };
    }

    @Override
    public boolean actionBlock(Level world, BlockPos pos, Player player, ItemStack stack) {
        if (world.m_5776_()) {
            return true;
        }
        BlockState state = world.m_8055_(pos);
        int cookState = this.getState(state);
        if (cookState == 0) {
            this.recipeCraft(world, pos, player, stack);
        } else if (cookState == 2) {
            TileOven tile = (TileOven)world.m_7702_(pos);
            this.spawnXp(player, tile.resultList, tile.hasFork);
            this.spawnItemList(world, player.m_20183_(), tile.resultList);
            tile.player = player;
            tile.getExpValue();
            this.setState(world, pos, 0);
            tile.clearInfo();
            tile.sendPKT();
        }
        return true;
    }

    public void recipeCraft(Level world, BlockPos pos, Player player, ItemStack stack) {
        List<ItemStack> stackList = RecipeHelper.getPlayerInv(player, stack);
        Optional<OvenRecipe> recipe = OvenRecipe.getRecipe(world, stackList);
        if (recipe.isEmpty()) {
            return;
        }
        RecipeHelper.RecipeUtil recipeUtil = RecipeHelper.recipeAllCraft(stackList, recipe.get());
        TileOven tile = (TileOven)world.m_7702_(pos);
        tile.craftList = recipeUtil.getInputList();
        tile.resultList = recipeUtil.getResultList();
        tile.hasFork = this.hasFork(player);
        tile.amount = recipeUtil.getCount();
        tile.player = player;
        tile.craftStart();
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileOven(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return this.createMailBoxTicker(world, type, TileInit.oven);
    }

    @Override
    public boolean notNullRecipe(Level world, List<ItemStack> stackList) {
        return !OvenRecipe.getRecipe(world, stackList).isEmpty();
    }

    @Override
    public AbstractRecipe getRecipe(Level world, List<ItemStack> stackList) {
        return OvenRecipe.getRecipe(world, stackList).get();
    }

    @Override
    public void addBlockTip(List<Component> toolTip) {
        toolTip.add((Component)this.getText("cook_block").m_130940_(GREEN));
        if (this.data != 0) {
            toolTip.add((Component)this.getText("oven_use").m_130940_(GOLD));
        }
    }
}

