/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.sm;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.BlockInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.block.base.BaseModelBlock;
import sweetmagic.util.PlayerHelper;
import sweetmagic.util.SMDamage;

public class PoisonBlock
extends BaseModelBlock {
    private static final VoxelShape AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.9, (double)16.0);
    private int tickTime = 0;

    public PoisonBlock(String name) {
        super(name, PoisonBlock.setPro(SoundType.f_56743_, 1.0f, 8192.0f));
        BlockInit.BlockInfo.create(this, null, name);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext con) {
        return AABB;
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        LivingEntity living;
        block10: {
            block9: {
                if (world.m_5776_() || !(entity instanceof LivingEntity)) break block9;
                living = (LivingEntity)entity;
                if (!(entity instanceof ISMMob)) break block10;
            }
            return;
        }
        ++this.tickTime;
        if (!living.m_21023_(PotionInit.deadly_poison)) {
            if (living.m_21023_(PotionInit.reflash_effect) && this.tickTime % 20 == 0) {
                living.m_6469_(SMDamage.getDamage(SMDamage.poisonDamage, world), 0.75f);
            } else {
                PlayerHelper.setPotion(living, PotionInit.deadly_poison, 0, 110);
            }
        } else if (this.tickTime % 30 == 0) {
            PlayerHelper.setPotion(living, PotionInit.deadly_poison, 0, 110);
        }
        if (this.tickTime % 60 == 0) {
            this.tickTime = 0;
        }
    }

    @Override
    public void addBlockTip(List<Component> toolTip) {
        toolTip.add((Component)this.getText("dungen_only").m_130940_(GREEN));
        toolTip.add((Component)this.getText(this.name + "0", new Object[]{this.getEffectTip("deadly_poison")}).m_130940_(GREEN));
        toolTip.add((Component)this.getText(this.name + "1", new Object[]{this.getEffectTip("reflash_effect")}).m_130940_(GREEN));
    }
}

