/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.sm;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sweetmagic.api.util.EnumConect;
import sweetmagic.init.BlockInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.block.base.BaseSMBlock;

public class SMDoor3
extends BaseSMBlock {
    private final int data;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.f_61394_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final EnumProperty<EnumConect> HALF = EnumProperty.m_61587_((String)"vertical", EnumConect.class);
    protected static final float AABB_DOOR_THICKNESS = 3.0f;
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);

    public SMDoor3(String name, int data) {
        super(name, SMDoor3.setPro(SoundType.f_56736_, 0.35f, 8192.0f));
        this.data = data;
        BlockInit.BlockInfo.create(this, null, name);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_(HINGE, (Comparable)DoorHingeSide.LEFT)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_(HALF, (Comparable)((Object)EnumConect.BOT)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext con) {
        boolean flag = (Boolean)state.m_61143_((Property)OPEN) == false;
        boolean flag1 = state.m_61143_(HINGE) == DoorHingeSide.RIGHT;
        switch ((Direction)state.m_61143_((Property)FACING)) {
            default: {
                return flag ? EAST_AABB : (flag1 ? NORTH_AABB : SOUTH_AABB);
            }
            case SOUTH: {
                return flag ? SOUTH_AABB : (flag1 ? EAST_AABB : WEST_AABB);
            }
            case WEST: {
                return flag ? WEST_AABB : (flag1 ? SOUTH_AABB : NORTH_AABB);
            }
            case NORTH: 
        }
        return flag ? NORTH_AABB : (flag1 ? WEST_AABB : EAST_AABB);
    }

    public BlockState m_7417_(BlockState state1, Direction face, BlockState state2, LevelAccessor world, BlockPos pos1, BlockPos pos2) {
        if (face.m_122434_() == Direction.Axis.Y && pos1 != pos2 && !state1.m_60795_() && !state2.m_60795_() && state1.m_60734_() == this && state2.m_60734_() == this) {
            return (BlockState)((BlockState)((BlockState)((BlockState)state1.m_61124_((Property)FACING, (Comparable)((Direction)state2.m_61143_((Property)FACING)))).m_61124_((Property)OPEN, (Comparable)((Boolean)state2.m_61143_((Property)OPEN)))).m_61124_(HINGE, (Comparable)((DoorHingeSide)state2.m_61143_(HINGE)))).m_61124_((Property)POWERED, (Comparable)((Boolean)state2.m_61143_((Property)POWERED)));
        }
        return state1;
    }

    @Override
    @Deprecated
    public void m_6810_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (state != newState && newState.m_60795_()) {
            switch ((EnumConect)((Object)state.m_61143_(HALF))) {
                case TOP: {
                    this.breakDoor(world, pos.m_6625_(1));
                    this.breakDoor(world, pos.m_6625_(2));
                    break;
                }
                case CEN: {
                    this.breakDoor(world, pos.m_6630_(1));
                    this.breakDoor(world, pos.m_6625_(1));
                    break;
                }
                case BOT: {
                    this.breakDoor(world, pos.m_6630_(1));
                    this.breakDoor(world, pos.m_6630_(2));
                }
            }
        }
    }

    public void breakDoor(Level world, BlockPos pos) {
        if (world.m_8055_(pos).m_60734_() == this) {
            world.m_46961_(pos, false);
            world.m_7471_(pos, false);
        }
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType comType) {
        return switch (comType) {
            case PathComputationType.LAND -> (Boolean)state.m_61143_((Property)OPEN);
            case PathComputationType.WATER -> false;
            case PathComputationType.AIR -> (Boolean)state.m_61143_((Property)OPEN);
            default -> false;
        };
    }

    private SoundEvent getCloseSound() {
        return BlockSetType.f_271198_.f_271502_();
    }

    private SoundEvent getOpenSound() {
        return BlockSetType.f_271198_.f_271141_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext con) {
        Level world = con.m_43725_();
        BlockPos pos = con.m_8083_();
        if (pos.m_123342_() < world.m_151558_() - 1 && world.m_8055_(pos.m_7494_()).m_60629_(con)) {
            boolean flag = world.m_276867_(pos) || world.m_276867_(pos.m_7494_());
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)con.m_8125_())).m_61124_(HINGE, (Comparable)this.getHinge(con))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(flag))).m_61124_(HALF, (Comparable)((Object)EnumConect.BOT));
        }
        return null;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        world.m_7731_(pos.m_6630_(1), (BlockState)state.m_61124_(HALF, (Comparable)((Object)EnumConect.CEN)), 3);
        world.m_7731_(pos.m_6630_(2), (BlockState)state.m_61124_(HALF, (Comparable)((Object)EnumConect.TOP)), 3);
    }

    private DoorHingeSide getHinge(BlockPlaceContext con) {
        boolean flag1;
        Level world = con.m_43725_();
        BlockPos pos = con.m_8083_();
        Direction face = con.m_8125_();
        BlockPos pos1 = pos.m_7494_();
        Direction face1 = face.m_122428_();
        BlockPos pos2 = pos.m_121945_(face1);
        BlockState state = world.m_8055_(pos2);
        BlockPos pos3 = pos1.m_121945_(face1);
        BlockState state1 = world.m_8055_(pos3);
        Direction face2 = face.m_122427_();
        BlockPos pos4 = pos.m_121945_(face2);
        BlockState state2 = world.m_8055_(pos4);
        BlockPos pos5 = pos1.m_121945_(face2);
        BlockState state3 = world.m_8055_(pos5);
        int i = (this.isFullBlock((BlockGetter)world, state, pos2) ? -1 : 0) + (this.isFullBlock((BlockGetter)world, state1, pos3) ? -1 : 0) + (this.isFullBlock((BlockGetter)world, state2, pos4) ? 1 : 0) + (this.isFullBlock((BlockGetter)world, state3, pos5) ? 1 : 0);
        boolean flag = state.m_60713_((Block)this) && ((EnumConect)((Object)state.m_61143_(HALF))).is(EnumConect.BOT);
        boolean bl = flag1 = state2.m_60713_((Block)this) && ((EnumConect)((Object)state2.m_61143_(HALF))).is(EnumConect.BOT);
        if ((!flag || flag1) && i <= 0) {
            if ((!flag1 || flag) && i >= 0) {
                int x = face.m_122429_();
                int y = face.m_122431_();
                Vec3 vec3 = con.m_43720_();
                double d0 = vec3.f_82479_ - (double)pos.m_123341_();
                double d1 = vec3.f_82481_ - (double)pos.m_123343_();
                return !(x < 0 && d1 < 0.5 || x > 0 && d1 > 0.5 || y < 0 && d0 > 0.5 || y > 0 && d0 < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    public boolean isFullBlock(BlockGetter world, BlockState state, BlockPos pos) {
        return state.m_60838_(world, pos);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        state = (BlockState)state.m_61122_((Property)OPEN);
        world.m_7731_(pos, state, 10);
        world.m_5594_(player, pos, (Boolean)state.m_61143_((Property)OPEN) != false ? this.getOpenSound() : this.getCloseSound(), SoundSource.BLOCKS, 1.0f, world.m_213780_().m_188501_() * 0.1f + 0.9f);
        world.m_142346_((Entity)player, this.isOpen(state) ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
        return InteractionResult.m_19078_((boolean)world.m_5776_());
    }

    public boolean isOpen(BlockState state) {
        return (Boolean)state.m_61143_((Property)OPEN);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos pos1, boolean flag0) {
        boolean flag;
        boolean bl = world.m_276867_(pos) || world.m_276867_(pos.m_121945_(((EnumConect)((Object)state.m_61143_(HALF))).is(EnumConect.BOT) ? Direction.UP : Direction.DOWN)) ? true : (flag = false);
        if (!this.m_49966_().m_60713_(block) && flag != (Boolean)state.m_61143_((Property)POWERED)) {
            if (flag != (Boolean)state.m_61143_((Property)OPEN)) {
                this.playSound(world, pos, flag);
                world.m_142346_((Entity)null, flag ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
            }
            Direction face = (Direction)state.m_61143_((Property)FACING);
            switch ((EnumConect)((Object)state.m_61143_(HALF))) {
                case TOP: {
                    this.setDoor(world, pos.m_6625_(1), face, flag);
                    this.setDoor(world, pos.m_6625_(2), face, flag);
                    break;
                }
                case CEN: {
                    this.setDoor(world, pos.m_6625_(1), face, flag);
                    this.setDoor(world, pos.m_6630_(1), face, flag);
                    break;
                }
                case BOT: {
                    this.setDoor(world, pos.m_6630_(1), face, flag);
                    this.setDoor(world, pos.m_6630_(2), face, flag);
                }
            }
            world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(flag)), 2);
        }
    }

    public void setDoor(Level world, BlockPos pos, Direction face, boolean flag) {
        world.m_7731_(pos.m_6625_(1), (BlockState)((BlockState)((BlockState)world.m_8055_(pos.m_6625_(1)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)FACING, (Comparable)face), 3);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos posDown = pos.m_7495_();
        BlockState stateDown = world.m_8055_(posDown);
        return ((EnumConect)((Object)state.m_61143_(HALF))).is(EnumConect.BOT) ? stateDown.m_60783_((BlockGetter)world, posDown, Direction.UP) : stateDown.m_60713_((Block)this);
    }

    private void playSound(Level world, BlockPos pos, boolean flag) {
        world.m_5594_(null, pos, flag ? this.getOpenSound() : this.getCloseSound(), SoundSource.BLOCKS, 1.0f, world.m_213780_().m_188501_() * 0.1f + 0.9f);
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    public BlockState m_6843_(BlockState state, Rotation face) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)face.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return mirror == Mirror.NONE ? state : (BlockState)state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING))).m_61122_(HINGE);
    }

    public long m_7799_(BlockState state, BlockPos pos) {
        return Mth.m_14130_((int)pos.m_123341_(), (int)pos.m_6625_(((EnumConect)((Object)state.m_61143_(HALF))).is(EnumConect.BOT) ? 0 : 1).m_123342_(), (int)pos.m_123343_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> build) {
        build.m_61104_(new Property[]{HALF, FACING, OPEN, HINGE, POWERED});
    }

    public static boolean isWoodenDoor(Level world, BlockPos pos) {
        return SMDoor3.isWoodenDoor(world.m_8055_(pos));
    }

    public static boolean isWoodenDoor(BlockState state) {
        return state.m_60734_() instanceof DoorBlock;
    }

    public ItemLike getItem() {
        return switch (this.data) {
            case 1 -> ItemInit.gorgeous_door_w_i;
            default -> ItemInit.gorgeous_door_b_i;
        };
    }

    public ItemStack m_7397_(BlockGetter get, BlockPos pos, BlockState state) {
        return new ItemStack(this.getItem());
    }

    @Override
    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder build) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        if (((EnumConect)((Object)state.m_61143_(HALF))).is(EnumConect.BOT)) {
            stackList.add(new ItemStack(this.getItem()));
        }
        return stackList;
    }
}

