/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.sm;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sweetmagic.init.BlockInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.TabInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.base.BaseModelBlock;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileStove;
import sweetmagic.init.tile.sm.TileTransferGateVertical;

public class TransferGateVertical
extends BaseModelBlock
implements EntityBlock {
    private final int data;
    private int tickTime = 25;
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    private static final VoxelShape AABB = Block.m_49796_((double)-4.0, (double)0.0, (double)-4.0, (double)20.0, (double)16.0, (double)20.0);

    public TransferGateVertical(String name, int data) {
        super(name, TransferGateVertical.setPro(SoundType.f_56743_, 2.0f, 8192.0f));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.UP));
        this.data = data;
        BlockInit.BlockInfo.create(this, (CreativeModeTab)(data == 0 ? TabInit.smMagicTab : null), name);
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> build) {
        build.m_61104_(new Property[]{FACING});
    }

    @Override
    public boolean canRightClick(Player player, ItemStack stack) {
        return !player.m_21023_(PotionInit.non_destructive);
    }

    @Override
    public boolean actionBlock(Level world, BlockPos pos, Player player, ItemStack stack) {
        if (world.m_5776_()) {
            return true;
        }
        pos = this.data == 1 ? pos : pos.m_7494_();
        this.openGUI(world, pos, player, this.getTile(world, pos));
        return true;
    }

    @NotNull
    public BlockState m_5573_(BlockPlaceContext con) {
        Player player = con.m_43723_();
        Direction face = con.m_43719_().m_122424_();
        return face == Direction.DOWN || !player.m_7500_() || !player.m_6144_() ? (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.DOWN) : this.m_49966_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext con) {
        return AABB;
    }

    @Override
    protected boolean isDrop() {
        return false;
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Override
    public void addBlockTip(List<Component> toolTip) {
        toolTip.add((Component)this.getText(this.name).m_130940_(GREEN));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.data == 1 ? new TileTransferGateVertical(pos, state) : new TileStove(pos, state);
    }

    @Override
    public BlockEntityType<? extends TileAbstractSM> getTileType() {
        return this.data == 1 ? TileInit.transferGateVertical : null;
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return this.createMailBoxTicker(world, type, (BlockEntityType<? extends TileAbstractSM>)(this.data == 1 ? TileInit.transferGateVertical : null));
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (world.m_5776_() || this.tickTime++ % 30 != 0 || !(entity instanceof Player)) {
            return;
        }
        Player living = (Player)entity;
        if (this.data == 0) {
            TileTransferGateVertical tile;
            TileAbstractSM bEntity = this.getTile(world, pos.m_7494_());
            if (bEntity != null && bEntity instanceof TileTransferGateVertical && (tile = (TileTransferGateVertical)bEntity).doTereport((LivingEntity)living)) {
                this.tickTime = 25;
            }
            return;
        }
        Direction face = (Direction)state.m_61143_((Property)FACING);
        for (int i = 1; i < 512; ++i) {
            BlockPos newPos = pos;
            switch (face) {
                case UP: {
                    newPos = pos.m_6630_(i);
                    break;
                }
                case DOWN: {
                    newPos = pos.m_6625_(i);
                }
            }
            BlockState targetState = world.m_8055_(newPos);
            if (!targetState.m_60713_(BlockInit.transfer_gate_vertical_top) || targetState.m_61143_((Property)FACING) == face) continue;
            DirectionProperty pro = HorizontalDirectionalBlock.f_54117_;
            BlockState underState = world.m_8055_(newPos.m_6625_(2));
            Direction face2 = underState.m_61138_((Property)pro) ? (Direction)underState.m_61143_((Property)pro) : Direction.NORTH;
            switch (face2) {
                case NORTH: {
                    newPos = newPos.m_122020_(2);
                    break;
                }
                case SOUTH: {
                    newPos = newPos.m_122013_(2);
                    break;
                }
                case WEST: {
                    newPos = newPos.m_122030_(2);
                    break;
                }
                case EAST: {
                    newPos = newPos.m_122025_(2);
                }
            }
            entity.m_6021_((double)newPos.m_123341_() + 0.5, (double)newPos.m_123342_() + 0.5, (double)newPos.m_123343_() + 0.5);
            this.playerSound(world, newPos, SoundEvents.f_11852_, 1.0f, 1.0f);
            this.tickTime = 25;
            break;
        }
    }

    @Nonnull
    public VoxelShape m_5939_(BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, CollisionContext con) {
        return Shapes.m_83040_();
    }

    public ItemStack m_7397_(BlockGetter get, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)BlockInit.transfer_gate_vertical);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        world.m_7731_(pos.m_7494_(), (BlockState)BlockInit.transfer_gate_vertical_top.m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING))), 3);
    }

    @Override
    public void onRemove(Level world, BlockPos pos, BlockState state, TileAbstractSM tile) {
        if (this.data == 1) {
            return;
        }
        this.spawnItem(world, pos, tile.getDropStack(new ItemStack((ItemLike)this)));
    }

    @Override
    @Deprecated
    public void m_6810_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_() && !world.m_5776_()) {
            BlockPos targetPos = this.data == 0 ? pos.m_7494_() : pos.m_7495_();
            TileAbstractSM bEntity = this.getTile(world, targetPos);
            if (this.data == 0 && bEntity != null && bEntity instanceof TileTransferGateVertical) {
                TileTransferGateVertical tile = (TileTransferGateVertical)bEntity;
                this.spawnItem(world, pos, tile.getInputItem());
            }
            this.breakBlock((LevelAccessor)world, targetPos);
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }
}

