/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.sm;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;
import sweetmagic.init.BlockInit;
import sweetmagic.init.TabInit;
import sweetmagic.init.block.base.BaseSMBlock;
import sweetmagic.init.block.sm.WoodChest;
import sweetmagic.init.tile.menu.container.BaseContainer;
import sweetmagic.util.FaceAABB;

public class TrunkCase
extends WoodChest {
    public final int data;
    public static final BooleanProperty ISUNDER = BooleanProperty.m_61465_((String)"isunder");
    private static final VoxelShape[] AABB = FaceAABB.create(1.0, 0.0, 12.0, 15.0, 10.0, 16.0);
    private static final VoxelShape[] SWITCH = FaceAABB.create(0.0, 0.0, 9.5, 16.0, 8.0, 13.75);
    private static final VoxelShape[] UNDER = FaceAABB.create(1.0, 0.0, 6.0, 15.0, 4.0, 16.0);

    public TrunkCase(String name, int data) {
        super(name, BaseSMBlock.setPro(data == 0 ? SoundType.f_56736_ : SoundType.f_56743_, 0.5f, 8192.0f), 6 + data * 2);
        this.m_49959_((BlockState)((BlockState)this.setState().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ISUNDER, (Comparable)Boolean.valueOf(false)));
        BlockInit.BlockInfo.create(this, TabInit.smTab, name);
        this.data = data;
    }

    @Override
    public boolean actionBlock(Level world, BlockPos pos, Player player, ItemStack stack) {
        if (player.m_6144_()) {
            ItemStack drop = this.getDropStack(this.getTile(world, pos));
            if (stack.m_41619_()) {
                player.m_21008_(InteractionHand.MAIN_HAND, drop);
            } else if (world.m_5776_()) {
                this.spawnItem(world, pos, drop);
            }
            world.m_46747_(pos);
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            this.playerSound(world, pos, this.data == 0 ? SoundEvents.f_12630_ : SoundEvents.f_12062_, 1.0f, 0.85f);
        } else {
            super.actionBlock(world, pos, player, stack);
        }
        return true;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext con) {
        int meta = ((Direction)state.m_61143_((Property)FACING)).m_122411_() - 2;
        if (this.data == 1) {
            return SWITCH[meta];
        }
        return (Boolean)state.m_61143_((Property)ISUNDER) != false ? UNDER[meta] : AABB[meta];
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> build) {
        build.m_61104_(new Property[]{FACING, WATERLOGGED, ISUNDER});
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext con) {
        Direction face = con.m_43719_().m_122424_();
        return (BlockState)super.m_5573_(con).m_61124_((Property)ISUNDER, (Comparable)Boolean.valueOf(face == Direction.DOWN));
    }

    @Override
    public void addBlockTip(List<Component> toolTip) {
        super.addBlockTip(toolTip);
        toolTip.add((Component)this.getText("trunkcase").m_130940_(GREEN));
    }

    public void openGui(Level world, Player player, ItemStack stack) {
        if (!world.m_5776_()) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new BaseContainer.ContainerTrunkCase(stack, this.data), buf -> buf.writeInt(this.data));
            this.playerSound(world, player.m_20183_(), this.data == 0 ? SoundEvents.f_12629_ : SoundEvents.f_12088_, 0.5f, world.m_213780_().m_188501_() * 0.1f + 0.9f);
        }
    }
}

