/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.sm;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import sweetmagic.init.BlockInit;
import sweetmagic.init.TabInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.base.BaseFaceBlock;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileWandPedastal;
import sweetmagic.util.FaceAABB;
import sweetmagic.util.ItemHelper;

public class WandPedastal
extends BaseFaceBlock
implements EntityBlock {
    public final int data;
    private static final VoxelShape AABB = Block.m_49796_((double)1.6, (double)0.0, (double)1.6, (double)14.4, (double)9.6, (double)14.4);
    private static final VoxelShape STAND = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape[] WALL = FaceAABB.create(1.0, 1.0, 15.0, 15.0, 15.0, 16.0);
    private static final VoxelShape[] SHOP = FaceAABB.create(7.0, 0.0, 0.0, 9.0, 16.0, 16.0);
    private static final VoxelShape[] WAND = FaceAABB.create(1.0, 0.0, 6.0, 15.0, 8.5, 10.0);

    public WandPedastal(String name, int data) {
        super(name, WandPedastal.setPro(SoundType.f_56742_, 0.5f, 8192.0f).m_60910_());
        this.data = data;
        this.m_49959_(this.setState());
        BlockInit.BlockInfo.create(this, TabInit.smTab, name);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext con) {
        return switch (this.data) {
            case 0 -> AABB;
            case 1 -> FaceAABB.getAABB(WALL, state);
            case 2 -> FaceAABB.getAABB(SHOP, state);
            case 3 -> FaceAABB.getAABB(WALL, state);
            case 4 -> STAND;
            case 5 -> FaceAABB.getAABB(WAND, state);
            default -> Shapes.m_83144_();
        };
    }

    @Override
    public boolean canRightClick(Player player, ItemStack stack) {
        return true;
    }

    @Override
    public boolean actionBlock(Level world, BlockPos pos, Player player, ItemStack stack) {
        if (world.m_5776_()) {
            return true;
        }
        TileAbstractSM tileAbstractSM = this.getTile(world, pos);
        if (!(tileAbstractSM instanceof TileWandPedastal)) {
            return false;
        }
        TileWandPedastal tile = (TileWandPedastal)tileAbstractSM;
        ItemStack inputStack = tile.getInputItem(0);
        if (inputStack.m_41619_()) {
            if (!stack.m_41619_()) {
                ItemStack copy = stack.m_41777_();
                copy.m_41764_(1);
                ItemHelper.insertStack(tile.getInput(), copy, false);
                stack.m_41774_(1);
            }
        } else {
            this.spawnItemList(world, player.m_20183_(), Arrays.asList(inputStack.m_41777_()));
            inputStack.m_41774_(64);
        }
        this.playerSound(world, pos, SoundEvents.f_12019_, 1.0f, 1.0f);
        tile.sendPKT();
        return true;
    }

    @Override
    public boolean isKeepTile() {
        return true;
    }

    @Override
    public void addBlockTip(List<Component> toolTip) {
        toolTip.add((Component)this.getText("wand_pedastal").m_130940_(GREEN));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileWandPedastal(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return this.createMailBoxTicker(world, type, (BlockEntityType<? extends TileAbstractSM>)(this.data == 4 ? TileInit.wandPedastal : null));
    }

    @Override
    protected boolean isDrop() {
        return false;
    }
}

