/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.capability.icap;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import sweetmagic.SweetMagicCore;
import sweetmagic.handler.PacketHandler;
import sweetmagic.init.AdvancedInit;
import sweetmagic.init.CapabilityInit;
import sweetmagic.init.SoundInit;
import sweetmagic.init.tile.sm.TileNotePC;
import sweetmagic.packet.CookStatusPKT;

public interface ICookingStatus
extends INBTSerializable<CompoundTag> {
    public static final String EXP = "exp";
    public static final String LEVEL = "level";
    public static final String HEALTH = "health";
    public static final String TR_LEVEL = "trade_level";
    public static final String TR_EXP = "trade_exp";
    public static final String TR_SP = "trade_sp";
    public static final String RATE = "rate";
    public static final String RAND = "longRand";
    public static final String DATE = "randDate";
    public static final ResourceLocation ID = SweetMagicCore.getSRC("cap_shield");

    default public void addExp(int addExp) {
        this.levelUpCheck(this.getEntity().m_9236_(), Math.max(1, addExp));
    }

    default public void levelUpCheck(Level world, int addExp) {
        int maxLevel;
        int level = this.getCookLevel();
        if (level >= (maxLevel = this.getMaxLevel())) {
            return;
        }
        int exp = this.getExpValue();
        int nextLevel = 1 + level;
        int keepExp = 0;
        int nowNeedExp = this.needExp(nextLevel);
        if (addExp > nowNeedExp) {
            keepExp = addExp - nowNeedExp;
            this.setExpValue(exp + nowNeedExp);
        } else {
            this.setExpValue(exp + addExp);
        }
        int needExp = this.needExp(nextLevel);
        if (needExp > 0) {
            return;
        }
        int upLevel = ++level;
        this.setCookLevel(upLevel);
        this.setExpValue(needExp);
        if (!world.m_5776_()) {
            this.playSound(world, SoundInit.LEVELUP, 0.0625f, 1.0f);
        }
        this.checkAdavanced(this.getEntity(), this.getCookLevel());
        if (keepExp > 0) {
            this.levelUpCheck(world, keepExp);
        }
    }

    default public void checkAdavanced(LivingEntity entity, int level) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer sPlayer = (ServerPlayer)entity;
            AdvancedInit.biginerCook.trigger(sPlayer, 3, level);
            AdvancedInit.intermediateCook.trigger(sPlayer, 7, level);
            AdvancedInit.advancedCook.trigger(sPlayer, 10, level);
        }
    }

    default public void playSound(Level world, SoundEvent sound, float vol, float pitch) {
        LivingEntity entity = this.getEntity();
        entity.m_20193_().m_5594_(null, entity.m_20183_(), sound, SoundSource.PLAYERS, vol, pitch);
    }

    default public int getMaxLevel() {
        return 20;
    }

    default public int needExp(int nextLevel) {
        int needExp = this.getNeedExp(nextLevel) - this.getExpValue();
        return nextLevel - 1 >= this.getMaxLevel() ? 0 : needExp;
    }

    default public int getNeedExp(int nextLevel) {
        int level = nextLevel - 1;
        int baseExp = 100 * level;
        float rateExp = 1.0f + (float)(level - 1) * 0.1f;
        return (int)((float)baseExp * rateExp);
    }

    default public CompoundTag writeNBT() {
        CompoundTag tags = new CompoundTag();
        tags.m_128405_(EXP, this.getExpValue());
        tags.m_128405_(LEVEL, this.getCookLevel());
        tags.m_128350_(HEALTH, this.getHealth());
        tags.m_128405_(TR_LEVEL, this.getTradeLevel());
        tags.m_128350_(TR_EXP, this.getTradeExp());
        tags.m_128405_(TR_SP, this.getTradeSP());
        tags.m_128350_(RATE, this.getRate());
        tags.m_128356_(RAND, this.getLongRand());
        tags.m_128356_(DATE, this.getRandDate());
        this.saveTradeList(tags, this.getSeedList(), "seedList");
        this.saveTradeList(tags, this.getFurnitureList(), "furnitureList");
        this.saveTradeList(tags, this.getMagicList(), "magicList");
        this.saveTradeList(tags, this.getEnchantList(), "enchantList");
        this.saveTradeList(tags, this.getSeasoningList(), "seasoningList");
        this.saveTradeList(tags, this.getVanillaList(), "vanillaList");
        return tags;
    }

    default public void readNBT(CompoundTag tags) {
        this.setExpValue(tags.m_128451_(EXP));
        this.setCookLevel(Math.max(1, tags.m_128451_(LEVEL)));
        this.setHealth(tags.m_128457_(HEALTH));
        this.setTradeLevel(Math.max(1, tags.m_128451_(TR_LEVEL)));
        this.setTradeExp(tags.m_128457_(TR_EXP));
        this.setTradeSP(tags.m_128451_(TR_SP));
        this.setRate(tags.m_128457_(RATE));
        this.setLongRand(tags.m_128454_(RAND));
        this.setRandDate(tags.m_128454_(DATE));
        this.setSeedList(this.loadAllTrade(tags, "seedList"));
        this.setFurnitureList(this.loadAllTrade(tags, "furnitureList"));
        this.setMagicList(this.loadAllTrade(tags, "magicList"));
        this.setEnchantList(this.loadAllTrade(tags, "enchantList"));
        this.setSeasoningList(this.loadAllTrade(tags, "seasoningList"));
        this.setVanillaList(this.loadAllTrade(tags, "vanillaList"));
    }

    public void setEntity(LivingEntity var1);

    public LivingEntity getEntity();

    public void setExpValue(int var1);

    public int getExpValue();

    public void setCookLevel(int var1);

    public int getCookLevel();

    public void setHealth(float var1);

    public float getHealth();

    public int getTradeLevel();

    public void setTradeLevel(int var1);

    public float getTradeExp();

    public void setTradeExp(float var1);

    public int getTradeSP();

    public void setTradeSP(int var1);

    public float getRate();

    public void setRate(float var1);

    public long getLongRand();

    public void setLongRand(long var1);

    public long getRandDate();

    public void setRandDate(long var1);

    public List<TileNotePC.TradeInfo> getSeedList();

    public void setSeedList(List<TileNotePC.TradeInfo> var1);

    public List<TileNotePC.TradeInfo> getMagicList();

    public void setMagicList(List<TileNotePC.TradeInfo> var1);

    public List<TileNotePC.TradeInfo> getFurnitureList();

    public void setFurnitureList(List<TileNotePC.TradeInfo> var1);

    public List<TileNotePC.TradeInfo> getEnchantList();

    public void setEnchantList(List<TileNotePC.TradeInfo> var1);

    public List<TileNotePC.TradeInfo> getVanillaList();

    public void setVanillaList(List<TileNotePC.TradeInfo> var1);

    public List<TileNotePC.TradeInfo> getSeasoningList();

    public void setSeasoningList(List<TileNotePC.TradeInfo> var1);

    default public int getTradeIntExp() {
        return (int)this.getTradeExp();
    }

    default public void addTradeSP(int sp) {
        this.setTradeSP(this.getTradeSP() + sp);
    }

    default public void addTradeExp(Level world, int price, boolean isBuy) {
        float rate = isBuy ? 0.25f : 0.05f;
        this.tradeLevelUpCheck(world, (float)price * rate);
    }

    default public void tradeLevelUpCheck(Level world, float addExp) {
        int maxLevel;
        int level = this.getTradeLevel();
        if (level >= (maxLevel = this.maxTradeLevel())) {
            return;
        }
        float exp = this.getTradeExp();
        int nextLevel = 1 + level;
        float keepExp = 0.0f;
        float nowNeedExp = (float)this.needTradeExp(nextLevel) - exp;
        if (addExp > nowNeedExp) {
            keepExp = addExp - nowNeedExp;
            this.setTradeExp(exp + nowNeedExp);
        } else {
            this.setTradeExp(exp + addExp);
        }
        int needExp = this.needTradeExp(nextLevel) - this.getTradeIntExp();
        if (needExp > 0) {
            return;
        }
        int upLevel = ++level;
        this.setTradeLevel(upLevel);
        this.setTradeExp(needExp);
        if (!world.m_5776_()) {
            this.playSound(world, SoundEvents.f_12275_, 0.0625f, 1.15f);
        }
        if (keepExp > 0.0f) {
            this.tradeLevelUpCheck(world, keepExp);
        }
    }

    default public int needExp() {
        int level = this.getTradeLevel();
        int needExp = this.needTradeExp(level + 1) - this.getTradeIntExp();
        return level >= this.maxTradeLevel() ? 0 : needExp;
    }

    default public int needTradeExp(int nextLevel) {
        return switch (nextLevel) {
            case 1 -> 0;
            case 2 -> 1000;
            case 3 -> 3000;
            case 4 -> 15000;
            case 5 -> 25000;
            default -> 1000;
        };
    }

    default public int maxTradeLevel() {
        return 5;
    }

    default public int getExpProgress(int value) {
        return this.getExpProgress(value, 0);
    }

    default public int getExpProgress(int value, int addValue) {
        int nextEXP = this.needTradeExp(this.getTradeLevel() + 1);
        float nowEXP = this.getTradeExp() + (float)addValue;
        return Math.min(value, (int)((float)value * (nowEXP / (float)nextEXP)));
    }

    public static boolean hasValue(LivingEntity entity) {
        return entity.getCapability(CapabilityInit.COOK).resolve().isPresent();
    }

    public static ICookingStatus getState(LivingEntity entity) {
        LazyOptional opt = entity.getCapability(CapabilityInit.COOK);
        return opt != null ? (ICookingStatus)opt.resolve().get() : null;
    }

    public static void sendPKT(Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer ser = (ServerPlayer)player;
        player.getCapability(CapabilityInit.COOK).ifPresent(o -> PacketHandler.sendTo(new CookStatusPKT((CompoundTag)o.serializeNBT()), ser));
    }

    default public CompoundTag saveTradeList(CompoundTag nbt, List<TileNotePC.TradeInfo> tradeList, String name) {
        if (tradeList != null && !tradeList.isEmpty()) {
            ListTag tagsList = new ListTag();
            for (TileNotePC.TradeInfo trade : tradeList) {
                CompoundTag tags = new CompoundTag();
                tags.m_128365_("stack", (Tag)trade.stack().m_41739_(new CompoundTag()));
                tags.m_128405_("price", trade.price());
                tagsList.add((Object)tags);
            }
            nbt.m_128365_(name, (Tag)tagsList);
        }
        return nbt;
    }

    default public List<TileNotePC.TradeInfo> loadAllTrade(CompoundTag nbt, String name) {
        ArrayList<TileNotePC.TradeInfo> tradeList = new ArrayList<TileNotePC.TradeInfo>();
        nbt.m_128437_(name, 10).forEach(t -> tradeList.add(new TileNotePC.TradeInfo(ItemStack.m_41712_((CompoundTag)this.getTag((Tag)t).m_128469_("stack")), this.getTag((Tag)t).m_128451_("price"))));
        return tradeList;
    }

    default public CompoundTag getTag(Tag tag) {
        return (CompoundTag)tag;
    }
}

