/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.capability.icap;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.CapabilityInit;
import sweetmagic.init.capability.WorldDataHandler;
import sweetmagic.init.tile.sm.TileMagiaLantern;

public interface IWorldData
extends ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static final ResourceLocation ID = SweetMagicCore.getSRC("cap_world");

    default public List<BlockPos> getPosList(Level world) {
        return IWorldData.getData((Level)world).posList;
    }

    public static void registerPos(Level world, BlockPos pos) {
        IWorldData.getData((Level)world).posList.add(pos);
    }

    public static void removePos(Level world, BlockPos pos) {
        IWorldData.getData((Level)world).posList.removeIf(p -> p.equals((Object)pos));
    }

    public static boolean isPosInRange(Level world, BlockPos entityPos) {
        WorldDataHandler data = IWorldData.getData(world);
        double posX = entityPos.m_123341_();
        double posZ = entityPos.m_123343_();
        for (BlockPos pos : data.getPosList()) {
            if (!data.checkDistance(world, posX, posZ, pos) || !data.checkHasMF(world, pos)) continue;
            return true;
        }
        return false;
    }

    default public boolean checkDistance(Level world, double posX, double posZ, BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile == null || !(tile instanceof TileMagiaLantern)) {
            return false;
        }
        TileMagiaLantern core = (TileMagiaLantern)tile;
        int range = core.getRange();
        return Math.abs(posX - (double)pos.m_123341_()) <= (double)range && Math.abs(posZ - (double)pos.m_123343_()) <= (double)range;
    }

    default public boolean checkHasMF(Level world, BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile == null || !(tile instanceof TileMagiaLantern)) {
            return false;
        }
        TileMagiaLantern core = (TileMagiaLantern)tile;
        return core.getMF() >= core.getShrinkMF() && !core.isRSPower();
    }

    public List<BlockPos> getPosList();

    default public CompoundTag writeNBT() {
        CompoundTag nbt = new CompoundTag();
        ListTag tagsList = new ListTag();
        for (BlockPos pos : this.getPosList()) {
            CompoundTag tags = new CompoundTag();
            tags.m_128405_("x", pos.m_123341_());
            tags.m_128405_("y", pos.m_123342_());
            tags.m_128405_("z", pos.m_123343_());
            tagsList.add((Object)tags);
        }
        nbt.m_128365_("tagsList", (Tag)tagsList);
        return nbt;
    }

    default public void readNBT(CompoundTag nbt) {
        ListTag tagsList = nbt.m_128437_("tagsList", 10);
        for (Tag tag : tagsList) {
            CompoundTag tags = (CompoundTag)tag;
            this.getPosList().add(new BlockPos(tags.m_128451_("x"), tags.m_128451_("y"), tags.m_128451_("z")));
        }
    }

    public static WorldDataHandler getData(Level world) {
        return (WorldDataHandler)world.getCapability(CapabilityInit.TEB).resolve().get();
    }
}

