/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.animal;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import sweetmagic.api.ientity.IWitch;
import sweetmagic.init.PotionInit;
import sweetmagic.init.SoundInit;
import sweetmagic.init.entity.animal.AbstractSummonMob;
import sweetmagic.init.entity.projectile.AbstractMagicShot;

public abstract class AbstractWitch
extends AbstractSummonMob
implements IWitch {
    protected int coolTime = 0;
    protected int recastTime = 0;
    protected int damageCoolTime = 0;
    public AnimationState magicAttackAnim = new AnimationState();

    public AbstractWitch(EntityType<? extends AbstractSummonMob> eType, Level world) {
        super(eType, world);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22284_, 0.5).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22277_, 48.0);
    }

    public void m_7822_(byte par1) {
        switch (par1) {
            case 4: {
                this.magicAttackAnim.m_216973_();
                break;
            }
            case 5: {
                this.magicAttackAnim.m_216977_(this.f_19797_);
                break;
            }
            default: {
                super.m_7822_(par1);
            }
        }
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12548_;
    }

    protected SoundEvent m_7975_(DamageSource src) {
        return SoundEvents.f_12552_;
    }

    protected float m_6121_() {
        return 0.4f;
    }

    @Override
    public AnimationState getAnimaState() {
        return this.magicAttackAnim;
    }

    @Override
    public boolean isCharge() {
        return false;
    }

    @Override
    public void m_7380_(CompoundTag tags) {
        super.m_7380_(tags);
        tags.m_128405_("coolTime", this.coolTime);
        tags.m_128405_("recastTime", this.recastTime);
        tags.m_128405_("damageCoolTime", this.damageCoolTime);
    }

    @Override
    public void m_7378_(CompoundTag tags) {
        super.m_7378_(tags);
        this.coolTime = tags.m_128451_("coolTime");
        this.recastTime = tags.m_128451_("recastTime");
        this.damageCoolTime = tags.m_128451_("damageCoolTime");
    }

    @Override
    public boolean m_6469_(DamageSource src, float amount) {
        this.damageCoolTime = 400;
        return super.m_6469_(src, amount);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.damageCoolTime > 0) {
            --this.damageCoolTime;
        }
        if (this.f_19797_ % 80 == 0 && this.m_21233_() > this.m_21223_() && this.damageCoolTime <= 0) {
            this.m_21153_(this.m_21223_() + 2.0f);
        }
        this.addPotion();
    }

    @Override
    protected void m_8024_() {
        LivingEntity target;
        super.m_8024_();
        if (this.recastTime > 0) {
            --this.recastTime;
        }
        if ((target = this.m_5448_()) == null || this.getShit()) {
            this.m_9236_().m_7605_((Entity)this, (byte)4);
            return;
        }
        if (this.recastTime - 16 == 0) {
            this.m_9236_().m_7605_((Entity)this, (byte)5);
        }
        this.m_21563_().m_24960_((Entity)target, 10.0f, 10.0f);
        if (this.recastTime > 0) {
            return;
        }
        this.magicAttack(target, target instanceof Warden);
    }

    public void magicAttack(LivingEntity target, boolean isWarden) {
        int level;
        this.recastTime = this.getRecastTime();
        float dama = this.getPower(this.getWandLevel()) + (float)this.m_21133_(Attributes.f_22281_) * 0.33f;
        float dameRate = isWarden ? 4.0f : this.getDamageRate();
        double x = target.m_20185_() - this.m_20185_();
        double y = target.m_20227_(0.3333333333333333) - this.m_20186_();
        double z = target.m_20189_() - this.m_20189_();
        double xz = Math.sqrt(x * x + z * z);
        int n = level = isWarden ? this.getWandLevel() + 20 : this.getWandLevel();
        if (!isWarden && this.isBoss((Entity)target)) {
            dama /= 5.0f;
        }
        AbstractMagicShot entity = this.getMagicShot(target, isWarden);
        entity.setData(1);
        entity.setRange(4.5 + (double)this.getRange());
        entity.setWandLevel(level);
        entity.m_6686_(x, y - xz * 0.035, z, 2.25f, 0.0f);
        entity.setAddDamage((entity.getAddDamage() + dama) * dameRate);
        this.m_5496_(SoundEvents.f_11705_, 0.5f, 0.67f);
        this.m_9236_().m_7967_((Entity)entity);
    }

    public int getRecastTime() {
        return 150;
    }

    @Override
    public int getWandLevel() {
        return 10;
    }

    public float getDamageRate() {
        return 1.0f;
    }

    public void addPotion() {
        if (this.isClient() || this.m_5448_() == null) {
            return;
        }
        if (this.coolTime > 0) {
            --this.coolTime;
            if (this.coolTime > 0) {
                return;
            }
        }
        if (this.m_21223_() <= this.m_21233_() / 2.0f) {
            if (!this.m_21023_(PotionInit.aether_barrier)) {
                this.addPotion((LivingEntity)this, PotionInit.aether_barrier, 400, 2);
                this.m_5496_(SoundEvents.f_11887_, 0.25f, 1.175f);
                this.coolTime += 200;
                return;
            }
            this.m_21153_(this.m_21223_() + this.getHealValue());
            this.coolTime += 200;
            this.m_5496_(SoundInit.HEAL, 0.0625f, 1.0f);
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                this.spawnParticleRing(server, (ParticleOptions)ParticleTypes.f_123748_, 0.75, this.m_20183_(), 1.0, 0.1, 0.0);
            }
            return;
        }
        int time = 400;
        int coolTime = 300;
        switch (this.rand.nextInt(4)) {
            case 0: {
                if (!this.m_21023_(PotionInit.reflash_effect)) {
                    this.addPotion((LivingEntity)this, PotionInit.reflash_effect, time, 0);
                    this.m_5496_(SoundEvents.f_11887_, 0.25f, 1.175f);
                    this.coolTime = (int)((float)this.coolTime + (float)coolTime * 1.25f);
                }
                return;
            }
            case 1: {
                if (!this.m_21023_(PotionInit.magic_damage_cause)) {
                    this.addPotion((LivingEntity)this, PotionInit.magic_damage_cause, time, 4);
                    this.m_5496_(SoundEvents.f_11887_, 0.25f, 1.175f);
                    this.coolTime += coolTime;
                }
                return;
            }
            case 2: {
                if (!this.m_21023_(PotionInit.aether_barrier)) {
                    this.addPotion((LivingEntity)this, PotionInit.aether_barrier, time, 1);
                    this.m_5496_(SoundEvents.f_11887_, 0.25f, 1.175f);
                    this.coolTime += coolTime;
                }
                return;
            }
            case 3: {
                if (!this.m_21023_(MobEffects.f_19600_)) {
                    this.addPotion((LivingEntity)this, MobEffects.f_19600_, time, 1);
                    this.m_5496_(SoundEvents.f_11887_, 0.25f, 1.175f);
                    this.coolTime += coolTime;
                }
                return;
            }
        }
    }

    public abstract AbstractMagicShot getMagicShot(LivingEntity var1, boolean var2);

    public abstract float getHealValue();

    public abstract ItemStack getStack();
}

