/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.animal;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.api.util.ISMTip;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.animal.AbstractWitch;
import sweetmagic.init.entity.projectile.AbstractMagicShot;
import sweetmagic.init.entity.projectile.CommetBulet;

public class StellaWizard
extends AbstractWitch
implements ISMTip {
    private static final ItemStack WAND = new ItemStack((ItemLike)ItemInit.magic_book_scarlet);
    private static final EntityDataAccessor<Float> CRYSTAL_HEALTH = ISMMob.setData(StellaWizard.class, ISMMob.FLOAT);
    private static final EntityDataAccessor<Float> MAX_CRYSTAL_HEALTH = ISMMob.setData(StellaWizard.class, ISMMob.FLOAT);
    private static final EntityDataAccessor<Boolean> CRYSTAL = ISMMob.setData(StellaWizard.class, ISMMob.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DEMONS = ISMMob.setData(StellaWizard.class, ISMMob.BOOLEAN);

    public StellaWizard(Level world) {
        super(EntityInit.stellaWizard, world);
    }

    public StellaWizard(EntityType<? extends AbstractWitch> eType, Level world) {
        super(eType, world);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(CRYSTAL, false);
        this.define(DEMONS, false);
        this.define(CRYSTAL_HEALTH, Float.valueOf(0.0f));
        this.define(MAX_CRYSTAL_HEALTH, Float.valueOf(0.0f));
    }

    public boolean getCrystal() {
        return this.get(CRYSTAL);
    }

    public void setCrystal(boolean crystal) {
        this.set(CRYSTAL, crystal);
    }

    public boolean getDemons() {
        return this.get(DEMONS);
    }

    public void setDemons(boolean demons) {
        this.set(DEMONS, demons);
    }

    public float getCrystalHealth() {
        return this.get(CRYSTAL_HEALTH).floatValue();
    }

    public void setCrystalHealth(float crystal) {
        this.set(CRYSTAL_HEALTH, Float.valueOf(crystal));
    }

    public float getMaxCrystalHealth() {
        return this.get(MAX_CRYSTAL_HEALTH).floatValue();
    }

    public void setMaxCrystalHealth(float crystal) {
        this.set(MAX_CRYSTAL_HEALTH, Float.valueOf(crystal));
    }

    @Override
    public boolean canAttack() {
        return this.getCrystalHealth() > 0.0f;
    }

    @Override
    public void m_7380_(CompoundTag tags) {
        super.m_7380_(tags);
        tags.m_128379_("isCrystal", this.getCrystal());
        tags.m_128379_("isDemons", this.getDemons());
        tags.m_128350_("crystalHealth", this.getCrystalHealth());
        tags.m_128350_("maxCrystalHealth", this.getMaxCrystalHealth());
    }

    @Override
    public void m_7378_(CompoundTag tags) {
        super.m_7378_(tags);
        this.setCrystal(tags.m_128471_("isCrystal"));
        this.setDemons(tags.m_128471_("isDemons"));
        this.setCrystalHealth(tags.m_128457_("crystalHealth"));
        this.setMaxCrystalHealth(tags.m_128457_("maxCrystalHealth"));
    }

    @Override
    public boolean m_6469_(DamageSource src, float amount) {
        Entity attacker = src.m_7639_();
        if (this.getCrystal()) {
            Level level;
            if (!(attacker instanceof Player)) {
                return false;
            }
            int count = 16;
            this.setCrystalHealth(this.getCrystalHealth() - amount);
            if (this.getCrystalHealth() <= 0.0f) {
                count = 64;
                this.setCrystal(false);
                this.m_5496_(SoundEvents.f_144050_, 2.0f, 1.0f);
                this.addPotion((LivingEntity)this, PotionInit.reflash_effect, 99999, 0);
                this.addPotion((LivingEntity)this, PotionInit.aether_armor, 99999, 100);
                this.addPotion((LivingEntity)this, PotionInit.aether_barrier, 99999, 100);
                this.addPotion((LivingEntity)this, PotionInit.damage_cut, 99999, 100);
                this.addPotion((LivingEntity)this, PotionInit.regeneration, 99999, 100);
                this.addPotion((LivingEntity)this, PotionInit.resurrection, 99999, 100);
                this.addPotion((LivingEntity)this, PotionInit.resistance_blow, 99999, 100);
                if (!this.isClient()) {
                    List<Player> playerList = this.getEntityList(Player.class, 48.0);
                    playerList.forEach(p -> p.m_213846_((Component)this.getText("stella_wizard_summon", new Object[]{this.m_5446_().getString()}).m_130940_(GREEN)));
                }
            } else {
                this.m_5496_(SoundEvents.f_144245_, 2.0f, 1.0f);
            }
            if ((level = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel sever = (ServerLevel)level;
                SimpleParticleType par = ParticleInit.DIVINE;
                BlockPos pos = this.m_20183_();
                for (int i = 0; i < count; ++i) {
                    float x = (float)pos.m_123341_() + 0.5f + this.getRand(1.5f);
                    float y = (float)pos.m_123342_() + 0.5f + this.getRand(0.5f);
                    float z = (float)pos.m_123343_() + 0.5f + this.getRand(1.5f);
                    sever.m_8767_((ParticleOptions)par, (double)x, (double)y, (double)z, 1, (double)this.getRand(0.15f), (double)(this.rand.nextFloat() * 0.5f), (double)this.getRand(0.15f), 1.0);
                }
            }
            amount = 0.0f;
            return true;
        }
        return super.m_6469_(src, amount);
    }

    @Override
    public InteractionResult mobClick(InteractionResult result, Player player, ItemStack stack) {
        if (this.getCrystal()) {
            return InteractionResult.PASS;
        }
        return super.mobClick(result, player, stack);
    }

    @Override
    public void m_8119_() {
        if (this.getCrystal()) {
            return;
        }
        super.m_8119_();
    }

    @Override
    protected void m_8024_() {
        if (this.getCrystal()) {
            return;
        }
        super.m_8024_();
    }

    @Override
    public void magicAttack(LivingEntity target, boolean isWarden) {
        List<CommetBulet> commetList = this.getEntityList(CommetBulet.class, (T e) -> e.m_19749_() == this && e.getCharge(), 64.0);
        if (!commetList.isEmpty()) {
            commetList.get(0).setCharge(false);
            this.recastTime -= 4;
        } else {
            float damage = 20.0f;
            float dameRate = isWarden ? 2.0f : 1.0f;
            this.recastTime = this.getRecastTime();
            List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, (T e) -> e instanceof Enemy, 48.0);
            int size = Math.max(12, entityList.size());
            for (int i = 0; i < size; ++i) {
                if (entityList.isEmpty()) {
                    return;
                }
                int randValue = this.rand.nextInt(entityList.size());
                randValue = entityList.size() >= randValue ? 0 : randValue;
                LivingEntity entity = entityList.get(Math.max(0, randValue));
                AbstractMagicShot magic = this.getMagicShot(entity, isWarden);
                double x = entity.m_20185_() - this.m_20185_();
                double y = entity.m_20227_(0.3333333333333333) - this.m_20186_();
                double z = entity.m_20189_() - this.m_20189_();
                double xz = Math.sqrt(x * x + z * z);
                magic.m_6686_(x, y - xz * 0.065, z, 2.0f, 0.0f);
                magic.setAddDamage((magic.getAddDamage() + damage) * dameRate);
                magic.m_6034_(this.m_20185_() + (double)this.getRand(0.5f), this.m_20186_() + 1.0 + (double)this.getRand(0.5f), this.m_20189_() + (double)this.getRand(0.5f));
                this.m_9236_().m_7967_((Entity)magic);
            }
        }
    }

    @Override
    public AbstractMagicShot getMagicShot(LivingEntity target, boolean isWarden) {
        CommetBulet magic = new CommetBulet((LivingEntity)this);
        magic.setWandLevel(this.getWandLevel());
        magic.setTarget((Entity)target);
        magic.setCharge(true);
        magic.m_20256_(new Vec3(0.0, 0.0, 0.0));
        return magic;
    }

    @Override
    public ItemStack getStack() {
        return WAND;
    }

    @Override
    public int getRecastTime() {
        return 200;
    }

    @Override
    public int getWandLevel() {
        return 20;
    }

    @Override
    public float getHealValue() {
        return this.m_21233_() * 0.67f;
    }
}

