/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.animal;

import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.EntityInit;
import sweetmagic.init.entity.animal.AbstractSummonMob;
import sweetmagic.init.entity.projectile.AbstractMagicShot;
import sweetmagic.init.entity.projectile.FireMagicShot;
import sweetmagic.init.entity.projectile.FrostMagicShot;
import sweetmagic.init.entity.projectile.PoisonMagicShot;

public class WitchAllay
extends AbstractSummonMob {
    @Nullable
    private BlockPos jukeboxPos;
    private int recastTime = 0;
    private static final int RAND_RECASTTIME = 70;
    private float danceTick;
    private float spinTick;
    private float spinTick0;
    public AnimationState magicAttackAnim = new AnimationState();
    public AnimationState winkAnim = new AnimationState();
    public AnimationState summonAnim = new AnimationState();
    private final DynamicGameEventListener<JukeboxListener> jukeboxListener;
    private static final EntityDataAccessor<Boolean> DANCE = ISMMob.setData(WitchAllay.class, ISMMob.BOOLEAN);

    public WitchAllay(Level world) {
        this(EntityInit.witchAllay, world);
    }

    public WitchAllay(EntityType<? extends AbstractSummonMob> eType, Level world) {
        super(eType, world);
        this.f_21342_ = new ISMMob.SMMoveControl((Mob)this);
        this.m_20242_(true);
        this.m_21553_(this.m_21531_());
        EntityPositionSource pSrc = new EntityPositionSource((Entity)this, this.m_20192_());
        JukeboxListener lis = new JukeboxListener((PositionSource)pSrc, GameEvent.f_238690_.m_157827_());
        this.jukeboxListener = new DynamicGameEventListener((GameEventListener)lis);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(DANCE, false);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22280_, 0.2).m_22268_(Attributes.f_22279_, 0.1).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22284_, 0.15).m_22268_(Attributes.f_22277_, 48.0);
    }

    public void m_7822_(byte par1) {
        switch (par1) {
            case 4: {
                this.magicAttackAnim.m_216973_();
                this.winkAnim.m_216973_();
                break;
            }
            case 5: {
                this.magicAttackAnim.m_216977_(this.f_19797_);
                break;
            }
            case 6: {
                this.winkAnim.m_216977_(this.f_19797_);
                break;
            }
            case 7: {
                this.summonAnim.m_216977_(this.f_19797_);
                break;
            }
            default: {
                super.m_7822_(par1);
            }
        }
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(4, (Goal)new AbstractSummonMob.RandomOwnerMoveGoal(this, 0.0));
        this.f_21345_.m_25352_(7, (Goal)new AbstractSummonMob.SMLookPlayerGoal(this, Monster.class, false));
        this.f_21345_.m_25352_(8, (Goal)new AbstractSummonMob.SMLookPlayerGoal(this, Player.class, true));
        this.f_21345_.m_25352_(9, (Goal)new AbstractSummonMob.SMRandomLookAroundGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new AbstractSummonMob.SMOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new AbstractSummonMob.SMOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(4, new AbstractSummonMob.SMMobAttackGoal<Monster>(this, Monster.class, false));
        this.f_21346_.m_25352_(5, new AbstractSummonMob.AttackTargetGoal<Raider>(this, Raider.class, false));
        this.f_21346_.m_25352_(6, new AbstractSummonMob.AttackTargetGoal<Warden>(this, Warden.class, false));
        this.f_21346_.m_25352_(7, new AbstractSummonMob.AttackTargetGoal<Slime>(this, Slime.class, false));
    }

    @Override
    public void setState(double rate) {
        super.setState(rate);
        this.setAttribute(Attributes.f_22280_, rate);
        this.setAttribute(Attributes.f_22278_, rate);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_215670_;
    }

    protected SoundEvent m_7975_(DamageSource src) {
        return SoundEvents.f_215675_;
    }

    protected float m_6121_() {
        return 0.25f;
    }

    public boolean getDancing() {
        return this.get(DANCE);
    }

    public void setDancing(boolean dancing) {
        if (!this.isClient()) {
            this.set(DANCE, dancing);
        }
    }

    @Override
    public void m_7380_(CompoundTag tags) {
        super.m_7380_(tags);
        tags.m_128405_("recastTime", this.recastTime);
    }

    @Override
    public void m_7378_(CompoundTag tags) {
        super.m_7378_(tags);
        this.recastTime = tags.m_128451_("summonTime");
    }

    protected boolean m_213814_() {
        return false;
    }

    public void m_7023_(Vec3 vec) {
        if (this.m_21515_() || this.m_6109_()) {
            if (this.m_20069_()) {
                this.m_19920_(0.02f, vec);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.8f));
            } else if (this.m_20077_()) {
                this.m_19920_(0.02f, vec);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_(0.5));
            } else {
                this.m_19920_(this.m_6113_(), vec);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_(0.9));
            }
        }
        this.m_267651_(false);
    }

    protected float m_6431_(Pose po, EntityDimensions dim) {
        return dim.f_20378_ * 0.6f;
    }

    private boolean shouldStopDancing() {
        return this.jukeboxPos == null || !this.jukeboxPos.m_203195_((Position)this.m_20182_(), (double)GameEvent.f_238690_.m_157827_()) || !this.m_9236_().m_8055_(this.jukeboxPos).m_60713_(Blocks.f_50131_);
    }

    public void setJukeboxPlaying(BlockPos pos, boolean flag) {
        if (flag) {
            if (!this.getDancing()) {
                this.jukeboxPos = pos;
                this.setDancing(true);
            }
        } else if (pos.equals((Object)this.jukeboxPos) || this.jukeboxPos == null) {
            this.jukeboxPos = null;
            this.setDancing(false);
        }
    }

    public boolean isSpinning() {
        return this.danceTick % 55.0f < 15.0f;
    }

    public float getSpinningProgress(float par1) {
        return Mth.m_14179_((float)par1, (float)this.spinTick0, (float)this.spinTick) / 15.0f;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    public void m_213651_(BiConsumer<DynamicGameEventListener<?>, ServerLevel> bi) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            bi.accept(this.jukeboxListener, server);
        }
    }

    @Override
    public InteractionResult mobClick(InteractionResult result, Player player, ItemStack stack) {
        this.m_9236_().m_7605_((Entity)this, (byte)(!this.m_21827_() ? 6 : 4));
        if (!this.m_21827_()) {
            double d1 = player.m_20185_() - this.m_20185_();
            double d2 = player.m_20189_() - this.m_20189_();
            this.m_146922_(-((float)Math.atan2(d1, d2)) * 180.0f / (float)Math.PI);
        }
        return super.mobClick(result, player, stack);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.isClient() && this.m_6084_() && this.f_19797_ % 20 == 0) {
            this.m_5634_(1.0f);
        }
        if (this.getDancing() && this.shouldStopDancing() && this.f_19797_ % 20 == 0) {
            this.setDancing(false);
            this.jukeboxPos = null;
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.isClient()) {
            return;
        }
        if (this.getDancing()) {
            this.danceTick += 1.0f;
            this.spinTick0 = this.spinTick;
            this.spinTick = this.isSpinning() ? (this.spinTick += 1.0f) : (this.spinTick -= 1.0f);
            this.spinTick = Mth.m_14036_((float)this.spinTick, (float)0.0f, (float)15.0f);
        } else {
            this.spinTick0 = 0.0f;
            this.spinTick = 0.0f;
            this.danceTick = 0.0f;
        }
    }

    @Override
    protected void m_8024_() {
        LivingEntity target;
        ProfilerFiller pro = this.m_9236_().m_46473_();
        pro.m_6180_("allayBrain");
        pro.m_7238_();
        pro.m_6180_("allayActivityUpdate");
        pro.m_7238_();
        super.m_8024_();
        if (this.f_19797_ == 1) {
            this.m_9236_().m_7605_((Entity)this, (byte)7);
        }
        if (this.recastTime > 0) {
            this.recastTime = Math.min(this.recastTime - 1, 300);
        }
        if ((target = this.m_5448_()) == null || this.recastTime > 0 || this.getShit()) {
            return;
        }
        if (!target.m_6084_()) {
            this.m_6710_(null);
        }
        this.m_9236_().m_7605_((Entity)this, (byte)5);
        boolean isWarden = target instanceof Warden;
        this.recastTime = (int)((float)(this.rand.nextInt(70) + 130) * (isWarden ? 0.25f : 1.0f));
        AbstractMagicShot entity = this.getMagicShot(target, isWarden);
        this.m_5496_(SoundEvents.f_11705_, 0.5f, 0.67f);
        this.m_9236_().m_7967_((Entity)entity);
    }

    public AbstractMagicShot getMagicShot(LivingEntity target, boolean isWarden) {
        int level;
        AbstractMagicShot entity = null;
        float dama = this.getPower(this.getWandLevel()) * 0.75f;
        float dameRate = isWarden ? 3.0f : 1.0f;
        double x = target.m_20185_() - this.m_20185_();
        double y = target.m_20227_(0.3333333333333333) - this.m_20186_();
        double z = target.m_20189_() - this.m_20189_();
        double xz = Math.sqrt(x * x + z * z);
        int n = level = isWarden ? 20 : 7;
        if (!isWarden && this.isBoss((Entity)target)) {
            dama /= 6.0f;
        }
        switch (this.rand.nextInt(3)) {
            case 0: {
                entity = new FireMagicShot((LivingEntity)this);
                break;
            }
            case 1: {
                entity = new FrostMagicShot((LivingEntity)this);
                break;
            }
            case 2: {
                entity = new PoisonMagicShot((LivingEntity)this);
            }
        }
        entity.setData(1);
        entity.setWandLevel(level);
        entity.setRange(3.0 + (double)this.getRange());
        entity.m_6686_(x, y - xz * 0.035, z, 1.75f, 0.0f);
        entity.setAddDamage((entity.getAddDamage() + dama) * dameRate);
        return entity;
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)this.m_20192_() * 0.6, (double)this.m_20205_() * 0.1);
    }

    public class JukeboxListener
    implements GameEventListener {
        private final PositionSource pSrc;
        private final int radius;

        public JukeboxListener(PositionSource pSrc, int radius) {
            this.pSrc = pSrc;
            this.radius = radius;
        }

        public PositionSource m_142460_() {
            return this.pSrc;
        }

        public int m_142078_() {
            return this.radius;
        }

        public boolean m_214068_(ServerLevel world, GameEvent event, GameEvent.Context con, Vec3 vec) {
            if (event == GameEvent.f_238690_) {
                WitchAllay.this.setJukeboxPlaying(BlockPos.m_274446_((Position)vec), true);
                return true;
            }
            if (event == GameEvent.f_238649_) {
                WitchAllay.this.setJukeboxPlaying(BlockPos.m_274446_((Position)vec), false);
                return true;
            }
            return false;
        }
    }
}

