/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.animal;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.ientity.IGolem;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.EntityInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.animal.AbstractSummonMob;
import sweetmagic.util.PlayerHelper;
import sweetmagic.util.SMDamage;

public class WitchGolem
extends AbstractSummonMob
implements IGolem {
    private static final EntityDataAccessor<Integer> ATTACK_TICK = ISMMob.setData(WitchGolem.class, ISMMob.INT);

    public WitchGolem(Level world) {
        super(EntityInit.witchGolem, world);
    }

    public WitchGolem(EntityType<? extends AbstractSummonMob> eType, Level world) {
        super(eType, world);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(ATTACK_TICK, 0);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22284_, 0.2).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 48.0);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(5, (Goal)new AbstractSummonMob.SMRandomMoveGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new AbstractSummonMob.SMFollowOwnerGoal(this, 1.0, 10.0f, 2.0f));
        this.f_21345_.m_25352_(7, (Goal)new AbstractSummonMob.SMLookPlayerGoal(this, Monster.class, false));
        this.f_21345_.m_25352_(8, (Goal)new AbstractSummonMob.SMLookPlayerGoal(this, Player.class, true));
        this.f_21345_.m_25352_(9, (Goal)new AbstractSummonMob.SMRandomLookAroundGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new AbstractSummonMob.SMOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new AbstractSummonMob.SMOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(4, new AbstractSummonMob.SMMobAttackGoal<Monster>(this, Monster.class, false));
        this.f_21346_.m_25352_(5, new AbstractSummonMob.AttackTargetGoal<Raider>(this, Raider.class, false));
        this.f_21346_.m_25352_(6, new AbstractSummonMob.AttackTargetGoal<Warden>(this, Warden.class, false));
        this.f_21346_.m_25352_(7, new AbstractSummonMob.AttackTargetGoal<Slime>(this, Slime.class, false));
    }

    protected SoundEvent m_7975_(DamageSource src) {
        return SoundEvents.f_12008_;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_12010_, 1.0f, 0.5f);
    }

    public void setAttackTick(int attackTick) {
        this.set(ATTACK_TICK, attackTick);
    }

    @Override
    public int getAttackTick() {
        return this.get(ATTACK_TICK);
    }

    public boolean m_6549_(EntityType<?> eType) {
        return eType == EntityType.f_20532_ || eType == EntityType.f_20558_ ? false : super.m_6549_(eType);
    }

    @Override
    public void hurtAction(Entity attacker, float amount) {
        boolean isBoss;
        if (amount < 2.0f) {
            return;
        }
        DamageSource src = SMDamage.getAddDamage((Entity)this);
        if (attacker instanceof EnderMan || attacker instanceof Witch) {
            src = SMDamage.getPlayerDamage((Entity)((Player)this.m_269323_()));
        }
        amount = (isBoss = this.isBoss(attacker)) ? Math.min(2.0f, amount) : Math.min(10.0f, amount);
        float effecRate = 1.0f + (float)PlayerHelper.getEffectList((LivingEntity)this, PotionInit.BUFF).size() * 0.1f;
        attacker.m_6469_(src, (isBoss ? amount * 0.04f : amount * 0.2f) * effecRate);
        attacker.f_19802_ = 0;
        if (effecRate > 0.0f) {
            this.m_5634_(amount * 0.05f * effecRate);
        }
    }

    @Override
    public boolean m_7327_(Entity entity) {
        this.setAttackTick(10);
        DamageSource src = SMDamage.getAddDamage((Entity)this);
        float damage = (float)this.m_21133_(Attributes.f_22281_);
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, this.isTarget(), 3.5 + (double)this.getRange());
        boolean flag1 = false;
        for (LivingEntity livingEntity : entityList) {
            float dame = damage;
            if (livingEntity instanceof Warden) {
                dame *= 4.0f;
            } else if (livingEntity instanceof EnderMan || livingEntity instanceof Witch) {
                src = SMDamage.getPlayerDamage((Entity)((Player)this.m_269323_()));
            } else if (this.isBoss((Entity)livingEntity)) {
                dame *= 0.25f;
            }
            boolean flag2 = livingEntity.m_6469_(src, dame);
            livingEntity.f_19802_ = 0;
            if (!flag2) continue;
            this.m_19970_((LivingEntity)this, (Entity)livingEntity);
            flag1 = flag2;
        }
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            BlockPos blockPos = this.m_20183_();
            BlockState state = this.m_9236_().m_8055_(blockPos.m_7495_());
            BlockParticleOption par = new BlockParticleOption(ParticleTypes.f_123794_, state);
            for (int i = 0; i < 4; ++i) {
                BlockPos pos2 = new BlockPos(blockPos.m_123341_(), blockPos.m_123342_() - 2 + i, blockPos.m_123343_());
                this.spawnParticleRing(server, (ParticleOptions)par, 1.75, pos2, 1.25, 0.1, 0.0);
                this.spawnParticleRing(server, (ParticleOptions)par, 4.0, pos2, 1.25, 0.1, 0.0);
            }
        }
        return flag1;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % 20 != 0 && !this.m_6084_() || this.getShit()) {
            return;
        }
        List<Monster> entityList = this.getEntityList(Monster.class, this.isTarget(), 32.0 + (double)this.getRange());
        for (Monster entity : entityList) {
            if (!(entity.m_5448_() instanceof Player)) continue;
            entity.m_6710_((LivingEntity)this);
            entity.m_6703_((LivingEntity)this);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        int attackTick = this.getAttackTick();
        if (attackTick > 0) {
            this.setAttackTick(attackTick - 1);
        }
        if (this.m_20184_().m_165925_() > 2.500000277905201E-7 && this.rand.nextInt(5) == 0) {
            int x = Mth.m_14107_((double)this.m_20185_());
            int y = Mth.m_14107_((double)(this.m_20186_() - (double)0.2f));
            int k = Mth.m_14107_((double)this.m_20189_());
            BlockPos pos = new BlockPos(x, y, k);
            BlockState state = this.m_9236_().m_8055_(pos);
            if (!state.m_60795_()) {
                BlockParticleOption par = new BlockParticleOption(ParticleTypes.f_123794_, state).setPos(pos);
                double xP = this.m_20185_() + ((double)this.getRand() - 0.5) * (double)this.m_20205_();
                double yP = this.m_20186_() + 0.1;
                double zP = this.m_20189_() + ((double)this.getRand() - 0.5) * (double)this.m_20205_();
                double xSpeed = 4.0 * ((double)this.getRand() - 0.5);
                double zSpeed = 4.0 * ((double)this.getRand() - 0.5);
                this.m_9236_().m_7106_((ParticleOptions)par, xP, yP, zP, xSpeed, 0.5, zSpeed);
            }
        }
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.875f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }
}

