/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.animal;

import java.util.List;
import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.ientity.IKitt;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.EntityInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.SoundInit;
import sweetmagic.init.TagInit;
import sweetmagic.init.entity.animal.AbstractSummonMob;
import sweetmagic.init.entity.projectile.AbstractMagicShot;
import sweetmagic.init.entity.projectile.CycloneMagicShot;
import sweetmagic.init.entity.projectile.ExplosionMagicShot;
import sweetmagic.init.entity.projectile.FireMagicShot;
import sweetmagic.init.entity.projectile.FrostMagicShot;
import sweetmagic.init.entity.projectile.RockBlastMagicShot;

public class WitchKitt
extends AbstractSummonMob
implements IKitt {
    protected int healRecstTime = 150;
    protected int magicRecastTime = 200;
    protected int magicAttackCount = 0;
    public AnimationState healState = new AnimationState();
    private static final EntityDataAccessor<Boolean> GADGET = ISMMob.setData(WitchKitt.class, ISMMob.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HEAL = ISMMob.setData(WitchKitt.class, ISMMob.BOOLEAN);

    public WitchKitt(Level world) {
        super(EntityInit.witchKitt, world);
    }

    public WitchKitt(EntityType<? extends AbstractSummonMob> eType, Level world) {
        super(eType, world);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(GADGET, false);
        this.define(HEAL, false);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22280_, 0.2).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22278_, 16.0).m_22268_(Attributes.f_22277_, 48.0);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(3, (Goal)new GedgewtMoveGoal(this));
    }

    @Override
    public boolean getGadget() {
        return this.get(GADGET);
    }

    public void setGadget(boolean gadget) {
        this.set(GADGET, gadget);
    }

    public boolean getHeal() {
        return this.get(HEAL);
    }

    public void setHeal(boolean heal) {
        this.set(HEAL, heal);
    }

    public void m_7822_(byte par1) {
        switch (par1) {
            case 4: {
                this.healState.m_216973_();
                break;
            }
            case 5: {
                this.healState.m_216977_(this.f_19797_);
                break;
            }
            default: {
                super.m_7822_(par1);
            }
        }
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11785_;
    }

    protected SoundEvent m_7975_(DamageSource src) {
        return SoundEvents.f_11791_;
    }

    protected float m_6121_() {
        return 0.4f;
    }

    @Override
    public AnimationState getHealAnimaState() {
        return this.healState;
    }

    @Override
    public void m_7380_(CompoundTag tags) {
        super.m_7380_(tags);
        tags.m_128405_("healRecstTime", this.healRecstTime);
        tags.m_128405_("magicRecastTime", this.magicRecastTime);
        tags.m_128405_("magicAttackCount", this.magicAttackCount);
        tags.m_128379_("gadget", this.getGadget());
        tags.m_128379_("heal", this.getHeal());
    }

    @Override
    public void m_7378_(CompoundTag tags) {
        super.m_7378_(tags);
        this.healRecstTime = tags.m_128451_("healRecstTime");
        this.magicRecastTime = tags.m_128451_("magicRecastTime");
        this.magicAttackCount = tags.m_128451_("magicAttackCount");
        this.setGadget(tags.m_128471_("gadget"));
        this.setHeal(tags.m_128471_("heal"));
    }

    @Override
    public boolean m_6469_(DamageSource src, float amount) {
        if (this.getGadget()) {
            amount *= 0.1f;
        }
        return super.m_6469_(src, amount);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.healAction();
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        LivingEntity target = this.m_5448_();
        if (target == null || this.getShit()) {
            this.clearInfo();
            return;
        }
        if (this.getHeal()) {
            return;
        }
        if (this.magicRecastTime > 0) {
            --this.magicRecastTime;
        }
        this.m_21563_().m_24960_((Entity)target, 20.0f, 20.0f);
        if (this.magicRecastTime - 200 == 0) {
            this.setGadget(true);
        }
        LivingEntity owner = this.m_269323_();
        if (this.getGadget() && owner != null) {
            Level y2;
            if (this.m_20186_() < owner.m_20186_() || this.m_20186_() < owner.m_20186_() + 2.5) {
                Vec3 vec = this.m_20184_();
                double y2 = Math.max(0.0, vec.f_82480_);
                y2 *= 0.25;
                y2 += (0.5 - y2) * 0.25;
                this.m_20256_(new Vec3(vec.f_82479_, y2, vec.f_82481_));
            }
            if (this.f_19797_ % 2 == 0 && (y2 = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)y2;
                Vec3 src = new Vec3(this.m_20185_(), this.m_20186_() - 1.0, this.m_20189_()).m_82520_(0.0, (double)this.m_20192_(), 0.0);
                Vec3 look = this.m_20252_(1.0f);
                Vec3 dest = src.m_82520_(look.f_82479_ * -0.5, look.f_82480_, look.f_82481_ * -0.5);
                server.m_8767_((ParticleOptions)ParticleTypes.f_123796_, dest.f_82479_, dest.f_82480_, dest.f_82481_, 0, (double)this.getRand(0.03f), -0.15, (double)this.getRand(0.03f), 1.0);
                if (this.f_19797_ % 4 == 0) {
                    server.m_8767_((ParticleOptions)ParticleTypes.f_123744_, dest.f_82479_, dest.f_82480_, dest.f_82481_, 0, (double)this.getRand(0.05f), -0.15, (double)this.getRand(0.05f), 1.0);
                }
            }
        }
        if (this.magicRecastTime > 0) {
            return;
        }
        this.magicAction(target, target instanceof Warden);
    }

    public void healAction() {
        if (this.isClient() || this.getGadget() || this.getShit()) {
            return;
        }
        if (this.healRecstTime > 0) {
            int time = this.m_5448_() == null ? 1 : 4;
            this.healRecstTime -= time;
            if (this.healRecstTime <= 32 && !this.getHeal()) {
                this.m_9236_().m_7605_((Entity)this, (byte)5);
                this.setHeal(true);
            }
            if (this.healRecstTime > 0) {
                return;
            }
        }
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, (T e) -> e.m_6084_() && (e instanceof Player || e instanceof AbstractSummonMob), this.getRange() * 2.0f);
        for (LivingEntity entity : entityList) {
            float healRate;
            float maxHealth = entity.m_21233_();
            boolean isPlayer = entity instanceof Player;
            if (entity.m_21223_() <= maxHealth / 2.0f) {
                healRate = isPlayer ? 0.0875f : 0.15f;
                entity.m_5634_(maxHealth * healRate);
                if (isPlayer) {
                    entity.m_5496_(SoundInit.HEAL, 0.0625f, 1.0f);
                }
                double pX = entity.m_20185_();
                double pY = entity.m_20186_();
                double pZ = entity.m_20189_();
                for (int i = 0; i < 3; ++i) {
                    this.spawnParticleRing(this.m_9236_(), (ParticleOptions)ParticleTypes.f_123748_, 1.0, pX, pY, pZ, 0.75 + (double)i * 0.5, 1.0, 1.0);
                }
                continue;
            }
            if (entity.m_21223_() >= maxHealth) {
                this.addPotion(entity, PotionInit.aether_armor, 600, 2);
                this.addPotion(entity, MobEffects.f_19600_, 600, 1);
                continue;
            }
            healRate = isPlayer ? 0.01f : 0.05f;
            entity.m_5634_(maxHealth * healRate);
            this.addPotion(entity, PotionInit.aether_armor, 600, 1);
            this.addPotion(entity, MobEffects.f_19600_, 600, 2);
            if (!isPlayer) continue;
            entity.m_5496_(SoundEvents.f_11887_, 0.025f, 1.175f);
        }
        this.setHeal(false);
        this.healRecstTime = 800;
        this.m_9236_().m_7605_((Entity)this, (byte)4);
    }

    public void magicAction(LivingEntity target, boolean isWarden) {
        int count = this.magicAttackCount;
        List<Object> entityList = this.getEntityList(LivingEntity.class, (T e) -> e instanceof Enemy, 24.0);
        entityList = entityList.stream().sorted((s1, s2) -> this.sortEntity((Entity)this, (Entity)s1, (Entity)s2)).toList();
        this.m_5496_(SoundEvents.f_11705_, 0.5f, 0.67f);
        if (entityList.size() <= 1) {
            this.magicShot(target, count, true);
        } else {
            int maxCount = Math.min(5, entityList.size());
            for (int i = 0; i < maxCount; ++i) {
                LivingEntity entity = (LivingEntity)entityList.get(i);
                if (entity == null || !entity.m_6084_()) continue;
                this.magicShot(entity, count, isWarden);
            }
        }
        if (++this.magicAttackCount > 4) {
            this.clearInfo();
        } else {
            this.magicRecastTime += 10;
        }
    }

    public void magicShot(LivingEntity target, int count, boolean isWarden) {
        float dama = this.getPower(this.getWandLevel()) + (float)this.m_21133_(Attributes.f_22281_) * 0.33f;
        float dameRate = isWarden ? 2.0f : 1.0f;
        double x = target.m_20185_() - this.m_20185_();
        double y = target.m_20227_(0.3333333333333333) - this.m_20186_();
        double z = target.m_20189_() - this.m_20189_();
        double xz = Math.sqrt(x * x + z * z);
        int level = isWarden ? this.getWandLevel() + 20 : this.getWandLevel();
        AbstractMagicShot entity = this.getMagicShot(count);
        entity.setData(2);
        entity.setRange(6.0 + (double)this.getRange());
        entity.setWandLevel(level);
        entity.m_6686_(x, y - xz * 0.035, z, 2.25f, 0.0f);
        entity.setAddDamage((entity.getAddDamage() + dama) * dameRate);
        this.m_9236_().m_7967_((Entity)entity);
    }

    public void clearInfo() {
        this.magicAttackCount = 0;
        this.magicRecastTime = 300 + this.rand.nextInt(100);
        this.setGadget(false);
    }

    public AbstractMagicShot getMagicShot(int count) {
        return switch (count) {
            case 1 -> new FrostMagicShot((LivingEntity)this);
            case 2 -> new CycloneMagicShot((LivingEntity)this);
            case 3 -> new ExplosionMagicShot((LivingEntity)this);
            case 4 -> new RockBlastMagicShot((LivingEntity)this);
            default -> new FireMagicShot((LivingEntity)this);
        };
    }

    public int sortEntity(Entity mob, Entity entity1, Entity entity2) {
        double distance2;
        if (entity1 == null || entity2 == null) {
            return 0;
        }
        boolean isBoss1 = entity1.m_6095_().m_204039_(TagInit.BOSS);
        boolean isBoss2 = entity2.m_6095_().m_204039_(TagInit.BOSS);
        if (isBoss1 && isBoss2) {
            return 0;
        }
        if (isBoss1) {
            return -1;
        }
        if (isBoss2) {
            return 1;
        }
        double distance1 = mob.m_20280_(entity1);
        if (distance1 > (distance2 = mob.m_20280_(entity2))) {
            return 1;
        }
        if (distance1 < distance2) {
            return -1;
        }
        return 0;
    }

    public class GedgewtMoveGoal
    extends Goal {
        private final WitchKitt mob;
        private final float maxDist = 256.0f;

        public GedgewtMoveGoal(WitchKitt mob) {
            this.mob = mob;
        }

        public boolean m_8036_() {
            return this.mob.getGadget() && !this.mob.isEmptyTarget();
        }

        public void m_8037_() {
            LivingEntity target = this.mob.m_5448_();
            double dist = this.mob.m_20280_((Entity)target);
            Objects.requireNonNull(this);
            if (dist > 256.0) {
                Vec3 vec = new Vec3(target.f_19854_ - this.mob.f_19854_, 0.0, target.f_19856_ - this.mob.f_19856_);
                this.mob.m_20256_(this.mob.m_20184_().m_82549_(vec.m_82490_(0.05 / vec.m_82553_())));
                Vec3 vec1 = this.mob.m_20184_();
                this.mob.m_146922_(-((float)Mth.m_14136_((double)vec1.f_82479_, (double)vec1.f_82481_)) * 57.295776f);
                this.mob.f_20883_ = this.mob.m_146908_();
            }
        }
    }
}

