/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.block;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import sweetmagic.api.util.ISMTip;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.block.Hitbox;

public class Broom
extends Entity
implements ISMTip {
    private float forward;
    private float strafe;
    private boolean jump = false;
    private boolean fall = false;
    private boolean oldJump = false;
    private float forwardPower = 0.0f;
    private Hitbox frontHitbox;
    private Hitbox backHitbox;
    private CompoundTag nbt = null;
    private static final EntityDataAccessor<ItemStack> STACK = SynchedEntityData.m_135353_(Broom.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Integer> MF = SynchedEntityData.m_135353_(Broom.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> COSTDOWN = SynchedEntityData.m_135353_(Broom.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> HIDE = SynchedEntityData.m_135353_(Broom.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HOVER = SynchedEntityData.m_135353_(Broom.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> FORWARDPOWER = SynchedEntityData.m_135353_(Broom.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public Broom(Level world, ItemStack stack) {
        super(EntityInit.broom, world);
        this.setStack(stack);
    }

    public Broom(EntityType<? extends Broom> type, Level level) {
        super(type, level);
        this.f_19794_ = false;
        this.m_274367_(1.25f);
    }

    public AABB m_6921_() {
        return this.m_20191_().m_82377_(0.0, 0.0, 1.0);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(STACK, (Object)ItemStack.f_41583_);
        this.m_20088_().m_135372_(MF, (Object)0);
        this.m_20088_().m_135372_(COSTDOWN, (Object)0);
        this.m_20088_().m_135372_(FORWARDPOWER, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(HIDE, (Object)false);
        this.m_20088_().m_135372_(HOVER, (Object)false);
    }

    public ItemStack getStack() {
        ItemStack stack = (ItemStack)this.m_20088_().m_135370_(STACK);
        return stack.m_41619_() ? new ItemStack((ItemLike)ItemInit.broom) : stack;
    }

    public void setStack(ItemStack stack) {
        this.m_20088_().m_135381_(STACK, (Object)stack);
    }

    public int getMF() {
        return (Integer)this.m_20088_().m_135370_(MF);
    }

    public void setMF(int mf) {
        this.m_20088_().m_135381_(MF, (Object)mf);
    }

    public int getCostDown() {
        return (Integer)this.m_20088_().m_135370_(COSTDOWN);
    }

    public void setCostDown(int costDown) {
        this.m_20088_().m_135381_(COSTDOWN, (Object)costDown);
    }

    public float getFowardPower() {
        return ((Float)this.m_20088_().m_135370_(FORWARDPOWER)).floatValue();
    }

    public void setFowardPower(float forwardPower) {
        this.m_20088_().m_135381_(FORWARDPOWER, (Object)Float.valueOf(forwardPower));
    }

    public boolean getHide() {
        return (Boolean)this.m_20088_().m_135370_(HIDE);
    }

    public void setHide(boolean hide) {
        this.m_20088_().m_135381_(HIDE, (Object)hide);
    }

    public boolean getHover() {
        return (Boolean)this.m_20088_().m_135370_(HOVER);
    }

    public void setHover(boolean hover) {
        this.m_20088_().m_135381_(HOVER, (Object)hover);
    }

    public CompoundTag getNBT() {
        return this.nbt;
    }

    public void setNBT(CompoundTag nbt) {
        this.nbt = nbt;
    }

    protected void m_7378_(CompoundTag tags) {
        this.setStack(ItemStack.m_41712_((CompoundTag)tags.m_128469_("stack")));
        this.setMF(tags.m_128451_("mf"));
        this.setCostDown(tags.m_128451_("costDown"));
        this.setFowardPower(tags.m_128457_("forwardPower"));
        this.setHide(tags.m_128471_("isHideTip"));
        this.setHover(tags.m_128471_("hover"));
        this.nbt = tags.m_128469_("nbt");
    }

    protected void m_7380_(CompoundTag tags) {
        tags.m_128365_("stack", (Tag)this.getStack().m_41739_(new CompoundTag()));
        tags.m_128405_("mf", this.getMF());
        tags.m_128405_("costDown", this.getCostDown());
        tags.m_128350_("forwardPower", this.getFowardPower());
        tags.m_128379_("isHideTip", this.getHide());
        tags.m_128379_("hover", this.getHover());
        tags.m_128365_("nbt", (Tag)this.nbt);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public double m_6048_() {
        return 0.3 + Math.sin((double)this.f_19797_ * 0.1) * 0.02;
    }

    public final InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player.m_6144_()) {
            this.dropItem(this.m_9236_(), player.m_20183_());
        } else {
            player.m_20329_((Entity)this);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean m_6469_(DamageSource src, float amount) {
        Entity attacker = src.m_7639_();
        if (attacker == null || !(attacker instanceof Player)) {
            return false;
        }
        this.dropItem(this.m_9236_(), this.m_20183_());
        return true;
    }

    public void dropItem(Level world, BlockPos pos) {
        if (world.m_5776_() || this.m_213877_()) {
            return;
        }
        if (world instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)world;
            this.discordParticle(server);
        }
        ItemStack stack = this.getStack().m_41777_();
        stack.m_41751_(this.getNBT());
        CompoundTag tags = stack.m_41784_();
        tags.m_128405_("mf", this.getMF());
        tags.m_128379_("hide", this.getHide());
        tags.m_128379_("hover", this.getHover());
        world.m_7967_((Entity)new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack));
        this.m_146870_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            Level vec;
            Entity entity;
            if (this.m_20160_() && (entity = this.m_146895_()) instanceof Player) {
                Player player = (Player)entity;
                if (this.strafe != 0.0f != this.oldJump) {
                    boolean bl = this.oldJump = !this.oldJump;
                    if (this.oldJump) {
                        this.setHover(!this.getHover());
                        MutableComponent tip = this.getText("broom_hover", new Object[]{this.getHover() ? "on" : "off"}).m_130940_(GOLD);
                        player.m_5661_((Component)tip, true);
                    }
                }
                this.controlBroom(player);
                vec = this.m_20184_();
                this.m_20256_(new Vec3(vec.f_82479_ * (double)0.85f, vec.f_82480_ * (double)0.65f, vec.f_82481_ * (double)0.85f));
                if (!player.m_7500_() && this.f_19797_ % 100 == 0) {
                    this.shrinkMF();
                }
                if (this.fall) {
                    this.fall = false;
                }
            } else {
                this.forwardPower = 0.0f;
                this.m_20256_(Vec3.f_82478_);
            }
            if (!(this.jump || this.fall || !(this.forwardPower <= 0.0f) || this.getHover() || this.m_20069_() || this.m_20077_())) {
                double addY = this.m_20160_() ? -0.05 : -0.25;
                this.m_20256_(this.m_20184_().m_82520_(0.0, addY, 0.0));
            }
            if (this.forwardPower > 0.0f && (vec = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)vec;
                RandomSource rand = this.m_9236_().m_213780_();
                Vec3 vec2 = this.m_20252_(-1.0f);
                Vec3 dest = this.m_20184_().m_82520_(vec2.f_82479_ * 2.0, 0.0, vec2.f_82481_ * 2.0);
                float x = (float)(this.f_19854_ - dest.f_82479_) - 0.5f + rand.m_188501_();
                float y = (float)this.f_19855_ - 0.4f + rand.m_188501_() * 0.5f + 1.0f;
                float z = (float)(this.f_19856_ - dest.f_82481_) - 0.5f + rand.m_188501_();
                float f1 = (float)(-vec2.f_82479_) * 0.5f;
                float f2 = -0.025f + (float)(-vec2.f_82480_) * 0.5f;
                float f3 = (float)(-vec2.f_82481_) * 0.5f;
                server.m_8767_((ParticleOptions)ParticleTypes.f_123810_, (double)x, (double)y, (double)z, 0, (double)f1, (double)f2, (double)f3, 1.0);
            }
        }
        this.frontHitbox = this.checkHitbox(this.frontHitbox, 1.0);
        this.backHitbox = this.checkHitbox(this.backHitbox, -1.0);
        this.m_6478_(MoverType.SELF, this.m_20184_());
    }

    public Hitbox checkHitbox(Hitbox hit, double offset) {
        if (hit == null || !hit.m_6084_()) {
            hit = new Hitbox(this.m_9236_(), this, offset);
            hit.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            if (!this.m_9236_().m_5776_()) {
                this.m_9236_().m_7967_((Entity)hit);
            }
        }
        return hit;
    }

    public void controlBroom(Player player) {
        float rotY;
        Vec3 vec;
        float f;
        this.m_146922_(player.m_146908_());
        double addY = 0.0;
        if (this.forward > 0.0f) {
            this.forwardPower = Math.min(50.0f, this.forwardPower + this.forward);
        } else if (this.forward < 0.0f) {
            this.forwardPower = Math.max(0.0f, this.forwardPower + this.forward * 1.5f);
        }
        if (this.jump) {
            addY = 0.2;
        } else if (this.fall) {
            addY = -0.3;
        }
        if (player.m_21023_(PotionInit.non_destructive)) {
            this.forwardPower = 0.0f;
            addY = -0.2;
            f = this.forwardPower * 0.005f;
            vec = this.m_20184_();
            rotY = this.m_146908_() * (float)Math.PI / 180.0f;
            this.m_20256_(vec.m_82520_((double)(Mth.m_14031_((float)(-rotY)) * f), addY, (double)(Mth.m_14089_((float)rotY) * f)));
        }
        if (this.canControl(player)) {
            this.setFowardPower(this.forwardPower);
            f = this.forwardPower * 0.005f;
            vec = this.m_20184_();
            rotY = this.m_146908_() * (float)Math.PI / 180.0f;
            this.m_20256_(vec.m_82520_((double)(Mth.m_14031_((float)(-rotY)) * f), addY, (double)(Mth.m_14089_((float)rotY) * f)));
        }
    }

    public void shrinkMF() {
        float useMFRate = 1.0f - (float)this.getCostDown() * 0.07f;
        int mf = (int)(this.forwardPower * 2.0f * useMFRate);
        this.setMF(Math.max(0, this.getMF() - mf));
    }

    public boolean canControl(Player player) {
        return player.m_7500_() || this.getMF() > 0;
    }

    protected boolean m_7310_(Entity entity) {
        return entity instanceof Player && this.m_20197_().size() < 2;
    }

    protected void m_19956_(Entity entity, Entity.MoveFunction move) {
        double offset;
        if (!this.m_20363_(entity)) {
            return;
        }
        Vec3 base = this.m_20182_();
        float yaw = this.m_146908_() * ((float)Math.PI / 180);
        int index = this.m_20197_().indexOf(entity);
        double d = offset = index == 0 ? -0.8 : 0.15;
        if (this.m_20197_().size() == 1) {
            offset = -0.4;
        }
        double xOffset = Math.sin(yaw) * offset;
        double zOffset = -Math.cos(yaw) * offset;
        entity.m_5618_(this.m_146908_() - 90.0f);
        move.m_20372_(entity, base.f_82479_ + xOffset, base.f_82480_ + this.m_6048_(), base.f_82481_ + zOffset);
    }

    public void discordParticle(ServerLevel server) {
        Random rand = new Random();
        BlockPos pos = this.m_20183_().m_7494_();
        SimpleParticleType par = ParticleTypes.f_123796_;
        for (int i = 0; i < 16; ++i) {
            double x = this.m_20185_() + this.getRand(rand) * 0.75;
            double y = this.m_20186_() + this.getRand(rand) * 0.25 + 0.25;
            double z = this.m_20189_() + this.getRand(rand) * 0.75;
            double xS = this.getRand(rand) * 0.2;
            double yS = (double)rand.nextFloat() * 0.2;
            double zS = this.getRand(rand) * 0.2;
            server.m_8767_((ParticleOptions)par, x, y, z, 0, xS, yS + 0.1, zS, 1.0);
        }
    }

    public double getRand(Random rand) {
        return rand.nextDouble() - rand.nextDouble();
    }

    protected void clampRotation(Entity entity) {
        entity.m_5618_(this.m_146908_());
        float f = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
        float f1 = Mth.m_14036_((float)f, (float)-60.0f, (float)60.0f);
        entity.f_19859_ += f1 - f;
        entity.m_146922_(entity.m_146908_() + f1 - f);
        entity.m_5616_(entity.m_146908_());
    }

    protected void m_7840_(double par1, boolean flag, BlockState state, BlockPos pos) {
        if (this.m_20159_() || !flag) {
            return;
        }
        if (this.f_19789_ > 3.0f) {
            this.m_142535_(this.f_19789_, 1.0f, this.m_269291_().m_268989_());
        }
        this.m_183634_();
    }

    public void setInput(float forward, float strafe, boolean jump) {
        this.forward = forward;
        this.strafe = strafe;
        this.jump = jump;
    }

    public void setInput(boolean fall) {
        this.fall = fall;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

