/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.monster;

import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.monster.boss.AbstractSMBoss;
import sweetmagic.util.SMDamage;

public abstract class AbstractSMMob
extends Monster
implements ISMMob {
    protected int defTime = 0;
    protected Random rand = new Random();

    public AbstractSMMob(EntityType<? extends AbstractSMMob> enType, Level world) {
        super(enType, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new MobTargetMoveGoal(this, 1.0, 8.0f, 20.0f));
        this.f_21345_.m_25352_(10, (Goal)new AbstractSMBoss.SMRandomLookGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Warden.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    @Override
    public void refreshInfo() {
        this.m_20090_();
        this.m_6210_();
    }

    @Override
    public SynchedEntityData getData() {
        return this.m_20088_();
    }

    public <T extends Entity> List<T> getEntityList(Class<T> enClass, Predicate<T> filter, double range) {
        return this.getEntityList(enClass, (Entity)this, filter, range);
    }

    public Predicate<LivingEntity> getFilter(boolean isPlayer) {
        return isPlayer ? this.getTargetEntity() : e -> !e.m_5833_() && e.m_6084_() && !this.isPlayer((Entity)e) && !(e instanceof ISMMob) && !e.m_21023_(PotionInit.resistance_blow);
    }

    public DamageSource getSRC() {
        return this.getDamage((Entity)this, SMDamage.magicDamage);
    }

    protected boolean teleport() {
        if (!this.isClient() && this.m_6084_()) {
            double x = this.m_20185_() + (this.rand.nextDouble() - 0.5) * 32.0;
            double y = this.m_20186_() + (double)(this.rand.nextInt(32) - 16);
            double z = this.m_20189_() + (this.rand.nextDouble() - 0.5) * 32.0;
            return this.teleport(x, y, z);
        }
        return false;
    }

    protected boolean teleport(double x, double y, double z) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
        while (pos.m_123342_() > this.m_9236_().m_141937_() && !this.m_9236_().m_8055_((BlockPos)pos).m_280555_()) {
            pos.m_122173_(Direction.DOWN);
        }
        BlockState state = this.m_9236_().m_8055_((BlockPos)pos);
        boolean flag = state.m_280555_();
        boolean flag1 = state.m_60819_().m_205070_(FluidTags.f_13131_);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)x, (double)y, (double)z);
            if (event.isCanceled()) {
                return false;
            }
            Vec3 vec3 = this.m_20182_();
            boolean flag2 = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2) {
                this.m_9236_().m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)this));
                if (!this.m_20067_()) {
                    this.m_9236_().m_6263_((Player)null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
                    this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
                }
            }
            return flag2;
        }
        return false;
    }

    public void m_8119_() {
        try {
            super.m_8119_();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.defTime > 0) {
            --this.defTime;
        }
    }

    protected void m_8024_() {
        super.m_8024_();
        LivingEntity target = this.m_5448_();
        if (target == null) {
            return;
        }
        this.targetAIStep(target);
    }

    public void targetAIStep(LivingEntity target) {
    }

    public void addEntity(Entity entity) {
        this.m_9236_().m_7967_(entity);
    }

    public boolean isClient() {
        return this.m_9236_().m_5776_();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance dif, MobSpawnType spawn, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        data = super.m_6518_(world, dif, spawn, data, tag);
        this.initMobData((LivingEntity)this, dif);
        return this.finalizeSpawn(new ISMMob.SpawnInfo(world, dif, spawn, data, tag));
    }

    public SpawnGroupData finalizeSpawn(ISMMob.SpawnInfo info) {
        return info.data();
    }

    public class MobTargetMoveGoal
    extends Goal {
        private final AbstractSMMob mob;
        private final double speed;
        private final float minDist;
        private final float maxDist;

        public MobTargetMoveGoal(AbstractSMMob mob, double speed, float minDis, float maxDis) {
            this.mob = mob;
            this.speed = speed;
            this.minDist = minDis * minDis;
            this.maxDist = maxDis * maxDis;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity target = this.mob.m_5448_();
            return target != null && target.m_6084_();
        }

        public void m_8056_() {
        }

        public void m_8037_() {
            LivingEntity target = this.mob.m_5448_();
            if (target == null || !target.m_6084_()) {
                return;
            }
            double dist = this.mob.m_20280_((Entity)target);
            if (dist > (double)this.maxDist) {
                this.mob.m_21573_().m_5624_((Entity)target, this.speed);
            } else if (dist < (double)this.minDist) {
                Vec3 mobPos = this.mob.m_20182_();
                Vec3 direction = mobPos.m_82546_(target.m_20182_()).m_82541_();
                Vec3 retreatPos = mobPos.m_82549_(direction.m_82490_(2.0));
                this.mob.m_21573_().m_26519_(retreatPos.f_82479_, retreatPos.f_82480_, retreatPos.f_82481_, this.speed);
            } else {
                this.mob.m_21573_().m_26573_();
            }
        }

        public boolean m_8045_() {
            LivingEntity target = this.mob.m_5448_();
            return target != null && target.m_6084_();
        }
    }
}

