/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.monster;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.entity.monster.AbstractOwnerMob;
import sweetmagic.init.entity.monster.DwarfZombieMaster;
import sweetmagic.init.entity.projectile.AbstractMagicShot;
import sweetmagic.init.entity.projectile.RockBlastMagicShot;

public class DwarfZombie
extends AbstractOwnerMob {
    private int recastTime = 100;
    private static final int RAND_RECASTTIME = 80;
    private static final EntityDataAccessor<Boolean> SUMMON = ISMMob.setData(DwarfZombie.class, BOOLEAN);

    public DwarfZombie(Level world) {
        super(EntityInit.dwarfZombie, world);
    }

    public DwarfZombie(EntityType<DwarfZombie> enType, Level world) {
        super(enType, world);
        this.f_21364_ = 75;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.define(SUMMON, false);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.225).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22284_, 1.0).m_22268_(Attributes.f_22277_, 16.0);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12598_;
    }

    protected SoundEvent m_7975_(DamageSource src) {
        return SoundEvents.f_12608_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12603_;
    }

    public boolean m_6469_(DamageSource src, float amount) {
        if (this.isSMMobSRC(src)) {
            return false;
        }
        amount = this.getDamageAmount((Entity)this, src, amount, 0.25f);
        return super.m_6469_(src, amount);
    }

    @Override
    public void targetAIStep(LivingEntity target) {
        this.m_21563_().m_24960_((Entity)target, 10.0f, 10.0f);
        if (this.recastTime-- > 0) {
            return;
        }
        boolean isWarden = target instanceof Warden;
        this.recastTime = (int)(((float)this.rand.nextInt(80) * 0.5f + 80.0f) * (isWarden ? 0.25f : 1.0f));
        AbstractMagicShot entity = this.getMagicShot(target, isWarden);
        this.m_5496_(SoundEvents.f_11705_, 0.5f, 0.67f);
        this.addEntity((Entity)entity);
    }

    public AbstractMagicShot getMagicShot(LivingEntity target, boolean isWarden) {
        RockBlastMagicShot entity = new RockBlastMagicShot((LivingEntity)this);
        float damage = isWarden ? 13.0f : 2.0f;
        float shotSpeed = isWarden ? 5.0f : 1.5f;
        double x = target.m_20185_() - this.m_20185_();
        double y = target.m_20227_(0.3333333333333333) - this.m_20186_();
        double z = target.m_20189_() - this.m_20189_();
        double xz = Math.sqrt(x * x + z * z);
        int level = isWarden ? 20 : 7;
        entity.setWandLevel(level);
        entity.m_6686_(x, y - xz * 0.065, z, shotSpeed, 0.0f);
        entity.setAddDamage(entity.getAddDamage() + damage);
        return entity;
    }

    protected void m_6153_() {
        super.m_6153_();
        if (!this.getSummon()) {
            return;
        }
        LivingEntity entity = this.getEntity();
        if (entity == null || !(entity instanceof DwarfZombieMaster)) {
            return;
        }
        DwarfZombieMaster zombie = (DwarfZombieMaster)entity;
        zombie.getPosList().add(this.m_20183_());
    }

    @Override
    public void m_7380_(CompoundTag tags) {
        if (this.getSummon()) {
            tags.m_128379_("isSummon", this.getSummon());
        }
        super.m_7380_(tags);
    }

    @Override
    public void saveOwnerTag(CompoundTag tags) {
        if (this.getSummon()) {
            super.saveOwnerTag(tags);
        }
    }

    @Override
    public void m_7378_(CompoundTag tags) {
        this.setSummon(tags.m_128471_("isSummon"));
        super.m_7378_(tags);
    }

    @Override
    public void writeOwnerTag(CompoundTag tags) {
        if (this.getSummon()) {
            super.writeOwnerTag(tags);
        }
    }

    public boolean getSummon() {
        return (Boolean)this.get(SUMMON);
    }

    public void setSummon(boolean summonCount) {
        this.set(SUMMON, summonCount);
    }

    @Override
    public SpawnGroupData finalizeSpawn(ISMMob.SpawnInfo info) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ItemInit.alt_pick));
        return super.finalizeSpawn(info);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }
}

