/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.monster;

import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.EntityInit;
import sweetmagic.init.PotionInit;

public class ElectricCube
extends Slime
implements ISMMob {
    private static final EntityDataAccessor<Integer> SIZE = ISMMob.setData(ElectricCube.class, INT);
    private static final EntityDataAccessor<Boolean> FIXED = ISMMob.setData(ElectricCube.class, BOOLEAN);
    public static final int MIN_SIZE = 1;
    public static final int MAX_SIZE = 127;

    public ElectricCube(Level world) {
        super(EntityInit.electricCube, world);
    }

    public ElectricCube(EntityType<? extends Slime> enType, Level world) {
        super(enType, world);
        this.f_21364_ = 15;
    }

    public EntityType<? extends Slime> m_6095_() {
        return super.m_6095_();
    }

    @Override
    public void refreshInfo() {
        this.m_20090_();
        this.m_6210_();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Warden.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.45).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22277_, 24.0);
    }

    @Override
    public SynchedEntityData getData() {
        return this.m_20088_();
    }

    public boolean m_6469_(DamageSource src, float amount) {
        if (this.isSMMobSRC(src)) {
            return false;
        }
        amount = this.getDamageAmount((Entity)this, src, amount, 1.0f);
        return super.m_6469_(src, amount);
    }

    public void m_8119_() {
        super.m_8119_();
        this.f_19789_ = 0.0f;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.define(SIZE, 1);
        this.define(FIXED, false);
    }

    @VisibleForTesting
    public void m_7839_(int x, boolean y) {
        int i = Mth.m_14045_((int)x, (int)1, (int)255);
        this.setSize(i);
        this.m_21051_(Attributes.f_22276_).m_22100_((double)(i * i));
        this.m_21051_(Attributes.f_22279_).m_22100_(0.2 + 0.1 * (double)i);
        this.m_21051_(Attributes.f_22281_).m_22100_(this.getAttack(i) * (this.isHard(this.m_9236_()) ? 1.25 : 1.0));
        if (y) {
            this.m_21153_(this.m_21233_());
        }
        this.f_21364_ = i;
    }

    public double getAttack(int i) {
        return switch (i) {
            case 2 -> 1.5;
            case 4 -> 2.0;
            default -> 1.0;
        };
    }

    public void setSize(int size) {
        this.set(SIZE, size);
        this.refreshInfo();
    }

    public void setFixed() {
        this.m_20088_().m_135381_(FIXED, (Object)true);
    }

    public void m_7334_(Entity entity) {
        super.m_7334_(entity);
        if (entity instanceof Warden) {
            Warden living = (Warden)entity;
            entity.m_6469_(this.getMagicDamage((Entity)this), 13.0f * (float)((Integer)this.get(SIZE)).intValue());
            living.f_19802_ = 0;
        }
    }

    public int m_33632_() {
        return (Integer)this.get(SIZE);
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        if (SIZE.equals(data)) {
            this.m_6210_();
            this.m_146922_(this.f_20885_);
            this.f_20883_ = this.f_20885_;
            if (this.m_20069_() && this.m_217043_().m_188503_(20) == 0) {
                this.m_5841_();
            }
        }
        super.m_7350_(data);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance dif, MobSpawnType spawn, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        data = super.m_6518_(world, dif, spawn, data, tag);
        this.initMobData((LivingEntity)this, dif);
        return data;
    }

    public void m_142687_(Entity.RemovalReason remova) {
        if (this.m_21023_(PotionInit.resistance_blow) || ((Boolean)this.m_20088_().m_135370_(FIXED)).booleanValue()) {
            this.m_142467_(remova);
            this.invalidateCaps();
            return;
        }
        super.m_142687_(remova);
    }
}

